@extends('layouts.employee')

@section('title', 'Help & Support')

@section('content')
    <div class="space-y-8" x-data="{ activeTab: 'guide' }">
        <!-- Header -->
        <div
            class="bg-white rounded-2xl p-8 border border-gray-100 shadow-sm flex flex-col md:flex-row items-center justify-between gap-6">
            <div class="flex items-center gap-6">
                <div class="w-16 h-16 bg-blue-50 rounded-2xl flex items-center justify-center text-blue-600">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z">
                        </path>
                    </svg>
                </div>
                <div>
                    <h2 class="text-2xl font-bold text-gray-900 tracking-tight">Support Center</h2>
                    <p class="text-sm text-gray-500 mt-1">Operational guidelines and technical assistance.</p>
                </div>
            </div>
            <div class="flex bg-gray-100 p-1 rounded-lg">
                <button @click="activeTab = 'guide'"
                    class="px-6 py-2 text-sm font-bold rounded-md transition-all uppercase tracking-wider"
                    :class="activeTab === 'guide' ? 'bg-white text-gray-900 shadow-sm' : 'text-gray-500 hover:text-gray-900'">
                    User Guide
                </button>
                <button @click="activeTab = 'support'"
                    class="px-6 py-2 text-sm font-bold rounded-md transition-all uppercase tracking-wider"
                    :class="activeTab === 'support' ? 'bg-white text-gray-900 shadow-sm' : 'text-gray-500 hover:text-gray-900'">
                    Technical Support
                </button>
            </div>
        </div>

        <!-- Guide Section -->
        <div x-show="activeTab === 'guide'" class="grid grid-cols-1 lg:grid-cols-3 gap-8"
            x-transition:enter="transition ease-out duration-300 transform"
            x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0">
            <!-- Left Column: Navigation -->
            <div class="lg:col-span-1 space-y-4">
                <div class="bg-white rounded-xl border border-gray-100 overflow-hidden sticky top-24">
                    <nav class="flex flex-col text-sm">
                        <a href="#starting-job"
                            class="px-5 py-4 border-b border-gray-50 hover:bg-gray-50 font-bold text-gray-700 flex justify-between items-center group">
                            Starting a Job
                            <svg class="w-4 h-4 text-gray-300 group-hover:text-blue-500" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                                </path>
                            </svg>
                        </a>
                        <a href="#visual-evidence"
                            class="px-5 py-4 border-b border-gray-50 hover:bg-gray-50 font-medium text-gray-600 flex justify-between items-center group">
                            Checking In & Evidence
                            <svg class="w-4 h-4 text-gray-300 group-hover:text-blue-500" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                                </path>
                            </svg>
                        </a>
                        <a href="#reporting"
                            class="px-5 py-4 border-b border-gray-50 hover:bg-gray-50 font-medium text-gray-600 flex justify-between items-center group">
                            Reporting Incidents
                            <svg class="w-4 h-4 text-gray-300 group-hover:text-blue-500" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                                </path>
                            </svg>
                        </a>
                        <a href="#ending-job"
                            class="px-5 py-4 border-b border-gray-50 hover:bg-gray-50 font-medium text-gray-600 flex justify-between items-center group">
                            Ending a Job & Payroll
                            <svg class="w-4 h-4 text-gray-300 group-hover:text-blue-500" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                                </path>
                            </svg>
                        </a>
                        <a href="#requests"
                            class="px-5 py-4 border-b border-gray-50 hover:bg-gray-50 font-medium text-gray-600 flex justify-between items-center group">
                            Leaves & Uniforms
                            <svg class="w-4 h-4 text-gray-300 group-hover:text-blue-500" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                                </path>
                            </svg>
                        </a>
                        <a href="#patrols"
                            class="px-5 py-4 hover:bg-gray-50 font-medium text-gray-600 flex justify-between items-center group">
                            Mobile Patrol Operations
                            <svg class="w-4 h-4 text-gray-300 group-hover:text-blue-500" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                                </path>
                            </svg>
                        </a>
                    </nav>
                </div>
            </div>

            <!-- Right Column: Content -->
            <div class="lg:col-span-2 space-y-8">
                <!-- Section 1: Starting Job -->
                <div id="starting-job" class="bg-white p-8 rounded-2xl border border-gray-100 scroll-mt-24">
                    <div class="flex items-center gap-3 mb-6">
                        <div
                            class="w-10 h-10 rounded-full bg-slate-900 text-white flex items-center justify-center font-bold">
                            1</div>
                        <h3 class="text-lg font-bold text-gray-900">Starting Your Shift</h3>
                    </div>
                    <div class="prose prose-sm text-gray-500 max-w-none">
                        <p>To begin your duty, ensure you are physically present at the designated site. The system uses
                            geolocation to verify your presence.</p>
                        <ul class="list-disc pl-5 space-y-2 mt-4">
                            <li>Go to your <strong>Dashboard</strong> or <strong>Duty Roster</strong>.</li>
                            <li>Locate the job scheduled for Today under "Active Operations".</li>
                            <li>Click the <span
                                    class="px-2 py-0.5 bg-slate-900 text-white rounded text-[10px] font-bold uppercase">Start
                                    Job</span> button.</li>
                            <li>Allow browser location permissions if prompted.</li>
                        </ul>
                        <div class="bg-amber-50 border-l-4 border-amber-500 p-4 mt-4 rounded-r-lg">
                            <p class="text-xs text-amber-700 font-bold">Important: You cannot start a new job if you
                                currently have another active job running. Ensure you end your previous shift first.</p>
                        </div>
                    </div>
                </div>

                <!-- Section 2: Visual Evidence -->
                <div id="visual-evidence" class="bg-white p-8 rounded-2xl border border-gray-100 scroll-mt-24">
                    <div class="flex items-center gap-3 mb-6">
                        <div
                            class="w-10 h-10 rounded-full bg-slate-900 text-white flex items-center justify-center font-bold">
                            2</div>
                        <h3 class="text-lg font-bold text-gray-900">Check-In & Visual Evidence</h3>
                    </div>
                    <div class="prose prose-sm text-gray-500 max-w-none">
                        <p>Immediately after starting your job, you must provide visual proof of your presence and uniform
                            compliance.</p>
                        <h4 class="font-bold text-gray-800 mt-4 mb-2">Check-In Images</h4>
                        <p>Upload photos of yourself in full uniform at the site entrance or designated post. This confirms
                            your arrival.</p>
                        <h4 class="font-bold text-gray-800 mt-4 mb-2">Check-Out Images</h4>
                        <p>At the end of your shift, before clicking "End Job", upload photos of the site condition to prove
                            everything is secure.</p>
                        <div class="bg-blue-50 border-l-4 border-blue-500 p-4 mt-4 rounded-r-lg">
                            <p class="text-xs text-blue-700 font-bold">Why Mandatory? These images are used to calculate
                                your payroll accuracy and serve as legal proof of service delivery to the client.</p>
                        </div>
                    </div>
                </div>

                <!-- Section 3: Reporting -->
                <div id="reporting" class="bg-white p-8 rounded-2xl border border-gray-100 scroll-mt-24">
                    <div class="flex items-center gap-3 mb-6">
                        <div
                            class="w-10 h-10 rounded-full bg-slate-900 text-white flex items-center justify-center font-bold">
                            3</div>
                        <h3 class="text-lg font-bold text-gray-900">Reporting Incidents</h3>
                    </div>
                    <div class="prose prose-sm text-gray-500 max-w-none">
                        <p>If you observe any suspicious activity, maintenance issues, or safety hazards:</p>
                        <ul class="list-disc pl-5 space-y-2 mt-4">
                            <li>Click the <span
                                    class="px-2 py-0.5 bg-white border border-gray-200 text-gray-700 rounded text-[10px] font-bold uppercase">Report
                                    Incident</span> button on your active job card.</li>
                            <li>Select the appropriate Category (e.g., Theft, Vandalism, Maintenance).</li>
                            <li>Provide a clear Title and detailed Description.</li>
                            <li>Attach photos as evidence.</li>
                        </ul>
                    </div>
                </div>

                <!-- Section 4: Ending Job -->
                <div id="ending-job" class="bg-white p-8 rounded-2xl border border-gray-100 scroll-mt-24">
                    <div class="flex items-center gap-3 mb-6">
                        <div
                            class="w-10 h-10 rounded-full bg-slate-900 text-white flex items-center justify-center font-bold">
                            4</div>
                        <h3 class="text-lg font-bold text-gray-900">Ending Job & Payroll</h3>
                    </div>
                    <div class="prose prose-sm text-gray-500 max-w-none">
                        <p>Once your shift is over:</p>
                        <ol class="list-decimal pl-5 space-y-2 mt-4">
                            <li>Ensure you have uploaded <strong>Check-Out Images</strong>.</li>
                            <li>Click the <span
                                    class="px-2 py-0.5 bg-red-600 text-white rounded text-[10px] font-bold uppercase">End
                                    Job</span> button.</li>
                        </ol>
                        <h4 class="font-bold text-gray-800 mt-4 mb-2">Payroll Calculation</h4>
                        <p>Your pay is calculated based on the <strong>actual duration</strong> between your 'Start Job' and
                            'End Job' timestamps, not the scheduled time. Ensure you clock in and out precisely to avoid pay
                            discrepancies.</p>
                        <p class="mt-2"><strong>Cancellation:</strong> You can only cancel jobs categorized as "Upcoming".
                            Jobs labeled "Today" or those already in progress cannot be self-cancelled; contact support.</p>
                    </div>
                </div>

                <!-- Section 5: Requests -->
                <div id="requests" class="bg-white p-8 rounded-2xl border border-gray-100 scroll-mt-24">
                    <div class="flex items-center gap-3 mb-6">
                        <div
                            class="w-10 h-10 rounded-full bg-slate-900 text-white flex items-center justify-center font-bold">
                            5</div>
                        <h3 class="text-lg font-bold text-gray-900">Requests (Leave & Uniforms)</h3>
                    </div>
                    <div class="prose prose-sm text-gray-500 max-w-none">
                        <p>To request time off or new gear:</p>
                        <ul class="list-disc pl-5 space-y-2 mt-4">
                            <li>Navigate to <strong>Requests & Messages</strong> in the sidebar.</li>
                            <li>Click "New Request".</li>
                            <li>Choose <strong>Leave</strong> for time off or <strong>Uniform</strong> for equipment.</li>
                            <li>Fill in the details and submit. Track status in the same dashboard.</li>
                        </ul>
                    </div>
                </div>

                <!-- Section 6: Patrols -->
                <div id="patrols" class="bg-white p-8 rounded-2xl border border-gray-100 scroll-mt-24">
                    <div class="flex items-center gap-3 mb-6">
                        <div
                            class="w-10 h-10 rounded-full bg-slate-900 text-white flex items-center justify-center font-bold">
                            6</div>
                        <h3 class="text-lg font-bold text-gray-900">Mobile Patrol Operations</h3>
                    </div>
                    <div class="prose prose-sm text-gray-500 max-w-none">
                        <p>For mobile guards assigned to patrol routes:</p>
                        <ul class="list-disc pl-5 space-y-2 mt-4">
                            <li>Go to <strong>Patrol Roaster</strong>.</li>
                            <li>Start the Patrol Route similar to a regular job.</li>
                            <li>At each site visit, click <strong>Check-In</strong> to mark arrival.</li>
                            <li>Perform inspections and issue <strong>Tickets</strong> for parking violations or security
                                breaches if needed.</li>
                            <li>Click <strong>Check-Out</strong> when leaving the specific site.</li>
                            <li>Repeat for all sites in the route.</li>
                            <li>Click <strong>End Patrol</strong> only when the entire route is complete.</li>
                        </ul>
                    </div>
                </div>

            </div>
        </div>

        <!-- Technical Support Form -->
        <div x-show="activeTab === 'support'" x-transition:enter="transition ease-out duration-300 transform"
            x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0">
            <div class="max-w-2xl mx-auto bg-white rounded-2xl border border-gray-100 shadow-xl overflow-hidden">
                <div class="bg-slate-900 px-8 py-8 text-center">
                    <h3 class="text-2xl font-bold text-white mb-2">Technical Support</h3>
                    <p class="text-blue-200 text-sm">Facing app issues? Let our IT team know directly.</p>
                </div>
                <div class="p-8">
                    <form action="{{ route('employee.support.submit') }}" method="POST" class="space-y-6">
                        @csrf
                        <div>
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-widest mb-2">Issue
                                Subject</label>
                            <input type="text" name="subject" required
                                placeholder="e.g., Cannot upload images, Login issue..."
                                class="w-full bg-gray-50 border border-gray-200 rounded-lg px-4 py-3 text-sm font-medium focus:outline-none focus:border-blue-500 focus:ring-1 focus:ring-blue-500 transition-all">
                        </div>
                        <div>
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-widest mb-2">Detailed
                                Description</label>
                            <textarea name="message" required rows="6"
                                placeholder="Please describe the problem in detail, including what you were doing when it happened..."
                                class="w-full bg-gray-50 border border-gray-200 rounded-lg px-4 py-3 text-sm font-medium focus:outline-none focus:border-blue-500 focus:ring-1 focus:ring-blue-500 transition-all"></textarea>
                        </div>

                        <div class="bg-blue-50 p-4 rounded-lg flex items-start gap-3">
                            <svg class="w-5 h-5 text-blue-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <p class="text-xs text-blue-700 leading-relaxed">
                                By submitting this form, a priority ticket will be created with our IT department at
                                <strong>it@thefalconsecurity.com</strong>. You will receive a response via your dashboard
                                notifications or email.
                            </p>
                        </div>

                        <button type="submit"
                            class="w-full bg-slate-900 text-white font-bold py-4 rounded-xl shadow-lg hover:bg-black transition-all transform active:scale-[0.98] uppercase tracking-wider">
                            Submit Support Ticket
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection