@extends('layouts.employee')

@section('title', 'Security Protocols')

@section('content')
    <div class="max-w-xl mx-auto">
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden" x-data="{ 
                    password: '',
                    strength: 0,
                    evaluateStrength() {
                        let s = 0;
                        if (this.password.length >= 8) s++;
                        if (this.password.match(/[A-Z]/)) s++;
                        if (this.password.match(/[0-9]/)) s++;
                        if (this.password.match(/[^A-Za-z0-9]/)) s++;
                        this.strength = s;
                    },
                    get strengthMessage() {
                        const msgs = ['Critical Weakness', 'Low Security', 'Standard', 'High Security', 'Maximum Integrity'];
                        return msgs[this.strength];
                    },
                    get strengthColor() {
                        const colors = ['bg-red-500', 'bg-orange-500', 'bg-yellow-500', 'bg-blue-500', 'bg-green-500'];
                        return colors[this.strength];
                    }
                }">
            <div class="px-8 py-6 bg-gray-50 border-b border-gray-200 flex items-center justify-between">
                <div>
                    <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Change Password</h3>
                    <p class="text-xs text-gray-500 font-medium tracking-wide mt-1">Update Tactical Credentials</p>
                </div>
                <div
                    class="w-10 h-10 bg-white rounded-lg flex items-center justify-center shadow-sm border border-gray-200">
                    <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z">
                        </path>
                    </svg>
                </div>
            </div>

            <div class="p-8">
                <form action="{{ route('employee.settings.password') }}" method="POST" class="space-y-6">
                    @csrf
                    @method('PUT')

                    <div>
                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wide mb-2">Current
                            Password</label>
                        <input type="password" name="current_password" required
                            class="block w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wide mb-2">Set New
                            Password</label>
                        <input type="password" name="password" required x-model="password" @input="evaluateStrength()"
                            class="block w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm mb-3">

                        <!-- Strength Indicator -->
                        <div class="space-y-2">
                            <div class="flex items-center justify-between">
                                <span class="text-[10px] font-bold uppercase tracking-wider"
                                    :class="strength > 0 ? 'text-gray-600' : 'text-gray-400'">Encryption Strength</span>
                                <span class="text-[10px] font-bold uppercase tracking-wider"
                                    :class="strength > 0 ? 'text-gray-900' : 'text-gray-400'"
                                    x-text="strengthMessage">None</span>
                            </div>
                            <div class="h-1.5 w-full bg-gray-100 rounded-full overflow-hidden flex gap-1">
                                <template x-for="i in 4">
                                    <div class="h-full flex-1 transition-all duration-500 rounded-full"
                                        :class="i <= strength ? strengthColor : 'bg-transparent'"></div>
                                </template>
                            </div>
                            <p class="text-[10px] text-gray-400 font-medium tracking-tight">Minimum 8 characters, including
                                symbols and mixed case.</p>
                        </div>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wide mb-2">Confirm New
                            Password</label>
                        <input type="password" name="password_confirmation" required
                            class="block w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                    </div>

                    <div class="pt-2">
                        <button type="submit"
                            class="w-full bg-slate-900 hover:bg-black text-white font-bold py-4 rounded-xl shadow-sm active:scale-[0.98] transition-all flex items-center justify-center gap-3 uppercase tracking-widest text-xs">
                            Change Password
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                                </path>
                            </svg>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection