<!DOCTYPE html>
<html>

<head>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            color: #333;
        }

        .header {
            border-bottom: 2px solid #1e293b;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 10px;
        }

        th,
        td {
            border: 1px solid #e2e8f0;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f8fafc;
            color: #64748b;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 8px;
            letter-spacing: 0.05em;
        }

        .meta {
            margin-bottom: 5px;
            font-size: 11px;
        }

        .meta-label {
            font-weight: bold;
            color: #64748b;
        }

        .checkpoint-name {
            font-weight: bold;
            color: #1e293b;
        }

        .message-box {
            background-color: #f1f5f9;
            padding: 5px;
            border-radius: 4px;
            font-style: italic;
            color: #475569;
            margin-top: 4px;
        }

        .image-container {
            margin-top: 5px;
        }

        .image-thumbnail {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border-radius: 4px;
            margin-right: 5px;
            border: 1px solid #cbd5e1;
        }

        .footer {
            margin-top: 30px;
            font-size: 9px;
            text-align: center;
            color: #94a3b8;
        }

        .badge {
            padding: 2px 6px;
            border-radius: 9999px;
            font-size: 8px;
            font-weight: bold;
        }

        .badge-blue {
            background-color: #dbeafe;
            color: #1e40af;
        }

        .badge-emerald {
            background-color: #d1fae5;
            color: #065f46;
        }

        .badge-slate {
            background-color: #f1f5f9;
            color: #475569;
        }
    </style>
</head>

<body>
    <div class="header">
        <h2 style="margin: 0; color: #1e293b;">Checkpoint Scan History Detail</h2>
        <div style="margin-top: 10px;">
            <span class="meta"><span class="meta-label">Employee:</span> {{ $employee->first_name }}
                {{ $employee->last_name }}</span><br>
            <span class="meta"><span class="meta-label">Generated:</span> {{ now()->format('M d, Y H:i') }}</span>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th width="15%">Time / Date</th>
                <th width="20%">Job / Site</th>
                <th width="15%">Checkpoint</th>
                <th width="10%">Method</th>
                <th width="40%">Scan Protocol Data (Message/Images)</th>
            </tr>
        </thead>
        <tbody>
            @forelse($reports as $scan)
                @php
                    $opts = is_string($scan->checkpoint->extra_scan_options) ? json_decode($scan->checkpoint->extra_scan_options, true) : $scan->checkpoint->extra_scan_options;
                    $type = $opts['type'] ?? 'log_only';
                @endphp
                <tr>
                    <td>
                        <div style="font-weight: bold;">{{ $scan->scanned_at->format('H:i:s') }}</div>
                        <div style="color: #64748b; font-size: 8px;">{{ $scan->scanned_at->format('M d, Y') }}</div>
                    </td>
                    <td>
                        <div style="font-weight: bold;">{{ $scan->schedule->site->name ?? 'N/A' }}</div>
                        <div style="color: #64748b; font-size: 8px;">Duty #{{ $scan->schedule->duty_number ?? 'N/A' }}</div>
                    </td>
                    <td>
                        <span class="checkpoint-name">{{ $scan->checkpoint->name ?? 'N/A' }}</span>
                        @if($scan->tourRoute)
                            <div style="font-size: 8px; color: #94a3b8;">Route: {{ $scan->tourRoute->name }}</div>
                        @endif
                    </td>
                    <td>
                        @if($scan->is_manual)
                            <span class="badge badge-slate">MANUAL</span>
                        @else
                            <span class="badge badge-emerald">QR/NFC</span>
                        @endif
                        <div style="font-size: 8px; color: #94a3b8; margin-top: 2px;">{{ strtoupper($type) }}</div>
                    </td>
                    <td>
                        @if($type === 'message' && $scan->employee_message)
                            <div class="meta-label" style="font-size: 8px;">OBSERVATION:</div>
                            <div class="message-box">{{ $scan->employee_message }}</div>
                        @endif

                        @if($type === 'photo')
                            <div class="meta-label" style="font-size: 8px;">EVIDENCE PHOTOS:</div>
                            <div class="image-container">
                                @if($scan->evidence_image)
                                    <img src="{{ public_path('storage/' . $scan->evidence_image) }}" class="image-thumbnail">
                                @endif

                                @if($scan->additional_photos)
                                    @foreach($scan->additional_photos as $photo)
                                        <img src="{{ public_path('storage/' . $photo) }}" class="image-thumbnail">
                                    @endforeach
                                @endif

                                @if(!$scan->evidence_image && empty($scan->additional_photos))
                                    <span style="color: #94a3b8; font-style: italic;">No photos uploaded</span>
                                @endif
                            </div>
                        @endif

                        @if($type === 'log_only')
                            <span style="color: #94a3b8; font-style: italic;">Verified Log Only</span>
                        @endif
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" style="text-align: center; padding: 40px; color: #94a3b8;">
                        No scan history records found for the selected criteria.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="footer">
        &copy; {{ date('Y') }} {{ $employee->company->name ?? 'Security Portal' }}. This is an electronically generated
        operational document.
    </div>
</body>

</html>