<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Payout Report</title>
    <style>
        body {
            font-family: sans-serif;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #eee;
            padding-bottom: 15px;
        }

        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #111827;
            margin-bottom: 5px;
        }

        .meta {
            color: #6b7280;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 11px;
        }

        th {
            background: #f9fafb;
            padding: 10px;
            text-transform: uppercase;
            color: #6b7280;
            font-size: 9px;
            letter-spacing: 0.05em;
            border-bottom: 1px solid #e5e7eb;
            text-align: left;
        }

        td {
            padding: 12px 10px;
            border-bottom: 1px solid #f3f4f6;
            color: #374151;
            vertical-align: top;
        }

        .total-box {
            margin-top: 20px;
            text-align: right;
            background: #f9fafb;
            padding: 15px;
            border-radius: 6px;
        }

        .amount {
            color: #059669;
            font-weight: bold;
        }

        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            font-size: 9px;
            text-align: center;
            color: #9ca3af;
            padding: 10px;
            border-top: 1px solid #eee;
        }
    </style>
</head>

<body>
    <div class="header">
        <div class="logo">Falcon Security Services</div>
        <div class="meta">Payout Report &bull; Generated on {{ now()->format('M d, Y H:i') }}</div>
        <div class="meta">Employee: {{ $employee->full_name }} (ID: {{ $employee->employee_id ?? 'N/A' }})</div>
    </div>

    <table>
        <thead>
            <tr>
                <th width="20%">Date / Time</th>
                <th width="25%">Site / Duty #</th>
                <th width="15%">Duration</th>
                <th width="20%" style="text-align: right;">Rate</th>
                <th width="20%" style="text-align: right;">Earned</th>
            </tr>
        </thead>
        <tbody>
            @foreach($payouts as $item)
                <tr>
                    <td>
                        <strong>{{ $item->date->format('M d, Y') }}</strong><br>
                        <span style="color: #9ca3af; font-size: 9px;">
                            {{ $item->start_time }} - {{ $item->end_time }}
                        </span>
                    </td>
                    <td>
                        {{ $item->site_name }}<br>
                        <div style="margin-top: 4px;">
                            <span
                                style="background: #f3f4f6; padding: 2px 4px; border-radius: 3px; font-size: 8px; color: #6b7280; border: 1px solid #e5e7eb;">#{{ $item->duty_number }}</span>
                            <span
                                style="background: {{ $item->type === 'Guard' ? '#eff6ff' : '#f5f3ff' }}; padding: 2px 4px; border-radius: 3px; font-size: 8px; color: {{ $item->type === 'Guard' ? '#2563eb' : '#7c3aed' }}; border: 1px solid {{ $item->type === 'Guard' ? '#dbeafe' : '#ede9fe' }}; margin-left: 2px;">{{ $item->type }}</span>
                        </div>
                    </td>
                    <td>{{ number_format($item->hours, 2) }} hrs</td>
                    <td align="right">
                        ${{ number_format($item->rate, 2) }}/hr
                    </td>
                    <td align="right" class="amount">${{ number_format($item->total, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="total-box">
        <span style="font-size: 14px; font-weight: bold; color: #374151; margin-right: 15px;">Total Earnings:</span>
        <span style="font-size: 18px;" class="amount">${{ number_format($totalEarnings, 2) }}</span>
    </div>

    <div class="footer">
        FALCON SECURITY SERVICES &bull; CONFIDENTIAL FINANCIAL DOCUMENT
    </div>
</body>

</html>