<!DOCTYPE html>
<html>

<head>
    <title>Financial Briefing: Payout Report - #{{ $schedule->duty_number }}</title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            color: #1e293b;
            line-height: 1.5;
            padding: 40px;
        }

        .header {
            border-bottom: 4px solid #0f172a;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .header h1 {
            margin: 0;
            color: #0f172a;
            text-transform: uppercase;
            font-size: 24px;
        }

        .header p {
            margin: 5px 0 0;
            color: #64748b;
            font-weight: bold;
            font-size: 12px;
            text-transform: uppercase;
        }

        .section {
            margin-bottom: 30px;
        }

        .section-title {
            font-size: 14px;
            font-weight: 800;
            color: #0f172a;
            text-transform: uppercase;
            margin-bottom: 15px;
            background: #f1f5f9;
            padding: 5px 10px;
            border-radius: 4px;
        }

        .grid {
            width: 100%;
            border-collapse: collapse;
        }

        .grid td {
            padding: 12px;
            border: 1px solid #f1f5f9;
            font-size: 12px;
        }

        .label {
            font-weight: bold;
            color: #64748b;
            text-transform: uppercase;
            font-size: 10px;
            width: 35%;
        }

        .payout-total {
            background: #0f172a;
            color: white;
            padding: 20px;
            border-radius: 12px;
            margin-top: 20px;
            text-align: right;
        }

        .payout-total h2 {
            margin: 0;
            font-size: 24px;
            color: #10b981;
        }

        .footer {
            margin-top: 50px;
            border-top: 1px solid #e2e8f0;
            padding-top: 20px;
            font-size: 10px;
            color: #94a3b8;
            text-align: center;
        }

        .rule-notice {
            font-size: 9px;
            color: #64748b;
            font-style: italic;
            margin-top: 5px;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Deployment Payout Report</h1>
        <p>Deployment #{{ $schedule->duty_number }} | Site: {{ $schedule->site->name }}</p>
    </div>

    <div class="section">
        <div class="section-title">Deployment Timing Metrics</div>
        <table class="grid">
            <tr>
                <td class="label">Scheduled Start</td>
                <td>{{ $schedule->from_datetime->format('Y-m-d H:i') }}</td>
            </tr>
            <tr>
                <td class="label">Actual Check-In</td>
                <td>{{ $pivot->actual_start_at ? \Carbon\Carbon::parse($pivot->actual_start_at)->format('Y-m-d H:i') : 'N/A' }}
                </td>
            </tr>
            <tr>
                <td class="label">Scheduled End</td>
                <td>{{ $schedule->to_datetime->format('Y-m-d H:i') }}</td>
            </tr>
            <tr>
                <td class="label">Actual Extraction</td>
                <td>{{ $pivot->actual_end_at ? \Carbon\Carbon::parse($pivot->actual_end_at)->format('Y-m-d H:i') : 'N/A' }}
                </td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Billable Duration Calculation</div>
        <table class="grid">
            <tr>
                <td class="label">Payable Start Time</td>
                <td>{{ $payoutData['payout_start'] ? $payoutData['payout_start']->format('Y-m-d H:i') : 'N/A' }}
                    <div class="rule-notice">* Adjusted based on early/late check-in policy.</div>
                </td>
            </tr>
            <tr>
                <td class="label">Payable End Time</td>
                <td>{{ $payoutData['payout_end'] ? $payoutData['payout_end']->format('Y-m-d H:i') : 'N/A' }}
                    <div class="rule-notice">* Adjusted based on early extraction policy.</div>
                </td>
            </tr>
            <tr>
                <td class="label">Total Billable Hours</td>
                <td style="font-weight: bold; font-size: 14px;">{{ $payoutData['hours'] }} Hours</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Financial Compensation Summary</div>
        <table class="grid">
            <tr>
                <td class="label">Job Wage Rate (Hourly)</td>
                <td>${{ number_format($payoutData['wage_rate'], 2) }}</td>
            </tr>
            <tr>
                <td class="label">Job Gas Allowance</td>
                <td>${{ number_format($payoutData['gas_rate'], 2) }}</td>
            </tr>
            @php 
                                                                $wage_types_raw = json_decode($pivot->wage_types, true);
                if (!is_array($wage_types_raw)) {
                    $wage_types_raw = json_decode($wage_types_raw, true) ?? [];
                }
                $wage_types = array_filter(array_map(fn($v) => is_array($v) ? json_encode($v) : (string) $v, $wage_types_raw));
            @endphp
            @if(count($wage_types) > 0)
                <tr>
                    <td class="label">Allocated Wage Components</td>
                    <td>{{ implode(', ', $wage_types) }}</td>



                                                             </tr>
            @endif
        </table>

        <div class="payout-total">
            <p style="text-transform: uppercase; font-size: 10px; margin-bottom: 5px; color: #94a3b8;">Total Job Remuneration</p>
            <h2>${{ number_format($payoutData['payout'], 2) }}</h2>
        </div>
    </div>

    <div class="footer">
        Automated Financial Audit | {{ $schedule->company->name ?? config('app.name') }} Intelligence
    </div>
</body>

</html>