<!DOCTYPE html>
<html>

<head>
    <title>Comprehensive Job Log - #{{ $schedule->duty_number }}</title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            color: #1e293b;
            line-height: 1.5;
            padding: 40px;
        }

        .header {
            border-bottom: 4px solid #0f172a;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .header h1 {
            margin: 0;
            color: #0f172a;
            text-transform: uppercase;
            font-size: 24px;
        }

        .header p {
            margin: 5px 0 0;
            color: #64748b;
            font-weight: bold;
            font-size: 12px;
            text-transform: uppercase;
        }

        .section {
            margin-bottom: 30px;
        }

        .section-title {
            font-size: 14px;
            font-weight: 800;
            color: #0f172a;
            text-transform: uppercase;
            margin-bottom: 15px;
            background: #f1f5f9;
            padding: 5px 10px;
            border-radius: 4px;
        }

        .grid {
            width: 100%;
            border-collapse: collapse;
        }

        .grid td {
            padding: 10px;
            border: 1px solid #f1f5f9;
            font-size: 12px;
        }

        .label {
            font-weight: bold;
            color: #64748b;
            text-transform: uppercase;
            font-size: 10px;
            width: 30%;
        }

        .incident-card {
            margin-bottom: 15px;
            padding: 15px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
        }

        .image-strip {
            display: block;
            margin-top: 10px;
        }

        .image-item {
            display: inline-block;
            width: 150px; /* Reduced from 30% */
            margin-right: 10px;
            margin-bottom: 10px;
            vertical-align: top;
        }

        .image-item img {
            width: 100%;
            height: 150px; /* Fixed height for uniformity */
            object-fit: cover;
            border-radius: 4px;
            border: 1px solid #e2e8f0;
        }

        .footer {
            margin-top: 50px;
            border-top: 1px solid #e2e8f0;
            padding-top: 20px;
            font-size: 10px;
            color: #94a3b8;
            text-align: center;
        }
    </style>
    @php
        /**
         * Helper to handle image rendering in both PDF and Web views.
         * For PDFs, it converts images (including WebP) to base64 JPEGs
         * to ensure compatibility with DomPDF.
         */
        $renderJobImage = function ($img, $isPdf) {
            if (!$isPdf) {
                return asset('storage/' . $img);
            }

            $fullPath = public_path('storage/' . $img);
            if (!file_exists($fullPath)) {
                return '';
            }

            $extension = strtolower(pathinfo($fullPath, PATHINFO_EXTENSION));

            try {
                // DomPDF doesn't natively support WebP. Convert to JPEG if GD is available.
                if ($extension === 'webp' && function_exists('imagecreatefromwebp')) {
                    $image = @imagecreatefromwebp($fullPath);
                    if ($image) {
                        ob_start();
                        imagejpeg($image, null, 70); // Compress slightly for PDF size
                        $data = ob_get_clean();
                        imagedestroy($image);
                        return 'data:image/jpeg;base64,' . base64_encode($data);
                    }
                }

                // For other formats or fallback, use base64 encoded original
                $mime = 'image/' . ($extension === 'jpg' ? 'jpeg' : $extension);
                return 'data:' . $mime . ';base64,' . base64_encode(file_get_contents($fullPath));
            } catch (\Exception $e) {
                return '';
            }
        };
    @endphp
</head>

<body>
    <div class="header">
        <h1>Comprehensive Job Log</h1>
        <p>Deployment #{{ $schedule->duty_number }} | Site: {{ $schedule->site->name }}</p>
    </div>

    <div class="section">
        <div class="section-title">Operative Intelligence</div>
        <table class="grid">
            <tr>
                <td class="label">Operative</td>
                <td>{{ $employee->first_name }} {{ $employee->last_name }} (#{{ $employee->employee_id }})</td>
            </tr>
            <tr>
                <td class="label">Duty Status</td>
                <td>{{ strtoupper($schedule->status) }}</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Latitude and Longitude Coordinates & Timings</div>
        <table class="grid">
            <tr>
                <td class="label">Scheduled Shift</td>
                <td>{{ \Carbon\Carbon::parse($schedule->from_datetime)->format('Y-m-d H:i') }} - {{ \Carbon\Carbon::parse($schedule->to_datetime)->format('H:i') }}</td>
            </tr>
            <tr>
                <td class="label">Infiltration (Start)</td>
                <td>
                    <div><strong>Time:</strong> {{ $pivot->actual_start_at ? \Carbon\Carbon::parse($pivot->actual_start_at)->format('Y-m-d H:i') : 'N/A' }}</div>
                    <div><strong>Coords:</strong> [{{ $pivot->start_lat ?? 'N/A' }}, {{ $pivot->start_lng ?? 'N/A' }}]</div>
                </td>
            </tr>
            <tr>
                <td class="label">Extraction (End)</td>
                <td>
                    <div><strong>Time:</strong> {{ $pivot->actual_end_at ? \Carbon\Carbon::parse($pivot->actual_end_at)->format('Y-m-d H:i') : 'N/A' }}</div>
                    <div><strong>Coords:</strong> [{{ $pivot->end_lat ?? 'N/A' }}, {{ $pivot->end_lng ?? 'N/A' }}]</div>
                </td>
            </tr>
             <tr>
                <td class="label">Remarks / Comments</td>
                <td>
                    @if(!empty($schedule->remarks))
                        {{ $schedule->remarks }}
                    @else
                        <span style="color: #94a3b8; font-style: italic;">No remarks recorded.</span>
                    @endif
                </td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Field Intelligence & Report Incidents</div>
        @forelse($schedule->incidents as $incident)
            <div class="incident-card">
                <div style="font-weight: 800; color: #0f172a; margin-bottom: 5px;">{{ $incident->subject }}</div>
                <div style="font-size: 12px; color: #475569;">{{ $incident->description }}</div>

                @if(!empty($incident->images) && is_array($incident->images))
                    <div class="image-strip" style="margin-top: 10px;">
                        @foreach($incident->images as $img)
                            <div class="image-item"
                                style="display: inline-block; width: 100px; margin-right: 5px; vertical-align: top;">
                                <img src="{{ $renderJobImage($img, $isPdf) }}"
                                    style="width: 100%; border-radius: 4px; border: 1px solid #cbd5e1;">
                            </div>
                        @endforeach
                    </div>
                @endif

                <div style="font-size: 10px; color: #94a3b8; margin-top: 8px;">Filed at:
                    {{ $incident->created_at->format('Y-m-d H:i') }}</div>
            </div>
        @empty
            <p style="font-size: 12px; color: #64748b;">No tactical incidents reported during this deployment.</p>
        @endforelse
    </div>

    <div class="section">
        <div class="section-title">Consolidated Evidence Gallery</div>
        @php 
            $inImages = json_decode($pivot->checkin_images, true) ?? [];
            $outImages = json_decode($pivot->checkout_images, true) ?? [];
        @endphp

        @if(count($inImages) > 0)
            <div style="font-size: 10px; font-weight: bold; color: #64748b; margin-bottom: 5px;">CHECK-IN IMAGES</div>
            <div class="image-strip">
                @foreach($inImages as $img)
                    <div class="image-item">
                        <img src="{{ $renderJobImage($img, $isPdf) }}">
                    </div>
                @endforeach
            </div>
        @endif

        @if(count($outImages) > 0)
            <div style="font-size: 10px; font-weight: bold; color: #64748b; margin-top: 15px; margin-bottom: 5px;">CHECKOUT
                IMAGES</div>
            <div class="image-strip">
                @foreach($outImages as $img)
                    <div class="image-item">
                        <img src="{{ $renderJobImage($img, $isPdf) }}">
                    </div>
                @endforeach
            </div>
        @endif
    </div>

    <div class="footer">
        Generated by {{ $schedule->company->name ?? config('app.name') }} Intelligence System | Full Job Cycle Manifest
    </div>
</body>

</html>