<!DOCTYPE html>
<html>

<head>
    <title>Check-In Evidence Report - #{{ $schedule->duty_number }}</title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            color: #1e293b;
            line-height: 1.5;
            padding: 40px;
        }

        .header {
            border-bottom: 4px solid #0f172a;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .header h1 {
            margin: 0;
            color: #0f172a;
            text-transform: uppercase;
            font-size: 24px;
        }

        .header p {
            margin: 5px 0 0;
            color: #64748b;
            font-weight: bold;
            font-size: 12px;
            text-transform: uppercase;
        }

        .section {
            margin-bottom: 30px;
        }

        .section-title {
            font-size: 14px;
            font-weight: 800;
            color: #0f172a;
            text-transform: uppercase;
            margin-bottom: 15px;
            background: #f1f5f9;
            padding: 5px 10px;
            border-radius: 4px;
        }

        .grid {
            width: 100%;
            border-collapse: collapse;
        }

        .grid td {
            padding: 10px;
            border: 1px solid #f1f5f9;
            font-size: 12px;
        }

        .label {
            font-weight: bold;
            color: #64748b;
            text-transform: uppercase;
            font-size: 10px;
            width: 30%;
        }

        .image-grid {
            display: block;
            margin-top: 20px;
        }

        .image-container {
            display: inline-block;
            width: 48%;
            margin-bottom: 15px;
            margin-right: 2%;
        }

        .image-container img {
            width: 100%;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
        }

        .footer {
            margin-top: 50px;
            border-top: 1px solid #e2e8f0;
            padding-top: 20px;
            font-size: 10px;
            color: #94a3b8;
            text-align: center;
        }
    </style>
    @php
        /**
         * Helper to handle image rendering in PDF views.
         * Converts images (including WebP) to base64 JPEGs to ensure compatibility with DomPDF.
         */
        $renderJobImage = function ($img) {
            $fullPath = public_path('storage/' . $img);
            if (!file_exists($fullPath)) {
                return '';
            }

            $extension = strtolower(pathinfo($fullPath, PATHINFO_EXTENSION));

            try {
                if ($extension === 'webp' && function_exists('imagecreatefromwebp')) {
                    $image = @imagecreatefromwebp($fullPath);
                    if ($image) {
                        ob_start();
                        imagejpeg($image, null, 70);
                        $data = ob_get_clean();
                        imagedestroy($image);
                        return 'data:image/jpeg;base64,' . base64_encode($data);
                    }
                }
                $mime = 'image/' . ($extension === 'jpg' ? 'jpeg' : $extension);
                return 'data:' . $mime . ';base64,' . base64_encode(file_get_contents($fullPath));
            } catch (\Exception $e) {
                return '';
            }
        };
    @endphp
</head>

<body>
    <div class="header">
        <h1>Check-In Evidence Report</h1>
        <p>Deployment #{{ $schedule->duty_number }} | Site: {{ $schedule->site->name }}</p>
    </div>

    <div class="section">
        <div class="section-title">Deployment Context</div>
        <table class="grid">
            <tr>
                <td class="label">Operative</td>
                <td>{{ $employee->first_name }} {{ $employee->last_name }}</td>
            </tr>
            <tr>
                <td class="label">Actual Check-In Time</td>
                <td>{{ $pivot->actual_start_at ? \Carbon\Carbon::parse($pivot->actual_start_at)->format('Y-m-d H:i') : 'N/A' }}
                </td>
            </tr>
            <tr>
                <td class="label">Check-In Location</td>
                <td>{{ $pivot->start_lat ?? 'N/A' }}, {{ $pivot->start_lng ?? 'N/A' }}</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Visual Evidence: Infiltration</div>
        <div class="image-grid">
            @php $images = json_decode($pivot->checkin_images, true) ?? []; @endphp
            @forelse($images as $image)
                <div class="image-container">
                    <img src="{{ $renderJobImage($image) }}" alt="Check-in Photo">
                </div>
            @empty
                <p style="font-size: 12px; color: #64748b;">No check-in photographs were archived for this job.</p>
            @endforelse
        </div>
    </div>

    <div class="footer">
        Verified Alpha Intelligence Archive | Vanguard System
    </div>
</body>

</html>