@extends('layouts.employee')

@section('title', 'Financial Oversight')

@section('content')
    <div class="space-y-6">
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
            <div>
                <h2 class="text-2xl font-bold text-gray-900 tracking-tight">Financial Logistics</h2>
                <p class="text-sm text-gray-500 mt-1"> Overview of completed jobs and calculated earnings.</p>
            </div>
            <div class="bg-gray-900 text-white px-5 py-3 rounded-xl shadow-lg shadow-gray-900/10 border border-gray-800">
                <p class="text-[10px] font-bold uppercase tracking-widest text-gray-400">Total Earned (Verified)</p>
                <div class="text-2xl font-black mt-1">
                    ${{ number_format($totalEarnings, 2) }}
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Job Date
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Site / Duty #
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Duration</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-right">
                                Rate</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-right">
                                Total</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($payouts as $item)
                            <tr class="hover:bg-gray-50/80 transition-colors group">
                                <td class="px-6 py-4 align-top">
                                    <div class="text-sm font-bold text-gray-900">
                                        {{ $item['date']->format('M d, Y') }}
                                    </div>
                                    <div class="text-[10px] text-gray-400 font-bold mt-0.5 uppercase tracking-wide">
                                        {{ $item['start_time'] }} - {{ $item['end_time'] }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 align-top">
                                    <div class="text-sm font-bold text-gray-900">{{ $item['site_name'] }}
                                    </div>
                                    <div class="flex items-center gap-1 mt-1">
                                        <span
                                            class="px-2 py-0.5 bg-gray-100 text-gray-500 rounded text-[10px] font-bold border border-gray-200">
                                            #{{ $item['duty_number'] }}
                                        </span>
                                        <span
                                            class="px-2 py-0.5 {{ $item['type'] === 'Guard' ? 'bg-blue-50 text-blue-600 border-blue-100' : 'bg-purple-50 text-purple-600 border-purple-100' }} rounded text-[10px] font-bold border">
                                            {{ $item['type'] }}
                                        </span>
                                    </div>
                                </td>
                                <td class="px-6 py-4 align-top">
                                    <span class="text-sm font-bold text-gray-700">
                                        {{ number_format($item['hours'], 2) }} hrs
                                    </span>
                                </td>
                                <td class="px-6 py-4 align-top text-right">
                                    <span class="text-sm font-medium text-gray-500">
                                        ${{ number_format($item['rate'], 2) }}/hr <br>
                                        <span class="text-[9px] uppercase tracking-widest text-gray-400">(Avg)</span>
                                    </span>
                                </td>
                                <td class="px-6 py-4 align-top text-right">
                                    <span
                                        class="text-sm font-black text-emerald-600 bg-emerald-50 px-2 py-1 rounded border border-emerald-100">
                                        ${{ number_format($item['total'], 2) }}
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-12 text-center text-gray-400">
                                    <div
                                        class="w-16 h-16 bg-gray-50 rounded-2xl flex items-center justify-center mx-auto mb-4 border border-gray-200">
                                        <svg class="w-8 h-8 text-gray-300" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                                            </path>
                                        </svg>
                                    </div>
                                    <p class="text-xs font-bold uppercase tracking-wider">No finalized payouts recorded</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($payouts->hasPages())
                <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
                    {{ $payouts->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection