@extends('layouts.employee')

@section('title', 'Patrol Report - ' . $schedule->duty_number)

@section('content')
    <div class="p-6">
        {{-- Header --}}
        <div class="mb-6 flex flex-col md:flex-row md:items-center justify-between gap-4">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Patrol Report</h1>
                <p class="text-gray-600">{{ $schedule->route->name }} (Duty #{{ $schedule->duty_number }})</p>
            </div>
            <div class="flex gap-2">
                <a href="{{ route('employee.patroller-jobs.export-pdf', $schedule->id) }}"
                    class="bg-white border border-gray-300 text-gray-700 px-4 py-2 rounded-lg font-bold text-sm hover:bg-gray-50 flex items-center gap-2 transition-colors">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 011.414.586l4 4a1 1 0 01.586 1.414V19a2 2 0 01-2 2z">
                        </path>
                    </svg>
                    Download PDF
                </a>
                <a href="{{ route('employee.patroller-jobs.show', $schedule->id) }}"
                    class="bg-purple-100 text-purple-700 px-4 py-2 rounded-lg font-bold text-sm hover:bg-purple-200 flex items-center gap-2 transition-colors">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Back to Job
                </a>
            </div>
        </div>

        {{-- Stats Cards --}}
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-8">
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <p class="text-xs text-gray-500 uppercase font-bold tracking-wider mb-1">Total Tickets</p>
                <p class="text-3xl font-black text-gray-900">{{ $totalTickets }}</p>
            </div>
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm border-l-4 border-l-emerald-500">
                <p class="text-xs text-gray-500 uppercase font-bold tracking-wider mb-1 text-emerald-600">Good Status</p>
                <p class="text-3xl font-black text-emerald-600">{{ $goodTickets }}</p>
            </div>
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm border-l-4 border-l-red-500">
                <p class="text-xs text-gray-500 uppercase font-bold tracking-wider mb-1 text-red-600">Bad Status</p>
                <p class="text-3xl font-black text-red-600">{{ $badTickets }}</p>
            </div>
        </div>

        {{-- Deployment Info --}}
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden mb-8">
            <div class="px-6 py-4 bg-gray-50 border-bottom border-gray-200">
                <h2 class="font-bold text-gray-800">Deployment Details</h2>
            </div>
            <div class="p-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <div>
                    <p class="text-xs text-gray-500 uppercase font-bold mb-1">Scheduled Date</p>
                    <p class="font-bold">{{ $schedule->scheduled_date->format('M d, Y') }}</p>
                </div>
                <div>
                    <p class="text-xs text-gray-500 uppercase font-bold mb-1">Scheduled Window</p>
                    <p class="font-bold">{{ $schedule->from_time->format('H:i') }} - {{ $schedule->to_time->format('H:i') }}
                    </p>
                </div>
                <div>
                    <p class="text-xs text-gray-500 uppercase font-bold mb-1">Actual Start/End</p>
                    <p class="font-bold">
                        {{ $schedule->job_started_at ? $schedule->job_started_at->format('H:i') : '-' }} /
                        {{ $schedule->job_ended_at ? $schedule->job_ended_at->format('H:i') : '-' }}
                    </p>
                </div>
                <div>
                    <p class="text-xs text-gray-500 uppercase font-bold mb-1">Total Duration</p>
                    <p class="font-bold">
                        @if($schedule->job_started_at && $schedule->job_ended_at)
                            {{ number_format($schedule->job_started_at->diffInSeconds($schedule->job_ended_at) / 3600, 2) }}
                            hours
                        @else
                            -
                        @endif
                    </p>
                </div>
                <div class="lg:col-span-2">
                    <p class="text-xs text-gray-500 uppercase font-bold mb-1">Assigned Support</p>
                    <div class="flex -space-x-2 overflow-hidden mt-1">
                        @foreach($schedule->employees as $emp)
                            <div class="inline-block h-8 w-8 rounded-full ring-2 ring-white bg-slate-200 flex items-center justify-center text-[10px] font-bold text-gray-600"
                                title="{{ $emp->first_name }}">
                                {{ substr($emp->first_name, 0, 1) }}
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        {{-- Visit Timeline --}}
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden mb-8">
            <div class="px-6 py-4 bg-gray-50 border-bottom border-gray-200 flex justify-between items-center">
                <h2 class="font-bold text-gray-800">Visit Timeline</h2>
                <span class="text-xs text-gray-500">{{ $schedule->jobSites->where('status', '!=', 'pending')->count() }}
                    Successful Visits</span>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left">
                    <thead class="bg-gray-50 border-y border-gray-200">
                        <tr>
                            <th class="px-6 py-3 text-xs font-bold text-gray-500 uppercase">Site Name</th>
                            <th class="px-6 py-3 text-xs font-bold text-gray-500 uppercase">Check In</th>
                            <th class="px-6 py-3 text-xs font-bold text-gray-500 uppercase">Check Out</th>
                            <th class="px-6 py-3 text-xs font-bold text-gray-500 uppercase">Duration</th>
                            <th class="px-6 py-3 text-xs font-bold text-gray-500 uppercase">Tickets</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($schedule->jobSites->where('status', '!=', 'pending')->sortBy('checked_in_at') as $visit)
                            <tr>
                                <td class="px-6 py-4 font-bold text-gray-900">{{ $visit->site->name }}</td>
                                <td class="px-6 py-4 text-sm text-gray-600">
                                    {{ $visit->checked_in_at ? $visit->checked_in_at->format('H:i') : '-' }}</td>
                                <td class="px-6 py-4 text-sm text-gray-600">
                                    {{ $visit->checked_out_at ? $visit->checked_out_at->format('H:i') : '-' }}</td>
                                <td class="px-6 py-4 text-sm text-gray-600">
                                    @if($visit->checked_in_at && $visit->checked_out_at)
                                        {{ $visit->checked_in_at->diffInMinutes($visit->checked_out_at) }}m
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="px-6 py-4">
                                    @if($visit->issueTickets->count() > 0)
                                        <span
                                            class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-bold bg-red-100 text-red-800">
                                            {{ $visit->issueTickets->count() }} Issues
                                        </span>
                                    @else
                                        <span class="text-emerald-500">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M5 13l4 4L19 7"></path>
                                            </svg>
                                        </span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-12 text-center text-gray-500">No visits recorded yet for this
                                    patrol job.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        {{-- Detailed Tickets --}}
        @if($ticketsBySite->isNotEmpty())
            <h2 class="text-xl font-black text-gray-900 mb-4 px-2 tracking-tight">Detailed Issue Tickets</h2>
            <div class="space-y-6">
                @foreach($ticketsBySite as $siteId => $tickets)
                    @php $site = $tickets->first()->site; @endphp
                    <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                        <div class="px-6 py-3 bg-slate-900 text-white flex justify-between items-center">
                            <h3 class="font-bold">{{ $site->name }}</h3>
                            <span class="text-xs font-bold opacity-75 uppercase tracking-widest">{{ $tickets->count() }}
                                Tickets</span>
                        </div>
                        <div class="divide-y divide-gray-100">
                            @foreach($tickets as $ticket)
                                <div class="p-6">
                                    <div class="flex justify-between items-start mb-3">
                                        <div>
                                            <span
                                                class="text-[10px] font-black text-gray-400 uppercase tracking-widest mb-1 block">Ticket
                                                #{{ $ticket->ticket_number }}</span>
                                            <p class="text-gray-900 font-medium">{{ $ticket->description }}</p>
                                        </div>
                                        <span
                                            class="px-3 py-1 rounded-lg text-xs font-black uppercase tracking-wider {{ $ticket->status == 'good' ? 'bg-emerald-100 text-emerald-700' : 'bg-red-100 text-red-700' }}">
                                            {{ $ticket->status }}
                                        </span>
                                    </div>
                                    <div class="flex items-center gap-4 text-xs text-gray-500 mb-4">
                                        <span class="flex items-center gap-1">
                                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                            </svg>
                                            {{ $ticket->created_at->format('M d, Y H:i') }}
                                        </span>
                                        <span class="flex items-center gap-1">
                                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                                </path>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            </svg>
                                            {{ $ticket->latitude }}, {{ $ticket->longitude }}
                                        </span>
                                    </div>
                                    @if($ticket->images && count($ticket->images) > 0)
                                        <div class="flex flex-wrap gap-2">
                                            @foreach($ticket->images as $image)
                                                <a href="{{ asset('storage/' . $image) }}" target="_blank" class="block">
                                                    <img src="{{ asset('storage/' . $image) }}"
                                                        class="w-24 h-24 object-cover rounded-lg border border-gray-200 hover:opacity-75 transition-opacity">
                                                </a>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        @endif

        <div class="mt-12 text-center text-gray-400 text-xs py-12 border-t border-gray-100 italic">
            This report was automatically generated on {{ now()->format('Y-m-d H:i') }} by the Crimson Vanguard Intelligence
            System.
        </div>
    </div>
@endsection