@extends('layouts.employee')

@section('title', 'Patrol History')

@section('content')
    <div class="bg-white rounded-2xl border border-gray-200 shadow-sm overflow-hidden">
        <div class="px-8 py-6 border-b border-gray-100 bg-gray-50/50 flex justify-between items-center">
            <div>
                <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Completed Patrols</h3>
                <p class="text-[10px] text-gray-500 font-semibold tracking-wider uppercase mt-1">Archive of all patrol
                    activities</p>
            </div>
            <div class="text-right">
                <span class="text-xs font-bold text-gray-500">Total: {{ $completedJobs->total() }}</span>
            </div>
        </div>

        @if($completedJobs->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-left">
                    <thead class="text-xs text-gray-500 uppercase bg-gray-50 border-b border-gray-100 font-bold tracking-wider">
                        <tr>
                            <th class="px-8 py-4">Patrol Route</th>
                            <th class="px-8 py-4">Date & Time</th>
                            <th class="px-8 py-4 text-center">Duty #</th>
                            <th class="px-8 py-4 text-center">Status</th>
                            <th class="px-8 py-4 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @foreach($completedJobs as $job)
                            <tr class="group hover:bg-gray-50/50 transition-colors">
                                <td class="px-8 py-5">
                                    <div class="flex flex-col gap-1">
                                        <span class="text-sm font-bold text-gray-900">{{ $job->route->name }}</span>
                                        <span
                                            class="text-[10px] text-gray-400 uppercase font-semibold">{{ $job->route->sites->count() }}
                                            Sites</span>
                                    </div>
                                </td>
                                <td class="px-8 py-5">
                                    <div class="flex flex-col gap-1">
                                        <span class="text-xs font-bold text-gray-700">{{ $job->from_time->format('M d, Y') }}</span>
                                        <span class="text-[10px] text-gray-500">{{ $job->from_time->format('h:i A') }} -
                                            {{ $job->to_time->format('h:i A') }}</span>
                                    </div>
                                </td>
                                <td class="px-8 py-5 text-center">
                                    <span
                                        class="font-mono font-bold text-gray-600 bg-gray-100 px-2 py-1 rounded text-xs">{{ $job->duty_number }}</span>
                                </td>
                                <td class="px-8 py-5 text-center">
                                    <span
                                        class="px-2 py-1 rounded-full text-[10px] font-bold uppercase
                                        {{ $job->job_status === 'completed' ? 'bg-green-100 text-green-700' : 'bg-yellow-100 text-yellow-700' }}">
                                        {{ str_replace('_', ' ', $job->job_status) }}
                                    </span>
                                </td>
                                <td class="px-8 py-5 text-right">
                                    <a href="{{ route('employee.patroller-jobs.report', $job->id) }}"
                                        class="inline-flex items-center gap-2 px-4 py-2 bg-purple-50 text-purple-700 text-xs font-bold rounded-lg hover:bg-purple-100 transition-colors border border-purple-200">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 011.414.586l4 4a1 1 0 01.586 1.414V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                        View Report
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="px-8 py-6 border-t border-gray-100">
                {{ $completedJobs->links() }}
            </div>

        @else
            <div class="p-12 text-center">
                <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01">
                    </path>
                </svg>
                <p class="text-gray-400 text-xs uppercase tracking-wider font-medium">No completed patrol history found</p>
            </div>
        @endif
    </div>
@endsection