@extends('layouts.employee')

@section('title', 'Notifications')

@section('content')
    <div class="space-y-4">
        <div class="bg-white rounded-xl border border-gray-100 shadow-sm p-6 text-center">
            @if($notifications->isEmpty())
                <div class="text-gray-400 py-8">
                    <svg class="w-16 h-16 mx-auto mb-4 text-gray-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9">
                        </path>
                    </svg>
                    <p class="text-lg font-medium text-gray-500">No notifications yet</p>
                </div>
            @else
                <div class="space-y-3" x-data="notificationsList()">
                    @foreach($notifications as $notification)
                        <div id="notification_{{ $notification->id }}" class="bg-white border rounded-xl p-4 text-left transition-all hover:shadow-md cursor-pointer relative overflow-hidden group 
                                                {{ $notification->read_at ? 'border-gray-200' : 'border-blue-200 bg-blue-50' }}"
                            :class="window.location.hash === '#notification_{{ $notification->id }}' ? 'ring-2 ring-yellow-400 ring-offset-2' : ''"
                            @click="markRead({{ $notification->id }}, '{{ $notification->url }}')"
                            x-show="!deleted.includes({{ $notification->id }})">
                            <div class="flex justify-between items-start gap-4">
                                <div class="flex-1">
                                    <h3 class="font-bold text-gray-900 {{ !$notification->read_at ? 'text-blue-700' : '' }}">
                                        {{ $notification->title }}
                                    </h3>
                                    <p class="text-sm text-gray-600 mt-1 whitespace-pre-wrap">{{ $notification->message }}</p>
                                    <p class="text-xs text-gray-400 mt-3">{{ $notification->created_at->diffForHumans() }}</p>
                                </div>
                                @if(!$notification->read_at)
                                    <div class="w-3 h-3 bg-blue-500 rounded-full flex-shrink-0 mt-1.5"
                                        x-ref="dot_{{ $notification->id }}"></div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>

                <div class="mt-6">
                    {{ $notifications->links() }}
                </div>
            @endif
        </div>
    </div>

    <script>
        function notificationsList() {
            return {
                deleted: [],
                async markRead(id, url) {
                    // Update UI: Remove dot, change bg immediately for better UX
                    const dot = this.$refs['dot_' + id];
                    const card = document.getElementById('notification_' + id);

                    if (dot) dot.remove();
                    if (card) {
                        card.classList.remove('bg-blue-50', 'border-blue-200');
                        card.classList.add('bg-white', 'border-gray-200');
                        const h3 = card.querySelector('h3');
                        if (h3) h3.classList.remove('text-blue-700');
                    }

                    try {
                        // Background call to mark as read
                        fetch('{{ route('employee.notifications.markAsRead', ':id') }}'.replace(':id', id), {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            }
                        });
                    } catch (e) {
                        console.error('Failed to mark as read', e);
                    }

                    // Redirect if URL exists
                    if (url) {
                        window.location.href = url;
                    }
                }
            }
        }
    </script>
@endsection