<!DOCTYPE html>
<html>

<head>
    <title>Job After-Action Report - #{{ $schedule->duty_number }}</title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            color: #1e293b;
            line-height: 1.5;
            padding: 40px;
        }

        .header {
            border-bottom: 4px solid #dc2626;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .header h1 {
            margin: 0;
            color: #0f172a;
            text-transform: uppercase;
            font-size: 24px;
            letter-spacing: -1px;
        }

        .header p {
            margin: 5px 0 0;
            color: #64748b;
            font-weight: bold;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 2px;
        }

        .section {
            margin-bottom: 30px;
        }

        .section-title {
            font-size: 14px;
            font-weight: 800;
            color: #dc2626;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 15px;
            background: #fee2e2;
            padding: 5px 10px;
            border-radius: 4px;
        }

        .grid {
            width: 100%;
            border-collapse: collapse;
        }

        .grid td {
            padding: 10px;
            border: 1px solid #f1f5f9;
            font-size: 12px;
        }

        .label {
            font-weight: bold;
            color: #64748b;
            text-transform: uppercase;
            font-size: 10px;
            width: 30%;
        }

        .timestamp-box {
            background: #f8fafc;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
        }

        .incident-card {
            margin-bottom: 20px;
            padding: 15px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
        }

        .incident-card h4 {
            margin: 0 0 10px;
            color: #0f172a;
            font-size: 14px;
        }

        .incident-card p {
            margin: 0;
            font-size: 12px;
            color: #475569;
        }

        .footer {
            margin-top: 50px;
            border-top: 1px solid #e2e8f0;
            padding-top: 20px;
            font-size: 10px;
            color: #94a3b8;
            text-align: center;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Job After-Action Report</h1>
        <p>Deployment ID: #{{ $schedule->duty_number }} | Site: {{ $schedule->site->name }}</p>
    </div>

    <div class="section">
        <div class="section-title">Operative Profile</div>
        <table class="grid">
            <tr>
                <td class="label">Operative Name</td>
                <td>{{ $employee->first_name }} {{ $employee->last_name }}</td>
            </tr>
            <tr>
                <td class="label">Employee ID</td>
                <td>{{ $employee->employee_id }}</td>
            </tr>
            <tr>
                <td class="label">Organization</td>
                <td>{{ $schedule->company->name }}</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Tactical Timeline</div>
        <table class="grid">
            <tr>
                <td class="label">Scheduled Start</td>
                <td>{{ $schedule->from_datetime->format('Y-m-d H:i') }}</td>
                <td class="label">Actual Start</td>
                <td>{{ $pivot->actual_start_at ? \Carbon\Carbon::parse($pivot->actual_start_at)->format('Y-m-d H:i') : 'N/A' }}
                </td>
            </tr>
            <tr>
                <td class="label">Scheduled End</td>
                <td>{{ $schedule->to_datetime->format('Y-m-d H:i') }}</td>
                <td class="label">Actual End</td>
                <td>{{ $pivot->actual_end_at ? \Carbon\Carbon::parse($pivot->actual_end_at)->format('Y-m-d H:i') : 'N/A' }}
                </td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Geospatial Intelligence</div>
        <table class="grid">
            <tr>
                <td class="label">Infiltration Coordinates (Start)</td>
                <td>{{ $pivot->start_lat ?? 'N/A' }}, {{ $pivot->start_lng ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td class="label">Extraction Coordinates (End)</td>
                <td>{{ $pivot->end_lat ?? 'N/A' }}, {{ $pivot->end_lng ?? 'N/A' }}</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Tactical Incident Logs ({{ $schedule->incidents->count() }})</div>
        @forelse($schedule->incidents as $incident)
            <div class="incident-card">
                <h4>{{ $incident->subject }}</h4>
                <p>{{ $incident->description }}</p>
                <div style="font-size: 10px; color: #94a3b8; margin-top: 10px;">Filed at:
                    {{ $incident->created_at->format('Y-m-d H:i') }}
                </div>
            </div>
        @empty
            <p style="font-size: 12px; color: #64748b;">No tactical incidents reported during this deployment.</p>
        @endforelse
    </div>

    <div class="footer">
        Generated by {{ $schedule->company->name ?? config('app.name') }} Intelligence System | Confidence Grade:
        Alpha-Zero
    </div>
</body>

</html>