@extends('layouts.employee')

@section('title', 'Duty Schedule')

@section('content')
    <div class="space-y-6">
        <!-- Header & Stats -->
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
            <div>
                <h2 class="text-2xl font-bold text-gray-900 tracking-tight">Assignment Roster</h2>
                <p class="text-sm text-gray-500 mt-1">Manage your deployment schedule and operational status.</p>
            </div>
        </div>

        <!-- Filters/Tabs -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200">
            <div class="flex flex-wrap border-b border-gray-100">
                @php
                    $tabs = [
                        'all' => 'All Operations',
                        'active' => 'Active',
                        'today' => 'Today',
                        'upcoming' => 'Upcoming',
                        'completed' => 'Completed',
                        'missed' => 'Missed',
                        'cancelled' => 'Cancelled',
                        'pending' => 'Pending'
                    ];
                @endphp
                @foreach($tabs as $key => $label)
                    <a href="{{ route('employee.jobs.index', ['type' => $key]) }}"
                        class="flex-1 text-center px-1 py-3 text-[10px] font-bold uppercase tracking-tight transition-all border-b-2 whitespace-nowrap {{ $type === $key ? 'border-slate-900 text-slate-900 bg-gray-50' : 'border-transparent text-gray-400 hover:text-gray-600 hover:bg-gray-50' }}">
                        {{ $label }}
                        <span
                            class="ml-2 px-2 py-0.5 rounded-full text-[10px] {{ $type === $key ? 'bg-slate-200 text-slate-800' : 'bg-gray-100 text-gray-500' }}">
                            {{ $counts[$key] ?? 0 }}
                        </span>
                    </a>
                @endforeach
            </div>
        </div>

        <!-- Schedule List Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Duty #</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Site</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Schedule</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-left">
                                Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($jobs as $job)
                                        @php
                                            $pivot = $job->pivot;
                                            $hasStarted = !empty($pivot->actual_start_at);
                                            $hasCheckedIn = !empty($pivot->checkin_images);
                                            $hasCheckedOut = !empty($pivot->actual_end_at);

                                            $statusClasses = [
                                                'upcoming' => 'bg-blue-50 text-blue-700 border border-blue-100',
                                                'today' => 'bg-amber-50 text-amber-700 border border-amber-100',
                                                'completed' => 'bg-emerald-50 text-emerald-700 border border-emerald-100',
                                                'missed' => 'bg-red-50 text-red-700 border border-red-100',
                                                'cancelled' => 'bg-gray-100 text-gray-400 border border-gray-200 line-through',
                                                'active' => 'bg-emerald-50 text-emerald-700 border border-emerald-100 animate-pulse',
                                                'default' => 'bg-gray-100 text-gray-600 border border-gray-200'
                                            ];

                                            $displayStatus = $job->status;
                                            if ($job->active && !in_array($job->status, ['completed', 'active', 'missed', 'cancelled'])) {
                                                if ($job->to_datetime->isPast()) {
                                                    $displayStatus = 'missed';
                                                } elseif ($job->from_datetime->isToday()) {
                                                    $displayStatus = 'today';
                                                } else {
                                                    $displayStatus = 'upcoming';
                                                }
                                            }

                                            $statusClass = $job->active ? ($statusClasses[$displayStatus] ?? $statusClasses['default']) : $statusClasses['default'];

                                            $checkinImages = !empty($pivot->checkin_images) ? json_decode($pivot->checkin_images, true) : [];
                                            $checkoutImages = !empty($pivot->checkout_images) ? json_decode($pivot->checkout_images, true) : [];
                                        @endphp
                                        <tr class="hover:bg-gray-50/80 transition-colors group" x-data='{ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    checkin: false, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    checkout: false, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    reportIncident: false, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    requestCancellation: false, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    jobLog: false, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    tourProgress: {{ session('open_tour_modal') == $job->id ? "true" : "false" }}, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    scanning: false, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    scanCode: "",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    jobCheckpoints: {!! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    $job->tourRoutes->flatMap->checkpoints->map(fn($c) => [
                                "code" => $c->checkpoint_id_code,
                                "options" => is_string($c->extra_scan_options) ? json_decode($c->extra_scan_options, true) : $c->extra_scan_options
                            ])->toJson() 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !!},
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    get activeCheckpoint() {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return this.jobCheckpoints.find(cp => cp.code === this.scanCode);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    },
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    fileCount: 0, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    uploading: false, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    progress: 0, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    selectedParent: "", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    selectedChild: "", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    startUpload() { this.uploading = true; let interval = setInterval(() => { this.progress += 5; if(this.progress >= 90) clearInterval(interval); }, 100); },
                                                                                                                                relieverModal: false,
                                                                                                                                reliever: null,
                                                                                                                                loadingReliever: false,
                                                                                                                                fetchReliever(scheduleId) {
                                                                                                                                    this.loadingReliever = true;
                                                                                                                                    this.relieverModal = true;
                                                                                                                                    fetch(`/employee/jobs/${scheduleId}/reliever`)
                                                                                                                                        .then(res => res.json())
                                                                                                                                        .then(data => {
                                                                                                                                            this.reliever = data;
                                                                                                                                            this.loadingReliever = false;
                                                                                                                                        })
                                                                                                                                        .catch(err => {
                                                                                                                                            console.error(err);
                                                                                                                                            this.loadingReliever = false;
                                                                                                                                        });
                                                                                                                                }
                                                                                                                                }'>
                                            <td class="px-6 py-4 align-top">
                                                <span
                                                    class="text-xs font-bold text-gray-900 bg-gray-100 px-2 py-1 rounded">#{{ $job->duty_number }}</span>
                                            </td>
                                            <td class="px-6 py-4 align-top">
                                                <div class="flex items-start gap-3">
                                                    <div
                                                        class="w-8 h-8 rounded-lg bg-white border border-gray-200 text-gray-500 flex items-center justify-center font-bold text-xs shadow-sm">
                                                        {{ substr($job->site->name, 0, 1) }}
                                                    </div>
                                                    <div>
                                                        <div class="text-sm font-bold text-gray-900">{{ $job->site->name }}</div>
                                                        <div class="text-[10px] text-gray-500 font-medium mt-0.5">{{ $job->site->city }}
                                                        </div>
                                                        @php
                                                            $currentEmployeeId = auth()->guard('employee')->id();
                                                            $companions = $job->employees->where('id', '!=', $currentEmployeeId);
                                                        @endphp
                                                        @if($companions->count() > 0)
                                                            <div class="mt-2 flex items-center gap-1.5 flex-wrap">
                                                                @foreach($companions as $comp)
                                                                    <span
                                                                        class="text-[9px] bg-slate-50 text-slate-600 px-1.5 py-0.5 rounded border border-slate-100 font-medium">
                                                                        {{ $comp->first_name }}
                                                                    </span>
                                                                @endforeach
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 align-top">
                                                <div class="flex flex-col">
                                                    <span
                                                        class="text-sm font-bold text-gray-900">{{ $job->from_datetime->format('M d, Y') }}</span>
                                                    <span
                                                        class="text-[10px] font-bold text-gray-400 mt-0.5">{{ $job->from_datetime->format('H:i') }}
                                                        - {{ $job->to_datetime->format('H:i') }}</span>
                                                    <span
                                                        class="text-[9px] text-gray-400 font-medium">{{ number_format($job->from_datetime->diffInMinutes($job->to_datetime) / 60, 2) }}h
                                                        Duration</span>
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 align-top">
                                                <span
                                                    class="inline-flex items-center px-2.5 py-0.5 rounded-full text-[10px] font-bold uppercase tracking-wide {{ $statusClass }}">
                                                    {{ !$job->active ? 'Inactive' : $displayStatus }}
                                                </span>
                                                @if($pivot->cancellation_requested_at)
                                                    <div
                                                        class="mt-2 inline-block px-2 py-0.5 bg-amber-50 text-amber-600 text-[9px] font-bold uppercase tracking-wider border border-amber-100 rounded">
                                                        Cancellation Pending</div>
                                                @endif
                                            </td>
                                            <td class="px-6 py-4 align-top text-left">
                                                <div class="flex justify-start gap-2">
                                                    @if(in_array($displayStatus, ['upcoming', 'today']) && !$pivot->cancellation_requested_at)
                                                        <button type="button" @click="requestCancellation = true"
                                                            class="px-3 py-1.5 border border-red-200 text-red-600 hover:bg-red-50 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all">
                                                            Cancel
                                                        </button>
                                                    @endif

                                                    @if(in_array($displayStatus, ['upcoming', 'missed', 'cancelled']))
                                                        <a href="{{ route('employee.jobs.report.view', $job->id) }}"
                                                            class="px-3 py-1.5 border border-slate-200 text-slate-600 hover:bg-slate-50 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all">
                                                            View
                                                        </a>
                                                    @endif

                                                    @if(!$hasStarted)
                                                        @if($displayStatus !== 'completed' && $displayStatus !== 'missed' && $displayStatus !== 'cancelled' && $displayStatus !== 'pending' && $job->active && $job->schedule_date->isToday())
                                                            <form action="{{ route('employee.jobs.start', $job->id) }}" method="POST"
                                                                class="location-required inline-block">
                                                                @csrf
                                                                <button type="submit"
                                                                    class="px-4 py-2 bg-slate-900 text-white hover:bg-black rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all shadow-sm">
                                                                    Initiate
                                                                </button>
                                                            </form>
                                                        @endif
                                                    @elseif(!$hasCheckedOut && $job->status !== 'completed')
                                                        <div class="flex flex-wrap justify-start gap-2">
                                                            @if(!$hasCheckedIn)
                                                                <button type="button" @click="checkin = true"
                                                                    class="px-4 py-2 bg-amber-600 text-white hover:bg-amber-700 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all shadow-sm">
                                                                    Check-In
                                                                </button>
                                                            @endif

                                                            <button type="button" @click="tourProgress = true"
                                                                class="px-3 py-2 bg-blue-600 text-white hover:bg-blue-700 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all shadow-sm flex items-center gap-1.5">
                                                                <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                        d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01" />
                                                                </svg>
                                                                Tour Progress
                                                            </button>

                                                            <button type="button" @click="reportIncident = true"
                                                                class="px-3 py-2 border border-blue-200 text-blue-600 hover:bg-blue-50 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all">
                                                                Report
                                                            </button>

                                                            <button type="button" @click="jobLog = true"
                                                                class="px-3 py-2 bg-slate-100 text-slate-700 hover:bg-slate-200 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all shadow-sm">
                                                                Gallery
                                                            </button>

                                                            <button type="button" @click="checkout = true"
                                                                class="px-3 py-2 bg-slate-800 text-white hover:bg-slate-900 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all shadow-sm">
                                                                Add Evidence
                                                            </button>

                                                            <form action="{{ route('employee.jobs.end', $job->id) }}" method="POST"
                                                                class="location-required inline-block">
                                                                @csrf
                                                                <button type="submit"
                                                                    class="px-4 py-2 bg-slate-900 text-white hover:bg-black rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all shadow-sm">
                                                                    End Shift
                                                                </button>
                                                            </form>
                                                            <button type="button" @click="$dispatch('open-job-notes')"
                                                                class="px-3 py-2 bg-emerald-600 text-white hover:bg-emerald-700 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all shadow-sm flex items-center gap-1.5">
                                                                <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                        d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                                                    </path>
                                                                </svg>
                                                                Notes
                                                            </button>
                                                            <button type="button" @click="fetchReliever({{ $job->id }})"
                                                                class="px-3 py-2 bg-indigo-600 text-white hover:bg-indigo-700 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all shadow-sm">
                                                                Reliever Info
                                                            </button>

                                                            <!-- Reliever Info Modal -->
                                                            <div x-show="relieverModal" class="fixed inset-0 z-50 overflow-y-auto"
                                                                style="display: none;" x-cloak>
                                                                <div class="flex items-center justify-center min-h-screen px-4">
                                                                    <div class="fixed inset-0 bg-slate-900/40 backdrop-blur-sm transition-opacity"
                                                                        @click="relieverModal = false"></div>
                                                                    <div
                                                                        class="relative bg-white rounded-2xl max-w-sm w-full p-6 shadow-xl overflow-hidden">
                                                                        <div class="flex justify-between items-center mb-4">
                                                                            <h3 class="text-lg font-bold text-gray-900">Next Scheduled
                                                                                Guard</h3>
                                                                            <button @click="relieverModal = false"
                                                                                class="text-gray-400 hover:text-gray-600 bg-gray-50 p-2 rounded-xl transition-colors">
                                                                                <svg class="w-5 h-5" fill="none" stroke="currentColor"
                                                                                    viewBox="0 0 24 24">
                                                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                                                        stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                                                                </svg>
                                                                            </button>
                                                                        </div>

                                                                        <div x-show="loadingReliever" class="flex justify-center py-8">
                                                                            <svg class="animate-spin h-8 w-8 text-blue-600"
                                                                                xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                                viewBox="0 0 24 24">
                                                                                <circle class="opacity-25" cx="12" cy="12" r="10"
                                                                                    stroke="currentColor" stroke-width="4"></circle>
                                                                                <path class="opacity-75" fill="currentColor"
                                                                                    d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z">
                                                                                </path>
                                                                            </svg>
                                                                        </div>

                                                                        <div x-show="!loadingReliever && reliever">
                                                                            <div class="text-center">
                                                                                <template x-if="reliever && reliever.employee">
                                                                                    <div>
                                                                                        <img :src="reliever.employee.photo"
                                                                                            class="w-24 h-24 rounded-full mx-auto object-cover border-4 border-slate-100 mb-4">
                                                                                        <h4 class="text-xl font-bold text-gray-900"
                                                                                            x-text="reliever.employee.name"></h4>
                                                                                        <p class="text-sm text-gray-500 font-medium mb-1">
                                                                                            Starts at <span x-text="reliever.start_time"
                                                                                                class="text-gray-900 font-bold"></span>
                                                                                        </p>
                                                                                        <p class="text-xs text-slate-400 mb-6"
                                                                                            x-text="reliever.site_name"></p>

                                                                                        <a :href="'tel:' + reliever.employee.phone"
                                                                                            class="block w-full py-3 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all text-center uppercase tracking-widest shadow-lg shadow-blue-500/30 flex items-center justify-center gap-2">
                                                                                            <svg class="w-5 h-5" fill="none"
                                                                                                stroke="currentColor" viewBox="0 0 24 24">
                                                                                                <path stroke-linecap="round"
                                                                                                    stroke-linejoin="round" stroke-width="2"
                                                                                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                                                                                </path>
                                                                                            </svg>
                                                                                            Call Reliever
                                                                                        </a>
                                                                                    </div>
                                                                                </template>
                                                                                <template
                                                                                    x-if="reliever && !reliever.employee && !reliever.self_relief">
                                                                                    <div class="py-4">
                                                                                        <div
                                                                                            class="bg-amber-50 rounded-xl p-4 border border-amber-100 mb-4">
                                                                                            <p class="text-amber-800 font-bold text-sm">
                                                                                                No specific employee assigned yet.</p>
                                                                                            <p class="text-amber-600 text-xs mt-1">Next
                                                                                                shift starts at <span
                                                                                                    x-text="reliever.start_time"
                                                                                                    class="font-bold"></span></p>
                                                                                        </div>
                                                                                        <button @click="relieverModal = false"
                                                                                            class="block w-full py-3 bg-slate-100 text-slate-600 font-bold rounded-xl hover:bg-slate-200 transition-all uppercase tracking-widest">Close</button>
                                                                                    </div>
                                                                                </template>
                                                                                <template x-if="reliever && reliever.self_relief">
                                                                                    <div class="py-4">
                                                                                        <div
                                                                                            class="bg-blue-50 rounded-xl p-4 border border-blue-100 mb-4">
                                                                                            <p class="text-blue-800 font-bold text-sm">
                                                                                                You are scheduled for the next shift.
                                                                                            </p>
                                                                                            <p class="text-blue-600 text-xs mt-1">Good
                                                                                                luck!</p>
                                                                                        </div>
                                                                                        <button @click="relieverModal = false"
                                                                                            class="block w-full py-3 bg-slate-100 text-slate-600 font-bold rounded-xl hover:bg-slate-200 transition-all uppercase tracking-widest">Close</button>
                                                                                    </div>
                                                                                </template>
                                                                            </div>
                                                                        </div>
                                                                        <div x-show="!loadingReliever && !reliever" class="text-center py-8">
                                                                            <p class="text-gray-500 font-medium">No next schedule found.
                                                                            </p>
                                                                            <button @click="relieverModal = false"
                                                                                class="mt-4 px-6 py-2 bg-slate-100 text-slate-600 font-bold rounded-lg hover:bg-slate-200 transition-all uppercase tracking-wider text-xs">Close</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- Tour Progress Modal -->
                                                        <div x-show="tourProgress" class="fixed inset-0 z-50 overflow-y-auto"
                                                            style="display: none;">
                                                            <div class="flex items-center justify-center min-h-screen px-4">
                                                                <div class="fixed inset-0 bg-slate-900/40 backdrop-blur-sm transition-opacity"
                                                                    @click="tourProgress = false"></div>
                                                                <div
                                                                    class="relative bg-white rounded-2xl max-w-3xl w-full p-8 shadow-xl overflow-hidden">
                                                                    <div class="flex justify-between items-center mb-6">
                                                                        <div>
                                                                            <div class="flex items-center gap-2">
                                                                                <h3 class="text-xl font-bold text-gray-900">Tour Status &
                                                                                    Progress</h3>
                                                                                <span
                                                                                    class="px-2 py-0.5 bg-slate-100 text-slate-600 text-[10px] font-black rounded uppercase tracking-widest">Duty
                                                                                    #{{ $job->duty_number }}</span>
                                                                            </div>
                                                                            <p class="text-xs text-gray-500 font-medium mt-1">Monitor
                                                                                checkpoint intervals and scan history for this deployment.
                                                                            </p>
                                                                        </div>
                                                                        <button @click="tourProgress = false"
                                                                            class="text-gray-400 hover:text-gray-600 bg-gray-50 p-2 rounded-xl transition-colors">
                                                                            <svg class="w-5 h-5" fill="none" stroke="currentColor"
                                                                                viewBox="0 0 24 24">
                                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                                    stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                                                            </svg>
                                                                        </button>
                                                                    </div>

                                                                    <div class="space-y-8 max-h-[70vh] overflow-y-auto pr-2 custom-scrollbar">
                                                                        <!-- Quick Scan Hub -->
                                                                        <div
                                                                            class="bg-slate-900 rounded-2xl p-6 shadow-lg shadow-slate-200 border border-slate-800">
                                                                            <div class="flex flex-col md:flex-row items-center gap-4">
                                                                                <div class="flex-1 w-full text-left">
                                                                                    <h4
                                                                                        class="text-white text-xs font-black uppercase tracking-[0.2em] mb-1">
                                                                                        Checkpoint Verification</h4>
                                                                                    <p class="text-slate-400 text-[10px]">Enter checkpoint
                                                                                        ID to record verification.</p>
                                                                                </div>
                                                                                <form action="{{ route('employee.jobs.scan', $job->id) }}"
                                                                                    method="POST" enctype="multipart/form-data"
                                                                                    class="location-required flex-shrink-0 w-full md:w-auto"
                                                                                    x-on:submit="scanning = true">
                                                                                    @csrf
                                                                                    <div
                                                                                        class="relative flex items-center bg-white/10 rounded-xl border border-white/20 p-1 focus-within:border-blue-500 transition-all">
                                                                                        <input type="text" name="checkpoint_code" required
                                                                                            x-model="scanCode" placeholder="ENTER ID #..."
                                                                                            :readonly="scanning"
                                                                                            class="bg-transparent text-white px-4 py-2 text-xs font-black uppercase tracking-widest focus:outline-none placeholder:text-white/30 w-full md:w-48 disabled:opacity-50"
                                                                                            :class="scanning ? 'opacity-50 pointer-events-none' : ''">
                                                                                        <button type="submit" :disabled="scanning"
                                                                                            class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg text-[9px] font-black uppercase tracking-widest transition-all min-w-[100px] flex items-center justify-center">
                                                                                            <template x-if="!scanning">
                                                                                                <span>VERIFY</span>
                                                                                            </template>
                                                                                            <template x-if="scanning">
                                                                                                <div class="flex items-center gap-2">
                                                                                                    <svg class="animate-spin h-3 w-3 text-white"
                                                                                                        fill="none" viewBox="0 0 24 24">
                                                                                                        <circle class="opacity-25" cx="12"
                                                                                                            cy="12" r="10" stroke="currentColor"
                                                                                                            stroke-width="4"></circle>
                                                                                                        <path class="opacity-75"
                                                                                                            fill="currentColor"
                                                                                                            d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z">
                                                                                                        </path>
                                                                                                    </svg>
                                                                                                    <span class="text-[8px]">SCANNING...</span>
                                                                                                </div>
                                                                                            </template>
                                                                                        </button>
                                                                                    </div>

                                                                                    <!-- Dynamic Extra Fields -->
                                                                                    <div x-show="activeCheckpoint && activeCheckpoint.options && activeCheckpoint.options.type !== 'log_only'"
                                                                                        x-transition
                                                                                        class="mt-4 pt-4 border-t border-white/10 space-y-4">

                                                                                        <template
                                                                                            x-if="activeCheckpoint.options.type === 'message'">
                                                                                            <div class="space-y-2">
                                                                                                <label
                                                                                                    class="block text-[10px] font-black text-blue-400 uppercase tracking-widest">Observation
                                                                                                    / Message</label>
                                                                                                <div class="p-3 bg-white/5 rounded-xl border border-white/10 text-[10px] text-amber-400 italic mb-2"
                                                                                                    x-text="'Instruction: ' + activeCheckpoint.options.message_content">
                                                                                                </div>
                                                                                                <textarea name="employee_message" required
                                                                                                    class="w-full bg-white/5 border border-white/20 rounded-xl px-4 py-3 text-sm text-white focus:border-blue-500 transition-all placeholder:text-white/20"
                                                                                                    placeholder="Type your message here..."></textarea>
                                                                                            </div>
                                                                                        </template>

                                                                                        <template
                                                                                            x-if="activeCheckpoint.options.type === 'photo'">
                                                                                            <div class="space-y-3">
                                                                                                <div class="flex items-center justify-between">
                                                                                                    <label
                                                                                                        class="block text-[10px] font-black text-emerald-400 uppercase tracking-widest">Evidence
                                                                                                        Photos</label>
                                                                                                    <span
                                                                                                        class="text-[9px] font-bold text-slate-400 uppercase"
                                                                                                        x-text="activeCheckpoint.options.allow_multiple_photos ? 'Multiple allowed' : 'Single photo'"></span>
                                                                                                </div>
                                                                                                <div class="p-3 bg-white/5 rounded-xl border border-white/10 text-[10px] text-amber-400 italic"
                                                                                                    x-text="'Requirement: ' + activeCheckpoint.options.photo_description">
                                                                                                </div>

                                                                                                <div class="relative group mt-2">
                                                                                                    <input type="file"
                                                                                                        :name="activeCheckpoint.options.allow_multiple_photos ? 'additional_photos[]' : 'image'"
                                                                                                        :multiple="activeCheckpoint.options.allow_multiple_photos"
                                                                                                        @change="fileCount = $event.target.files.length"
                                                                                                        class="hidden" id="extra_photos">
                                                                                                    <label for="extra_photos"
                                                                                                        class="flex items-center justify-center gap-2 w-full p-4 bg-white/5 border-2 border-dashed border-white/10 rounded-xl hover:bg-white/10 hover:border-emerald-500/50 cursor-pointer transition-all">
                                                                                                        <svg class="w-5 h-5 text-emerald-500"
                                                                                                            fill="none" stroke="currentColor"
                                                                                                            viewBox="0 0 24 24">
                                                                                                            <path stroke-linecap="round"
                                                                                                                stroke-linejoin="round"
                                                                                                                stroke-width="2"
                                                                                                                d="M3 9a2 2 0 012-2h.93a2 2 0 001.664-.89l.812-1.22A2 2 0 0110.07 4h3.86a2 2 0 011.664.89l.812 1.22A2 2 0 0018.07 7H19a2 2 0 012 2v9a2 2 0 01-2 2H5a2 2 0 01-2-2V9z" />
                                                                                                        </svg>
                                                                                                        <span
                                                                                                            class="text-xs font-bold text-emerald-200"
                                                                                                            x-text="fileCount > 0 ? fileCount + ' files selected' : 'SELECT PHOTOS / CAPTURE'"></span>
                                                                                                    </label>
                                                                                                </div>
                                                                                            </div>
                                                                                        </template>
                                                                                    </div>
                                                                                </form>
                                                                            </div>
                                                                        </div>

                                                                        @forelse($job->tourRoutes as $tour)
                                                                            <div class="bg-slate-50/50 rounded-2xl border border-slate-100 p-6">
                                                                                <div
                                                                                    class="flex items-center justify-between mb-4 pb-4 border-b border-slate-100">
                                                                                    <div>
                                                                                        <h4
                                                                                            class="text-sm font-black text-slate-800 uppercase tracking-wider">
                                                                                            {{ $tour->description }}
                                                                                        </h4>
                                                                                        <p
                                                                                            class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mt-1">
                                                                                            Tour Route Assigned</p>
                                                                                    </div>
                                                                                    <div class="text-right">
                                                                                        <span
                                                                                            class="text-[10px] font-black px-2 py-1 bg-blue-100 text-blue-700 rounded-lg uppercase tracking-wider">{{ $tour->checkpoints->count() }}
                                                                                            Checkpoints</span>
                                                                                    </div>
                                                                                </div>

                                                                                <div class="grid grid-cols-1 gap-4">
                                                                                    @foreach($tour->checkpoints as $cp)
                                                                                        @php
                                                                                            $lastScan = $job->checkpointScans->where('checkpoint_id', $cp->id)->sortByDesc('scanned_at')->first();
                                                                                            $nextScan = $lastScan ? $lastScan->scanned_at->addMinutes($cp->scan_interval_minutes) : null;
                                                                                            $isOverdue = $nextScan && $nextScan->isPast();
                                                                                            $opts = is_string($cp->extra_scan_options) ? json_decode($cp->extra_scan_options, true) : $cp->extra_scan_options;
                                                                                        @endphp
                                                                                        <div
                                                                                            class="bg-white p-4 rounded-xl border border-slate-100 shadow-sm flex flex-col md:flex-row md:items-center justify-between gap-4">
                                                                                            <div class="flex items-center gap-3">
                                                                                                <div
                                                                                                    class="w-10 h-10 rounded-lg bg-slate-50 flex items-center justify-center border border-slate-100">
                                                                                                    <svg class="w-5 h-5 text-slate-400" fill="none"
                                                                                                        stroke="currentColor" viewBox="0 0 24 24">
                                                                                                        <path stroke-linecap="round"
                                                                                                            stroke-linejoin="round" stroke-width="2"
                                                                                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                                                                        <path stroke-linecap="round"
                                                                                                            stroke-linejoin="round" stroke-width="2"
                                                                                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                                                                    </svg>
                                                                                                </div>
                                                                                                <div>
                                                                                                    <div
                                                                                                        class="text-sm font-bold text-slate-700 flex items-center gap-2">
                                                                                                        {{ $cp->name }}
                                                                                                        <span
                                                                                                            class="text-[9px] font-black text-slate-300">#{{ $cp->checkpoint_id_code }}</span>
                                                                                                    </div>
                                                                                                    <div
                                                                                                        class="flex flex-wrap items-center gap-2 mt-0.5">
                                                                                                        <span
                                                                                                            class="text-[10px] font-bold text-slate-400 uppercase tracking-wide">Interval:
                                                                                                            {{ $cp->scan_interval_minutes }}m</span>
                                                                                                        @if($cp->grace_period_minutes > 0)
                                                                                                            <span
                                                                                                                class="text-[10px] font-bold text-amber-500 uppercase tracking-wide">•
                                                                                                                Grace:
                                                                                                                {{ $cp->grace_period_minutes }}m</span>
                                                                                                        @endif
                                                                                                        @if($opts && isset($opts['type']) && $opts['type'] !== 'log_only')
                                                                                                            <span
                                                                                                                class="text-[9px] font-black uppercase tracking-wider px-2 py-0.5 rounded-full {{ $opts['type'] === 'message' ? 'bg-blue-50 text-blue-600' : 'bg-emerald-50 text-emerald-600' }}">
                                                                                                                •
                                                                                                                {{ $opts['type'] === 'message' ? 'Message Required' : 'Photos Required' }}
                                                                                                            </span>
                                                                                                        @endif
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>

                                                                                            <div class="flex flex-wrap items-center gap-6">
                                                                                                <div class="text-right">
                                                                                                    <div
                                                                                                        class="text-[9px] font-bold text-slate-400 uppercase tracking-widest mb-1">
                                                                                                        Status</div>
                                                                                                    @if($lastScan)
                                                                                                        <div class="flex flex-col items-end">
                                                                                                            <span
                                                                                                                class="text-[10px] font-black text-emerald-600 uppercase tracking-wider">Scanned
                                                                                                                {{ $lastScan->scanned_at->diffForHumans() }}</span>
                                                                                                            @if($nextScan)
                                                                                                                <span
                                                                                                                    class="text-[9px] font-bold {{ $isOverdue ? 'text-red-500 animate-pulse' : 'text-slate-400' }} mt-0.5">Next:
                                                                                                                    {{ $nextScan->format('H:i') }}</span>
                                                                                                            @endif
                                                                                                        </div>
                                                                                                    @else
                                                                                                        <span
                                                                                                            class="text-[10px] font-black text-amber-500 uppercase tracking-wider">Pending
                                                                                                            Initial Scan</span>
                                                                                                    @endif
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    @endforeach
                                                                                </div>
                                                                            </div>
                                                                        @empty
                                                                            <div
                                                                                class="text-center py-12 bg-slate-50 border border-dashed border-slate-200 rounded-3xl">
                                                                                <div
                                                                                    class="w-16 h-16 bg-white rounded-full flex items-center justify-center mx-auto mb-4 border border-slate-100 shadow-sm">
                                                                                    <svg class="w-6 h-6 text-slate-300" fill="none"
                                                                                        stroke="currentColor" viewBox="0 0 24 24">
                                                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                                                            stroke-width="2"
                                                                                            d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                                                                                    </svg>
                                                                                </div>
                                                                                <p
                                                                                    class="text-xs font-black text-slate-400 uppercase tracking-widest">
                                                                                    No Tour Routes Assigned</p>
                                                                                <p class="text-[10px] text-slate-400 mt-1">This site does not
                                                                                    currently require tour patrols.</p>
                                                                            </div>
                                                                        @endforelse

                                                                        <!-- Scan History Component -->
                                                                        @if($job->checkpointScans->count() > 0)
                                                                            <div class="mt-8 border-t border-slate-100 pt-8">
                                                                                <h4
                                                                                    class="text-xs font-black text-slate-900 uppercase tracking-widest mb-4 flex items-center gap-2">
                                                                                    <svg class="w-4 h-4 text-emerald-500" fill="none"
                                                                                        stroke="currentColor" viewBox="0 0 24 24">
                                                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                                                            stroke-width="2"
                                                                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                                                    </svg>
                                                                                    Recent Scan History
                                                                                </h4>
                                                                                <div class="space-y-3">
                                                                                    @foreach($job->checkpointScans->sortByDesc('scanned_at')->take(5) as $scan)
                                                                                        <div
                                                                                            class="flex items-center justify-between p-3 bg-slate-50 border border-slate-100 rounded-xl">
                                                                                            <div class="flex items-center gap-3">
                                                                                                <div
                                                                                                    class="w-2 h-2 rounded-full bg-emerald-500 shadow-[0_0_8px_rgba(16,185,129,0.5)]">
                                                                                                </div>
                                                                                                <span
                                                                                                    class="text-xs font-bold text-slate-700">{{ $scan->checkpoint->name }}</span>
                                                                                            </div>
                                                                                            <div class="flex items-center gap-3 text-right">
                                                                                                <span
                                                                                                    class="text-[10px] font-bold text-slate-500 uppercase">{{ $scan->scanned_at->format('H:i:s') }}</span>
                                                                                                @if($scan->is_manual)
                                                                                                    <span
                                                                                                        class="text-[9px] font-black px-1.5 py-0.5 bg-slate-200 text-slate-600 rounded uppercase tracking-tighter">Manual</span>
                                                                                                @else
                                                                                                    <span
                                                                                                        class="text-[9px] font-black px-1.5 py-0.5 bg-emerald-100 text-emerald-700 rounded uppercase tracking-tighter">Verified</span>
                                                                                                @endif
                                                                                            </div>
                                                                                        </div>
                                                                                    @endforeach
                                                                                </div>
                                                                            </div>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @else
                                                        <div class="flex gap-2 justify-end">
                                                            <a href="{{ route('employee.jobs.report', $job->id) }}" target="_blank"
                                                                class="px-3 py-2 bg-gray-50 border border-gray-200 text-gray-600 hover:bg-gray-100 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all">
                                                                Report
                                                            </a>
                                                            <button disabled
                                                                class="px-3 py-2 bg-slate-100 text-slate-400 rounded-lg text-[10px] font-bold uppercase tracking-wider cursor-not-allowed">
                                                                Completed
                                                            </button>
                                                        </div>
                                                    @endif
                                                </div>

                                                <!-- Modals (Check-in, Check-out, etc) -->
                                                <!-- Identical modal content but inside the row scope -->
                                                <!-- Checkin Modal -->
                                                <div x-show="checkin" class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
                                                    <div class="flex items-center justify-center min-h-screen px-4">
                                                        <div class="fixed inset-0 bg-slate-900/40 backdrop-blur-sm transition-opacity"
                                                            @click="checkin = false"></div>
                                                        <div class="relative bg-white rounded-2xl max-w-lg w-full p-8 shadow-xl">
                                                            <h3 class="text-lg font-bold text-gray-900 mb-2">Check-In
                                                                Confirmation</h3>
                                                            <p class="text-xs text-gray-500 font-medium mb-6">Upload visual
                                                                verification
                                                                to
                                                                confirm arrival at site.</p>

                                                            <form action="{{ route('employee.jobs.checkin', $job->id) }}" method="POST"
                                                                enctype="multipart/form-data" class="location-required">
                                                                @csrf
                                                                <div class="mb-6">
                                                                    <div
                                                                        class="border-2 border-dashed border-gray-300 rounded-xl p-8 text-left hover:bg-slate-50 hover:border-slate-400 transition-all cursor-pointer relative">
                                                                        <input type="file" name="images[]" multiple required
                                                                            accept="image/*"
                                                                            class="absolute inset-0 w-full h-full opacity-0 cursor-pointer"
                                                                            @change="fileCount = $el.files.length">
                                                                        <svg class="w-10 h-10 text-gray-400 mx-auto mb-3" fill="none"
                                                                            stroke="currentColor" viewBox="0 0 24 24">
                                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                                stroke-width="1.5"
                                                                                d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                                                            </path>
                                                                        </svg>
                                                                        <span
                                                                            class="text-xs font-bold text-gray-500 uppercase tracking-wide">Upload
                                                                            Images</span>
                                                                        <p class="text-[10px] text-gray-400 mt-1" x-show="fileCount > 0"
                                                                            x-text="fileCount + ' files selected'"></p>
                                                                    </div>
                                                                </div>
                                                                <div x-show="uploading" x-transition
                                                                    class="w-full bg-gray-100 rounded-full h-2 mt-4 mb-4">
                                                                    <div class="bg-slate-900 h-2 rounded-full transition-all duration-300"
                                                                        :style="'width: ' + progress + '%'"></div>
                                                                </div>
                                                                <div class="flex justify-end gap-3">
                                                                    <button type="button" @click="checkin = false" :disabled="uploading"
                                                                        class="px-4 py-2 text-xs font-bold text-gray-500 hover:text-gray-700 uppercase tracking-wider">Cancel</button>
                                                                    <button type="submit" :disabled="uploading"
                                                                        class="px-6 py-2 bg-slate-900 text-white rounded-lg text-xs font-bold uppercase tracking-wider hover:bg-black transition-all">
                                                                        <span x-show="!uploading">Confirm Check-In</span>
                                                                        <span x-show="uploading">Processing...</span>
                                                                    </button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Report Incident Modal -->
                                                <div x-show="reportIncident" class="fixed inset-0 z-50 overflow-y-auto"
                                                    style="display: none;">
                                                    <div class="flex items-center justify-center min-h-screen px-4">
                                                        <div class="fixed inset-0 bg-slate-900/40 backdrop-blur-sm transition-opacity"
                                                            @click="reportIncident = false"></div>
                                                        <div class="relative bg-white rounded-2xl max-w-lg w-full p-8 shadow-xl">
                                                            <!-- Loader Overlay -->
                                                            <div x-show="uploading"
                                                                class="absolute inset-0 bg-white/80 backdrop-blur-sm z-50 flex flex-col items-center justify-center rounded-2xl"
                                                                style="display: none;">
                                                                <div class="w-64">
                                                                    <div class="w-full bg-gray-100 rounded-full h-2">
                                                                        <div class="bg-slate-900 h-2 rounded-full transition-all duration-300"
                                                                            :style="'width: ' + progress + '%'"></div>
                                                                    </div>
                                                                    <p
                                                                        class="text-[10px] font-bold text-gray-600 mt-3 text-left uppercase tracking-widest animate-pulse">
                                                                        Uploading
                                                                        Evidence...</p>
                                                                </div>
                                                            </div>

                                                            <h3 class="text-lg font-bold text-gray-900 mb-2 text-left">Report Incident
                                                            </h3>
                                                            <p class="text-xs text-gray-500 font-medium mb-6 text-left">Log unusual
                                                                activity or
                                                                breaches during patrols.</p>

                                                            <form action="{{ route('employee.jobs.incident', $job->id) }}" method="POST"
                                                                enctype="multipart/form-data" @submit="startUpload()">
                                                                @csrf
                                                                <div class="space-y-4 mb-6">
                                                                    <div>
                                                                        <label
                                                                            class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Category
                                                                            Type</label>
                                                                        <select x-model="selectedParent" name="incident_parent_category_id"
                                                                            required
                                                                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-sm font-semibold focus:outline-none focus:border-slate-500 transition-colors">
                                                                            <option value="">Select Category Type</option>
                                                                            <template x-for="cat in window.incidentCategories"
                                                                                :key="cat.id">
                                                                                <option :value="cat.id"
                                                                                    x-text="cat.code + ' - ' + cat.description">
                                                                                </option>
                                                                            </template>
                                                                        </select>
                                                                    </div>
                                                                    <div x-show="selectedParent">
                                                                        <label
                                                                            class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Specific
                                                                            Category</label>
                                                                        <select name="incident_category_id" x-model="selectedChild" required
                                                                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-sm font-semibold focus:outline-none focus:border-slate-500 transition-colors">
                                                                            <option value="">Select Specific Category</option>
                                                                            <template
                                                                                x-for="child in (window.incidentCategories.find(c => c.id == selectedParent)?.incident_categories || [])"
                                                                                :key="child.id">
                                                                                <option :value="child.id"
                                                                                    x-text="child.code ? (child.code + ' - ' + child.description) : child.description">
                                                                                </option>
                                                                            </template>
                                                                        </select>
                                                                    </div>
                                                                    <div>
                                                                        <label
                                                                            class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Incident
                                                                            Title</label>
                                                                        <input type="text" name="subject" required
                                                                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-sm font-semibold focus:outline-none focus:border-slate-500 transition-colors">
                                                                    </div>
                                                                    <div>
                                                                        <label
                                                                            class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Details</label>
                                                                        <textarea name="description" rows="4" required
                                                                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-sm font-medium focus:outline-none focus:border-slate-500 transition-colors"></textarea>
                                                                    </div>
                                                                    <div>
                                                                        <label
                                                                            class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Evidence</label>
                                                                        <input type="file" name="images[]" multiple
                                                                            class="w-full text-xs text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-[10px] file:font-bold file:uppercase file:bg-slate-100 file:text-slate-700 hover:file:bg-slate-200">
                                                                    </div>
                                                                </div>
                                                                <div class="flex justify-start gap-3">
                                                                    <button type="button" @click="reportIncident = false"
                                                                        :disabled="uploading"
                                                                        class="px-4 py-2 text-xs font-bold text-gray-500 hover:text-gray-700 uppercase tracking-wider">Cancel</button>
                                                                    <button type="submit" :disabled="uploading"
                                                                        class="px-6 py-2 bg-red-600 text-white rounded-lg text-xs font-bold uppercase tracking-wider hover:bg-red-700 transition-all">
                                                                        <span x-show="!uploading">Submit Report</span>
                                                                        <span x-show="uploading">Processing...</span>
                                                                    </button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Checkout Evidence Modal -->
                                                <div x-show="checkout" class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
                                                    <div class="flex items-center justify-center min-h-screen px-4">
                                                        <div class="fixed inset-0 bg-slate-900/40 backdrop-blur-sm transition-opacity"
                                                            @click="checkout = false"></div>
                                                        <div class="relative bg-white rounded-2xl max-w-lg w-full p-8 shadow-xl">
                                                            <h3 class="text-lg font-bold text-gray-900 mb-2">Upload Evidence
                                                            </h3>
                                                            <p class="text-xs text-gray-500 font-medium mb-6">Add more photos to
                                                                the
                                                                job
                                                                log.</p>

                                                            <form action="{{ route('employee.jobs.checkout.evidence', $job->id) }}"
                                                                method="POST" enctype="multipart/form-data" @submit="startUpload()">
                                                                @csrf
                                                                <div class="mb-6">
                                                                    <div
                                                                        class="border-2 border-dashed border-gray-300 rounded-xl p-8 text-left hover:bg-slate-50 hover:border-slate-400 transition-all cursor-pointer relative">
                                                                        <input type="file" name="images[]" multiple required
                                                                            accept="image/*"
                                                                            class="absolute inset-0 w-full h-full opacity-0 cursor-pointer"
                                                                            @change="fileCount = $el.files.length">
                                                                        <svg class="w-10 h-10 text-gray-400 mx-auto mb-3" fill="none"
                                                                            stroke="currentColor" viewBox="0 0 24 24">
                                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                                stroke-width="1.5"
                                                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                                                            </path>
                                                                        </svg>
                                                                        <span
                                                                            class="text-xs font-bold text-gray-500 uppercase tracking-wide">Select
                                                                            Images</span>
                                                                        <p class="text-[10px] text-gray-400 mt-1" x-show="fileCount > 0"
                                                                            x-text="fileCount + ' files selected'"></p>
                                                                    </div>
                                                                </div>
                                                                <div x-show="uploading" x-transition
                                                                    class="w-full bg-gray-100 rounded-full h-2 mt-4 mb-4">
                                                                    <div class="bg-slate-900 h-2 rounded-full transition-all duration-300"
                                                                        :style="'width: ' + progress + '%'"></div>
                                                                </div>
                                                                <div class="flex justify-start gap-3">
                                                                    <button type="button" @click="checkout = false" :disabled="uploading"
                                                                        class="px-4 py-2 text-xs font-bold text-gray-500 hover:text-gray-700 uppercase tracking-wider">Cancel</button>
                                                                    <button type="submit" :disabled="uploading"
                                                                        class="px-6 py-2 bg-slate-900 text-white rounded-lg text-xs font-bold uppercase tracking-wider hover:bg-black transition-all">
                                                                        <span x-show="!uploading">Upload</span>
                                                                        <span x-show="uploading">Processing...</span>
                                                                    </button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Job Log / Gallery Modal -->
                                                <div x-show="jobLog" class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
                                                    <div class="flex items-center justify-center min-h-screen px-4">
                                                        <div class="fixed inset-0 bg-slate-900/40 backdrop-blur-sm transition-opacity"
                                                            @click="jobLog = false"></div>
                                                        <div
                                                            class="relative bg-white rounded-2xl max-w-2xl w-full p-6 shadow-xl overflow-hidden">
                                                            <div class="flex justify-between items-center mb-6">
                                                                <div>
                                                                    <h3 class="text-lg font-bold text-gray-900">Job Activity
                                                                        Log
                                                                    </h3>
                                                                    <p class="text-xs text-gray-500 font-medium">Visual evidence
                                                                        and
                                                                        incident reports.</p>
                                                                </div>
                                                                <button @click="jobLog = false" class="text-gray-400 hover:text-gray-600">
                                                                    <svg class="w-5 h-5" fill="none" stroke="currentColor"
                                                                        viewBox="0 0 24 24">
                                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                                            stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                                                    </svg>
                                                                </button>
                                                            </div>

                                                            <div class="space-y-6 max-h-[70vh] overflow-y-auto pr-2">
                                                                <!-- Gallery -->
                                                                <h4
                                                                    class="text-xs font-bold text-gray-900 uppercase tracking-wider mb-3 flex items-center justify-between">
                                                                    <div class="flex items-center gap-2">
                                                                        <svg class="w-4 h-4 text-slate-500" fill="none"
                                                                            stroke="currentColor" viewBox="0 0 24 24">
                                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                                stroke-width="2"
                                                                                d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                                                            </path>
                                                                        </svg>
                                                                        Visual Evidence
                                                                    </div>
                                                                    <span
                                                                        class="text-[10px] bg-slate-100 px-2 py-0.5 rounded-full text-slate-500">
                                                                        {{ count($checkinImages) + count($checkoutImages) + $job->incidents->sum(fn($i) => count($i->images ?? [])) }}
                                                                        Total
                                                                    </span>
                                                                </h4>

                                                                <div class="grid grid-cols-2 md:grid-cols-4 gap-2">
                                                                    @foreach($checkinImages as $img)
                                                                        <div class="relative group aspect-square">
                                                                            <img src="{{ asset('storage/' . $img) }}"
                                                                                class="w-full h-full object-cover rounded-lg border border-gray-200">
                                                                            <span
                                                                                class="absolute bottom-1 left-1 right-1 bg-black/60 text-white text-[7px] px-1 py-0.5 rounded text-center font-bold uppercase tracking-tighter">Check-In</span>
                                                                        </div>
                                                                    @endforeach

                                                                    @foreach($checkoutImages as $img)
                                                                        <div class="relative group aspect-square">
                                                                            <img src="{{ asset('storage/' . $img) }}"
                                                                                class="w-full h-full object-cover rounded-lg border border-gray-200">
                                                                            <span
                                                                                class="absolute bottom-1 left-1 right-1 bg-blue-600/80 text-white text-[7px] px-1 py-0.5 rounded text-center font-bold uppercase tracking-tighter">Evidence</span>
                                                                        </div>
                                                                    @endforeach

                                                                    @foreach($job->incidents as $inc)
                                                                        @foreach($inc->images ?? [] as $img)
                                                                            <div class="relative group aspect-square">
                                                                                <img src="{{ asset('storage/' . $img) }}"
                                                                                    class="w-full h-full object-cover rounded-lg border border-red-100">
                                                                                <span
                                                                                    class="absolute bottom-1 left-1 right-1 bg-red-600/80 text-white text-[7px] px-1 py-0.5 rounded text-center font-bold uppercase tracking-tighter">Incident</span>
                                                                            </div>
                                                                        @endforeach
                                                                    @endforeach
                                                                </div>

                                                                @if(count($checkinImages) == 0 && count($checkoutImages) == 0 && $job->incidents->sum(fn($i) => count($i->images ?? [])) == 0)
                                                                    <div
                                                                        class="bg-gray-50 rounded-lg p-4 text-left border border-dashed border-gray-200">
                                                                        <p class="text-xs text-gray-400 font-medium">No visual evidence found
                                                                            for this deployment.</p>
                                                                    </div>
                                                                @endif

                                                                <button @click="jobLog = false; checkout = true"
                                                                    class="mt-3 w-full py-2 bg-white border border-slate-200 text-slate-600 rounded-lg text-[10px] font-bold uppercase tracking-wider hover:bg-slate-50 transition-all flex items-center justify-center gap-2">
                                                                    <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor"
                                                                        viewBox="0 0 24 24">
                                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                                            stroke-width="2" d="M12 4v16m8-8H4"></path>
                                                                    </svg>
                                                                    <span>Add New Evidence</span>
                                                                </button>
                                                            </div>

                                                            <!-- Incidents -->
                                                            <div>
                                                                <h4
                                                                    class="text-xs font-bold text-gray-900 uppercase tracking-wider mb-3 flex items-center gap-2">
                                                                    <svg class="w-4 h-4 text-red-500" fill="none" stroke="currentColor"
                                                                        viewBox="0 0 24 24">
                                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                                            stroke-width="2"
                                                                            d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                                                                        </path>
                                                                    </svg>
                                                                    Active Reports ({{ $job->incidents->count() }})
                                                                </h4>

                                                                <div class="space-y-2">
                                                                    @forelse($job->incidents as $inc)
                                                                        <div
                                                                            class="bg-white p-3 rounded-lg border border-gray-200 shadow-sm flex items-start gap-3">
                                                                            <div class="w-1.5 h-full min-h-[40px] bg-red-500 rounded-full">
                                                                            </div>
                                                                            <div>
                                                                                <p class="text-xs font-bold text-gray-900">
                                                                                    {{ $inc->subject }}
                                                                                </p>
                                                                                <p class="text-[10px] text-gray-500 mt-0.5">
                                                                                    {{ $inc->created_at->format('M d, H:i') }}
                                                                                    &bull;
                                                                                    {{ Str::limit($inc->description, 60) }}
                                                                                </p>
                                                                            </div>
                                                                        </div>
                                                                    @empty
                                                                        <p class="text-xs text-gray-400 italic pl-2">No
                                                                            incidents
                                                                            reported
                                                                            so far.</p>
                                                                    @endforelse
                                                                </div>

                                                                <button @click="missionLog = false; reportIncident = true"
                                                                    class="mt-3 w-full py-2 bg-red-50 border border-red-100 text-red-600 rounded-lg text-xs font-bold uppercase tracking-wider hover:bg-red-100 transition-all flex items-center justify-center gap-2">
                                                                    <span>Report New Incident</span>
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                            </div>

                            <!-- Request Cancellation Modal -->
                            <div x-show="requestCancellation" class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
                                <div class="flex items-center justify-center min-h-screen px-4">
                                    <div class="fixed inset-0 bg-slate-900/40 backdrop-blur-sm transition-opacity"
                                        @click="requestCancellation = false"></div>
                                    <div class="relative bg-white rounded-2xl max-w-lg w-full p-8 shadow-xl">
                                        <h3 class="text-lg font-bold text-gray-900 mb-2">Request
                                            Cancellation</h3>
                                        <p class="text-xs text-gray-500 font-medium mb-6">Subject to
                                            administrative
                                            approval.</p>

                                        <form action="{{ route('employee.jobs.cancel', $job->id) }}" method="POST">
                                            @csrf
                                            <div class="mb-6">
                                                <label
                                                    class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Reason</label>
                                                <textarea name="reason" rows="3" required
                                                    class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-sm font-medium focus:outline-none focus:border-slate-500 transition-colors"
                                                    placeholder="Briefly explain why..."></textarea>
                                            </div>
                                            <div class="flex justify-start gap-3">
                                                <button type="button" @click="requestCancellation = false"
                                                    class="px-4 py-2 text-xs font-bold text-gray-500 hover:text-gray-700 uppercase tracking-wider">Dismiss</button>
                                                <button type="submit"
                                                    class="px-6 py-2 bg-slate-900 text-white rounded-lg text-xs font-bold uppercase tracking-wider hover:bg-black transition-all">Request</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            </td>
                            </tr>
                        @empty
                <tr>
                    <td colspan="5" class="px-6 py-12 text-left text-gray-400">
                        <svg class="w-16 h-16 mx-auto mb-4 text-gray-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2">
                            </path>
                        </svg>
                        <p class="text-xs font-bold uppercase tracking-wider">No assignments found</p>
                    </td>
                </tr>
            @endforelse
            </tbody>
            </table>
        </div>

        @if($jobs->hasPages())
            <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
                {{ $jobs->links() }}
            </div>
        @endif
    </div>
    </div>
    <script>
        window.incidentCategories = @json($categories);
    </script>
@endsection