@extends('layouts.employee')

@section('title', 'Performance Analytics')

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Performance Analytics</h1>
                <p class="text-sm text-gray-500 mt-1">Comprehensive metrics for Guard and Patroller operations.</p>
            </div>

            <div class="flex items-center gap-2">
                <span class="text-sm font-medium text-gray-500">Period:</span>
                <select
                    class="border-gray-200 rounded-lg text-sm shadow-sm focus:border-slate-900 focus:ring-slate-900 bg-white">
                    <option>Last 30 Days</option>
                </select>
            </div>
        </div>

        <!-- High-Level Stats Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <!-- Attendance Rate -->
            <div class="bg-white p-6 rounded-2xl border border-gray-100 shadow-sm relative overflow-hidden">
                <div class="absolute top-0 right-0 w-20 h-20 bg-emerald-50 rounded-full -mr-8 -mt-8"></div>
                <div class="flex items-center justify-between mb-4 relative z-10">
                    <h3 class="text-xs font-bold text-gray-400 uppercase tracking-wider">Attendance Rate</h3>
                    <span class="p-2 bg-emerald-100/50 text-emerald-600 rounded-xl">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline relative z-10">
                    <span class="text-3xl font-bold text-gray-900">{{ $attendanceRate }}%</span>
                </div>
                <div class="mt-2 text-[10px] text-emerald-600 font-bold uppercase tracking-widest relative z-10">
                    Consolidated</div>
            </div>

            <!-- Total Incidents -->
            <div class="bg-white p-6 rounded-2xl border border-gray-100 shadow-sm relative overflow-hidden">
                <div class="absolute top-0 right-0 w-20 h-20 bg-amber-50 rounded-full -mr-8 -mt-8"></div>
                <div class="flex items-center justify-between mb-4 relative z-10">
                    <h3 class="text-xs font-bold text-gray-400 uppercase tracking-wider">Field Reports</h3>
                    <span class="p-2 bg-amber-100/50 text-amber-600 rounded-xl">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                            </path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline relative z-10">
                    <span class="text-3xl font-bold text-gray-900">{{ $incidentCount + $patrollerTickets }}</span>
                </div>
                <div class="mt-2 text-[10px] text-amber-600 font-bold uppercase tracking-widest relative z-10">
                    {{ $incidentCount }} Incidents | {{ $patrollerTickets }} Tickets
                </div>
            </div>

            <!-- Avg Duration -->
            <div class="bg-white p-6 rounded-2xl border border-gray-100 shadow-sm relative overflow-hidden">
                <div class="absolute top-0 right-0 w-20 h-20 bg-blue-50 rounded-full -mr-8 -mt-8"></div>
                <div class="flex items-center justify-between mb-4 relative z-10">
                    <h3 class="text-xs font-bold text-gray-400 uppercase tracking-wider">Avg Shift length</h3>
                    <span class="p-2 bg-blue-100/50 text-blue-600 rounded-xl">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline relative z-10">
                    <span class="text-3xl font-bold text-gray-900">{{ $avgShiftDuration }}</span>
                    <span class="text-lg text-gray-400 font-medium pl-1">h</span>
                </div>
                <div class="mt-2 text-[10px] text-blue-600 font-bold uppercase tracking-widest relative z-10">Active Time
                </div>
            </div>

            <!-- Total Revenue 30d (Inferred from incomeData) -->
            <div class="bg-white p-6 rounded-2xl border border-gray-100 shadow-sm relative overflow-hidden">
                <div class="absolute top-0 right-0 w-20 h-20 bg-slate-50 rounded-full -mr-8 -mt-8"></div>
                <div class="flex items-center justify-between mb-4 relative z-10">
                    <h3 class="text-xs font-bold text-gray-400 uppercase tracking-wider">Monthly Income</h3>
                    <span class="p-2 bg-slate-100 text-slate-600 rounded-xl">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                            </path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline relative z-10">
                    <span class="text-3xl font-bold text-gray-900">${{ number_format(end($incomeData), 2) }}</span>
                </div>
                <div class="mt-2 text-[10px] text-slate-600 font-bold uppercase tracking-widest relative z-10">Current Month
                </div>
            </div>
        </div>

        <!-- Role-Specific Breakdown -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Guard Jobs Stats -->
            <div class="bg-white p-8 rounded-2xl border border-gray-100 shadow-sm">
                <div class="flex items-center justify-between mb-8">
                    <div>
                        <h3 class="text-lg font-bold text-gray-900">Guard Job Operations</h3>
                        <p class="text-xs text-gray-500">Static site deployment metrics (30d)</p>
                    </div>
                    <div class="w-10 h-10 bg-slate-900 rounded-xl flex items-center justify-center text-white">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z">
                            </path>
                        </svg>
                    </div>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div class="p-4 bg-gray-50 rounded-xl">
                        <p class="text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-1">Total Shifts</p>
                        <p class="text-2xl font-bold text-gray-900">{{ $guardShiftCount }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-xl">
                        <p class="text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-1">Completed</p>
                        <p class="text-2xl font-bold text-emerald-600">{{ $guardCompletedCount }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-xl">
                        <p class="text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-1">Missed</p>
                        <p class="text-2xl font-bold text-red-600">{{ $guardMissedCount }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-xl">
                        <p class="text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-1">Upcoming</p>
                        <p class="text-2xl font-bold text-blue-600">{{ $guardUpcomingCount }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-xl">
                        <p class="text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-1">Cancelled</p>
                        <p class="text-2xl font-bold text-orange-600">{{ $guardCancelledCount }}</p>
                    </div>
                </div>
            </div>

            <!-- Patroller Jobs Stats -->
            <div class="bg-white p-8 rounded-2xl border border-gray-100 shadow-sm">
                <div class="flex items-center justify-between mb-8">
                    <div>
                        <h3 class="text-lg font-bold text-gray-900">Patroller Operations</h3>
                        <p class="text-xs text-gray-500">Route-based patrol metrics (30d)</p>
                    </div>
                    <div class="w-10 h-10 bg-purple-600 rounded-xl flex items-center justify-center text-white">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7">
                            </path>
                        </svg>
                    </div>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div class="p-4 bg-gray-50 rounded-xl">
                        <p class="text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-1">Total Routes</p>
                        <p class="text-2xl font-bold text-gray-900">{{ $patrollerShiftCount }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-xl">
                        <p class="text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-1">Completed</p>
                        <p class="text-2xl font-bold text-emerald-600">{{ $patrollerCompletedCount }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-xl">
                        <p class="text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-1">Missed</p>
                        <p class="text-2xl font-bold text-red-600">{{ $patrollerMissedCount }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-xl">
                        <p class="text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-1">Upcoming</p>
                        <p class="text-2xl font-bold text-blue-600">{{ $patrollerUpcomingCount }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Long-Term Trends -->
        <div class="grid grid-cols-1 gap-6">
            <!-- 12-Month Income Trend -->
            <div class="bg-white p-8 rounded-2xl border border-gray-100 shadow-sm">
                <div class="flex items-center justify-between mb-8">
                    <div>
                        <h3 class="text-lg font-bold text-gray-900">Income Overview</h3>
                        <p class="text-xs text-gray-500">Consolidated earnings trend over the last 12 months</p>
                    </div>
                </div>
                <div class="relative h-80">
                    <canvas id="incomeTrendChart"></canvas>
                </div>
            </div>

            <!-- 12-Month Incident Trend -->
            <div class="bg-white p-8 rounded-2xl border border-gray-100 shadow-sm">
                <div class="flex items-center justify-between mb-8">
                    <div>
                        <h3 class="text-lg font-bold text-gray-900">Incident & Ticket Trends</h3>
                        <p class="text-xs text-gray-500">Field activity reporting over the last 12 months</p>
                    </div>
                </div>
                <div class="relative h-80">
                    <canvas id="reportingTrendChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const chartConfig = {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: { display: false }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: { color: '#f3f4f6', drawBorder: false },
                        ticks: { font: { weight: 'bold', size: 10 }, color: '#9ca3af' }
                    },
                    x: {
                        grid: { display: false },
                        ticks: { font: { weight: 'bold', size: 11 }, color: '#4b5563' }
                    }
                }
            };

            // Income Trend Chart
            new Chart(document.getElementById('incomeTrendChart'), {
                type: 'line',
                data: {
                    labels: @json($monthLabels),
                    datasets: [{
                        label: 'Gross Income',
                        data: @json($incomeData),
                        borderColor: '#0f172a',
                        backgroundColor: 'rgba(15, 23, 42, 0.05)',
                        borderWidth: 3,
                        tension: 0.4,
                        fill: true,
                        pointBackgroundColor: '#fff',
                        pointBorderColor: '#0f172a',
                        pointBorderWidth: 2,
                        pointRadius: 4,
                        pointHoverRadius: 6
                    }]
                },
                options: chartConfig
            });

            // Reporting Trend Chart
            new Chart(document.getElementById('reportingTrendChart'), {
                type: 'bar',
                data: {
                    labels: @json($monthLabels),
                    datasets: [{
                        label: 'Total Reports',
                        data: @json($trendIncidentData),
                        backgroundColor: '#f59e0b',
                        borderRadius: 6,
                        barThickness: 'flex'
                    }]
                },
                options: chartConfig
            });
        });
    </script>
@endsection