@extends('layouts.user')

@section('title', 'Create Vehicle')

@section('content')
    <div x-data="{
            formData: {
                ownership: 'Purchased',
                status: 'Active',
                vehicle_id: '{{ $generatedId }}',
                make: '',
                model: '',
                year: '',
                acquisition_date: '',
                license_plate: '',
                license_plate_country: '',
                license_plate_state: '',
                vin_number: '',
                color: '',
                comments: ''
            },
            countries: @js($countries),
            states: [],
            countrySearch: '',
            stateSearch: '',
            countryOpen: false,
            stateOpen: false,
            get countryName() {
                const c = this.countries.find(c => c.id == this.formData.license_plate_country);
                return c ? c.name : 'Choose One';
            },
            get stateName() {
                const s = this.states.find(s => s.id == this.formData.license_plate_state);
                return s ? s.name : 'Select a country first';
            },
            async fetchStates() {
                if (!this.formData.license_plate_country) {
                    this.states = [];
                    return;
                }
                const response = await fetch(`/api/countries/${this.formData.license_plate_country}/states`);
                this.states = await response.json();
            }
        }" x-init="$watch('formData.license_plate_country', () => { fetchStates(); formData.license_plate_state = ''; })"
        class="space-y-6">

        <!-- Breadcrumb & Header -->
        <div
            class="flex flex-col md:flex-row md:items-center justify-between gap-4 bg-slate-900 p-8 rounded-[2rem] text-white shadow-2xl">
            <div>
                <div class="flex items-center gap-2 text-[10px] font-bold uppercase tracking-widest text-blue-400 mb-1">
                    <a href="{{ route('vehicles.index') }}" class="hover:text-white transition-colors">Vehicles</a>
                    <svg class="w-3 h-3 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                    <span class="text-white">New Vehicle</span>
                </div>
                <h1 class="text-3xl font-black tracking-tight">Create Vehicle</h1>
                <p class="text-xs text-slate-400 font-medium mt-1">Add a new vehicle to your fleet.</p>
            </div>

            <a href="{{ route('vehicles.index') }}"
                class="flex items-center gap-2 px-6 py-2.5 bg-white/10 hover:bg-white/20 text-white text-xs font-bold rounded-2xl backdrop-blur-md transition-all border border-white/10">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                    </path>
                </svg>
                Back to List
            </a>
        </div>

        <!-- Main Form -->
        <form action="{{ route('vehicles.store') }}" method="POST" enctype="multipart/form-data" class="space-y-6 pb-20">
            @csrf

            <div class="bg-white border border-slate-100 rounded-[2rem] shadow-2xl overflow-hidden p-10 space-y-8">
                <div class="flex items-center gap-2 mb-4">
                    <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                    <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest">Vehicle Information</h2>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-8 text-sm">
                    <!-- Ownership -->
                    <div>
                        <label
                            class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Ownership<span
                                class="text-red-500 ml-1">*</span></label>
                        <select name="ownership" x-model="formData.ownership" required
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all cursor-pointer">
                            <option value="Purchased">Purchased</option>
                            <option value="Leased">Leased</option>
                            <option value="Rented">Rented</option>
                        </select>
                    </div>

                    <!-- Status -->
                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Status<span
                                class="text-red-500 ml-1">*</span></label>
                        <select name="status" x-model="formData.status" required
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all cursor-pointer">
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>
                            <option value="Maintenance">Maintenance</option>
                            <option value="Sold">Sold</option>
                        </select>
                    </div>

                    <!-- Vehicle ID -->
                    <div>
                        <label
                            class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block font-mono">Vehicle
                            ID</label>
                        <input type="text" name="vehicle_id" value="{{ $generatedId }}" readonly
                            class="w-full px-4 py-3 bg-slate-100 border border-slate-200 rounded-xl text-slate-500 cursor-not-allowed font-mono text-xs">
                    </div>

                    <!-- Make -->
                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Make</label>
                        <input type="text" name="make" x-model="formData.make" placeholder="e.g., Ford, Toyota"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                    </div>

                    <!-- Model -->
                    <div>
                        <label
                            class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Model</label>
                        <input type="text" name="model" x-model="formData.model" placeholder="e.g., F-150, Camry"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                    </div>

                    <!-- Year -->
                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Year</label>
                        <input type="text" name="year" x-model="formData.year" placeholder="e.g., 2024" maxlength="4"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                    </div>

                    <!-- Acquisition Date -->
                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Acquisition
                            /
                            Lease Date</label>
                        <input type="date" name="acquisition_date" x-model="formData.acquisition_date"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                    </div>

                    <!-- License Plate -->
                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">License
                            Plate</label>
                        <input type="text" name="license_plate" x-model="formData.license_plate"
                            placeholder="Enter license plate"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                    </div>

                    <!-- License Plate Country -->
                    <div class="relative" @click.away="countryOpen = false">
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">License
                            Plate
                            Country</label>
                        <input type="hidden" name="license_plate_country" x-model="formData.license_plate_country">
                        <button type="button" @click="countryOpen = !countryOpen"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all cursor-pointer flex justify-between items-center h-[46px]">
                            <span x-text="countryName"
                                :class="formData.license_plate_country ? 'text-slate-900 font-bold' : 'text-slate-400'"></span>
                            <svg class="w-4 h-4 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7">
                                </path>
                            </svg>
                        </button>

                        <div x-show="countryOpen" x-cloak
                            class="absolute z-50 w-full mt-2 bg-white border border-slate-100 rounded-2xl shadow-2xl max-h-60 overflow-hidden flex flex-col">
                            <div class="p-3 border-b border-slate-50">
                                <input type="text" x-model="countrySearch" placeholder="Search country..."
                                    class="w-full px-3 py-2 bg-slate-50 border border-slate-100 rounded-lg text-xs focus:outline-none focus:ring-2 focus:ring-blue-500/20">
                            </div>
                            <ul class="overflow-y-auto py-2">
                                <template
                                    x-for="country in countries.filter(c => c.name.toLowerCase().includes(countrySearch.toLowerCase()))"
                                    :key="country.id">
                                    <li @click="formData.license_plate_country = country.id; countryOpen = false; countrySearch = ''"
                                        class="px-4 py-2.5 hover:bg-blue-50 hover:text-blue-600 text-xs font-bold cursor-pointer transition-colors"
                                        x-text="country.name"></li>
                                </template>
                            </ul>
                        </div>
                    </div>

                    <!-- License Plate State -->
                    <div class="relative" @click.away="stateOpen = false">
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">License
                            Plate
                            State</label>
                        <input type="hidden" name="license_plate_state" x-model="formData.license_plate_state">
                        <button type="button" @click="if(formData.license_plate_country) stateOpen = !stateOpen"
                            :disabled="!formData.license_plate_country"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all cursor-pointer flex justify-between items-center h-[46px] disabled:opacity-50 disabled:bg-slate-100 disabled:cursor-not-allowed">
                            <span x-text="stateName"
                                :class="formData.license_plate_state ? 'text-slate-900 font-bold' : 'text-slate-400'"></span>
                            <svg class="w-4 h-4 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7">
                                </path>
                            </svg>
                        </button>

                        <div x-show="stateOpen" x-cloak
                            class="absolute z-50 w-full mt-2 bg-white border border-slate-100 rounded-2xl shadow-2xl max-h-60 overflow-hidden flex flex-col">
                            <div class="p-3 border-b border-slate-50">
                                <input type="text" x-model="stateSearch" placeholder="Search state..."
                                    class="w-full px-3 py-2 bg-slate-50 border border-slate-100 rounded-lg text-xs focus:outline-none focus:ring-2 focus:ring-blue-500/20">
                            </div>
                            <ul class="overflow-y-auto py-2">
                                <template
                                    x-for="state in states.filter(s => s.name.toLowerCase().includes(stateSearch.toLowerCase()))"
                                    :key="state.id">
                                    <li @click="formData.license_plate_state = state.id; stateOpen = false; stateSearch = ''"
                                        class="px-4 py-2.5 hover:bg-blue-50 hover:text-blue-600 text-xs font-bold cursor-pointer transition-colors"
                                        x-text="state.name"></li>
                                </template>
                            </ul>
                        </div>
                    </div>

                    <!-- VIN Number -->
                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">VIN
                            Number</label>
                        <input type="text" name="vin_number" x-model="formData.vin_number" placeholder="Enter VIN number"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                    </div>

                    <!-- Color -->
                    <div>
                        <label
                            class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Color</label>
                        <input type="text" name="color" x-model="formData.color" placeholder="e.g., Black, White"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                    </div>

                    <!-- Comments / Notes -->
                    <div class="md:col-span-2">
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Comments /
                            Notes</label>
                        <textarea name="comments" x-model="formData.comments" rows="4" placeholder="Additional notes..."
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all"></textarea>
                    </div>

                    <!-- Vehicle Images -->
                    <div class="md:col-span-2">
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Vehicle
                            Images</label>
                        <input type="file" name="images[]" multiple accept="image/*"
                            class="w-full px-4 py-2.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all file:mr-4 file:py-1 file:px-3 file:rounded-full file:border-0 file:text-[10px] file:font-bold file:bg-blue-600 file:text-white hover:file:bg-blue-700">
                        <p class="text-[10px] text-gray-400 mt-1">You can upload multiple images (Max 10MB each)</p>
                    </div>
                </div>
            </div>

            <!-- Form Controls -->
            <div
                class="flex items-center justify-between bg-slate-900 rounded-[1.5rem] p-4 sticky bottom-8 shadow-2xl backdrop-blur-md border border-white/10">
                <div class="flex items-center gap-3">
                    <a href="{{ route('vehicles.index') }}"
                        class="px-6 py-2.5 rounded-xl text-slate-400 font-bold text-[10px] uppercase tracking-widest hover:text-white transition-all">Cancel</a>
                </div>
                <div class="flex items-center gap-3">
                    <button type="submit"
                        class="px-10 py-2.5 bg-emerald-600 text-white rounded-xl font-bold text-[10px] uppercase tracking-widest hover:bg-emerald-700 transition-all shadow-lg shadow-emerald-500/20">Create
                        Vehicle</button>
                </div>
            </div>
        </form>
    </div>
@endsection