@extends('layouts.user')

@section('title', 'Uniforms Inventory')

@section('content')
    <div class="p-6">
        <div class="flex flex-col gap-4 mb-6">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Uniform Inventory</h1>
                    <p class="text-gray-500">Available uniforms and current stock levels.</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr
                            class="bg-slate-50 border-b border-gray-100 text-xs uppercase tracking-wider text-gray-400 font-bold">
                            <th class="px-6 py-4">Uniform Type</th>
                            <th class="px-6 py-4">Code</th>
                            <th class="px-6 py-4">Variant (Size / Color)</th>
                            <th class="px-6 py-4 text-right">Available Stock</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-50">
                        @forelse($inventory as $item)
                            <tr class="hover:bg-gray-50 transition-colors group">
                                <td class="px-6 py-4">
                                    <div class="font-bold text-gray-900">{{ $item->uniform->name }}</div>
                                    @if($item->uniform->description)
                                        <div class="text-xs text-gray-400 mt-1">{{ Str::limit($item->uniform->description, 50) }}
                                        </div>
                                    @endif
                                </td>
                                <td class="px-6 py-4">
                                    @if($item->uniform->code)
                                        <span
                                            class="bg-slate-100 text-slate-600 px-2 py-1 rounded text-xs font-mono font-bold">{{ $item->uniform->code }}</span>
                                    @else
                                        <span class="text-gray-300 text-xs">-</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm font-medium text-gray-700 flex items-center gap-2">
                                        @if($item->color)
                                            <span class="w-3 h-3 rounded-full border border-gray-200 shadow-sm"
                                                style="background-color: {{ strtolower($item->color) }}"></span>
                                            {{ $item->color }}
                                        @endif
                                        @if($item->size && $item->color)
                                            <span class="text-gray-300">/</span>
                                        @endif
                                        @if($item->size)
                                            <span
                                                class="bg-gray-100 text-gray-700 px-2 py-0.5 rounded text-xs border border-gray-200">{{ $item->size }}</span>
                                        @endif

                                        @if(!$item->size && !$item->color)
                                            <span class="text-gray-400 italic">Standard</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <span
                                        class="font-bold {{ $item->stock_quantity == 0 ? 'text-red-500' : 'text-slate-900' }}">
                                        {{ $item->stock_quantity }}
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="px-6 py-12 text-center text-slate-500">
                                    No active uniform inventory found.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection