@extends('layouts.user')

@section('title', 'Create Site')

@section('content')
    <div x-data="{
                                    activeTab: 'company',
                                    formData: {
                                        account_type: '',
                                        name: '',
                                        rate: '',
                                        address_line_1: '',
                                        country_id: '',
                                        state_id: '',
                                        city: '',
                                        zip_code: '',
                                        latitude: '',
                                        longitude: '',
                                        tags: '',
                                        website: '',
                                        contact_first_name: '',
                                        contact_last_name: '',
                                        contact_email: '',
                                        contact_phone_main: '',
                                        contact_phone_other: '',
                                        fax: '',
                                        account_representative: '',
                                        sales_representative: '',
                                        language: ''
                                    },
                                    states: [],
                                    countries: @js($countries),
                                    countrySearch: '',
                                    stateSearch: '',
                                    countryOpen: false,
                                    stateOpen: false,
                                    get countryName() {
                                        const c = this.countries.find(c => c.id == this.formData.country_id);
                                        return c ? c.name : 'Select Country';
                                    },
                                    get stateName() {
                                        const s = this.states.find(s => s.id == this.formData.state_id);
                                        return s ? s.name : 'Select State';
                                    },
                                    isComplete(field) {
                                        return !!this.formData[field];
                                    },
                                    async fetchStates() {
                                        if (!this.formData.country_id) {
                                            this.states = [];
                                            return;
                                        }
                                        const response = await fetch(`/api/countries/${this.formData.country_id}/states`);
                                        this.states = await response.json();
                                    },
                                    errors: {},
                                    async validateStep(step) {
                                        this.errors = {}; 
                                        try {
                                            const response = await fetch('{{ route('sites.validate') }}', {
                                                method: 'POST',
                                                headers: {
                                                    'Content-Type': 'application/json',
                                                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                                                },
                                                body: JSON.stringify({
                                                    ...this.formData,
                                                    step: step
                                                })
                                            });
                                            const data = await response.json();

                                            if (!response.ok) {
                                                if (data.errors) {
                                                    this.errors = data.errors;
                                                    return false;
                                                }
                                            }
                                            return true;
                                        } catch (e) {
                                            console.error('Validation error', e);
                                            return false;
                                        }
                                    }
                                }" x-init="$watch('formData.country_id', () => { fetchStates(); formData.state_id = ''; })"
        class="space-y-6">

        <!-- Breadcrumb & Header -->
        <div
            class="flex flex-col md:flex-row md:items-center justify-between gap-4 bg-slate-900 p-8 rounded-[2rem] text-white shadow-2xl">
            <div>
                <div class="flex items-center gap-2 text-[10px] font-bold uppercase tracking-widest text-blue-400 mb-1">
                    <a href="{{ route('sites.index') }}" class="hover:text-white transition-colors">Sites</a>
                    <svg class="w-3 h-3 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                    <span class="text-white">New Site</span>
                </div>
                <h1 class="text-3xl font-black tracking-tight">Create Site</h1>
                <p class="text-xs text-slate-400 font-medium mt-1">Configure your new service location and contact details.
                </p>
            </div>

            @can('view sites')
                <a href="{{ route('sites.index') }}"
                    class="flex items-center gap-2 px-6 py-2.5 bg-white/10 hover:bg-white/20 text-white text-xs font-bold rounded-2xl backdrop-blur-md transition-all border border-white/10">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                        </path>
                    </svg>
                    Back to List
                </a>
            @endcan
        </div>

        <!-- Top Navigation Tabs -->
        <div class="mb-6 bg-[#1e293b] rounded-[2rem] shadow-lg border border-slate-700 p-2">
            <nav class="flex flex-wrap md:flex-nowrap gap-2">
                <button @click="activeTab = 'company'"
                    :class="activeTab === 'company' ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                    class="flex-1 px-4 py-3 text-sm font-bold rounded-2xl transition-all flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                        </path>
                    </svg>
                    <span class="whitespace-nowrap">Company Information</span>
                </button>
                <button @click="activeTab = 'address'"
                    :class="activeTab === 'address' ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                    class="flex-1 px-4 py-3 text-sm font-bold rounded-2xl transition-all flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                        </path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z">
                        </path>
                    </svg>
                    <span class="whitespace-nowrap">Address Details</span>
                </button>
                <button @click="activeTab = 'contact'"
                    :class="activeTab === 'contact' ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                    class="flex-1 px-4 py-3 text-sm font-bold rounded-2xl transition-all flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 11c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z">
                        </path>
                    </svg>
                    <span class="whitespace-nowrap">Contact Person</span>
                </button>
            </nav>
        </div>

        <div class="flex flex-col lg:flex-row gap-8">
            <!-- Sidebar Navigation -->
            <div class="w-full lg:w-72 flex-shrink-0 space-y-6">
                <!-- Required Fields -->
                <div class="bg-white border border-gray-200 rounded-[2rem] shadow-lg overflow-hidden sticky top-32">
                    <div class="px-6 py-5 bg-gray-50 border-b border-gray-200">
                        <span class="text-[11px] font-bold uppercase text-gray-400 tracking-widest leading-none">Required
                            Fields</span>
                    </div>
                    <div class="p-6 space-y-3">
                        <template x-for="(label, field) in {
                                                        account_type: 'Account Type',
                                                        name: 'Site Name',
                                                        rate: 'Site Rate',
                                                        address_line_1: 'Address 1',
                                                        latitude: 'Latitude',
                                                        longitude: 'Longitude'
                                                    }">
                            <div class="flex items-center justify-between text-[11px] transition-all duration-200 px-2"
                                :class="isComplete(field) ? 'text-emerald-600 font-bold' : 'text-slate-500'">
                                <span x-text="label"></span>
                                <div x-show="isComplete(field)"
                                    class="w-4 h-4 rounded-full bg-emerald-500 flex items-center justify-center text-white shadow-sm">
                                    <svg class="w-2.5 h-2.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                            d="M5 13l4 4L19 7" />
                                    </svg>
                                </div>
                                <span x-show="!isComplete(field)"
                                    class="w-3 h-3 block rounded-full border border-gray-300 bg-gray-100"></span>
                            </div>
                        </template>
                    </div>
                </div>
            </div>

            <!-- Main Form Area -->
            <div class="flex-1">
                <form action="{{ route('sites.store') }}" method="POST" enctype="multipart/form-data"
                    class="space-y-6 pb-20">
                    @csrf

                    <!-- Company Information -->
                    <div x-show="activeTab === 'company'"
                        class="bg-white border border-slate-100 rounded-[2rem] shadow-2xl overflow-hidden p-10 space-y-8 min-h-[600px] transition-all">
                        <div class="flex items-center gap-2 mb-4">
                            <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                            <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest">Company Information</h2>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 text-sm">
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Account
                                    Type<span class="text-red-500 ml-1">*</span></label>
                                <select name="account_type" x-model="formData.account_type" required
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all cursor-pointer">
                                    <option value="">Select Account Type</option>
                                    <option value="Regular Client">Regular Client</option>
                                    <option value="Multi-Site client">Multi-Site client</option>
                                </select>
                                <div class="text-xs text-red-500 mt-1 font-bold"
                                    x-text="errors.account_type && errors.account_type[0]" x-show="errors.account_type">
                                </div>
                            </div>
                            <div>
                                <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Site
                                    Name<span class="text-red-500 ml-1">*</span></label>
                                <input type="text" name="name" x-model="formData.name" required
                                    placeholder="Enter site name"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                                <div class="text-xs text-red-500 mt-1 font-bold" x-text="errors.name && errors.name[0]"
                                    x-show="errors.name"></div>
                            </div>
                            <div>
                                <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Site
                                    Rate<span class="text-red-500 ml-1">*</span></label>
                                <div class="relative group">
                                    <span class="absolute left-4 top-1/2 -translate-y-1/2 text-slate-400 font-bold">$</span>
                                    <input type="number" step="0.01" name="rate" x-model="formData.rate" required
                                        placeholder="0.00"
                                        class="w-full pl-8 pr-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                                </div>
                                <div class="text-xs text-red-500 mt-1 font-bold" x-text="errors.rate && errors.rate[0]"
                                    x-show="errors.rate"></div>
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block font-mono">Site
                                    ID</label>
                                <input type="text" name="site_id" value="{{ $generatedId }}" readonly
                                    class="w-full px-4 py-3 bg-slate-100 border border-slate-200 rounded-xl text-slate-500 cursor-not-allowed font-mono text-xs">
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Language</label>
                                <select name="language" x-model="formData.language"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all cursor-pointer">
                                    <option value="">Select Language</option>
                                    <option value="English">English</option>
                                    <option value="French">French</option>
                                    <option value="Spanish">Spanish</option>
                                </select>
                            </div>
                            <div>
                                <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Site
                                    Logo</label>
                                <div class="relative group">
                                    <input type="file" name="logo" accept="image/*"
                                        class="w-full px-4 py-2.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all file:mr-4 file:py-1 file:px-3 file:rounded-full file:border-0 file:text-[10px] file:font-bold file:bg-blue-600 file:text-white hover:file:bg-blue-700">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Address Information -->
                    <div x-show="activeTab === 'address'"
                        class="bg-white border border-slate-100 rounded-[2rem] shadow-2xl overflow-hidden p-10 space-y-8 min-h-[600px] transition-all">
                        <div class="flex items-center gap-2 mb-4">
                            <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                            <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest">Address Information</h2>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 text-sm">
                            <div class="md:col-span-2">
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Address
                                    1<span class="text-red-500 ml-1">*</span></label>
                                <input type="text" name="address_line_1" x-model="formData.address_line_1" required
                                    placeholder="Street address or P.O. box"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                                <div class="text-xs text-red-500 mt-1 font-bold"
                                    x-text="errors.address_line_1 && errors.address_line_1[0]"
                                    x-show="errors.address_line_1"></div>
                            </div>
                            <div class="md:col-span-2">
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Address
                                    2</label>
                                <input type="text" name="address_line_2"
                                    placeholder="Suite, apartment, unit, etc. (optional)"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            </div>
                            <div class="relative" @click.away="countryOpen = false">
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Country</label>
                                <input type="hidden" name="country_id" x-model="formData.country_id">
                                <button type="button" @click="countryOpen = !countryOpen"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all cursor-pointer flex justify-between items-center h-[46px]">
                                    <span x-text="countryName"
                                        :class="formData.country_id ? 'text-slate-900 font-bold' : 'text-slate-400'"></span>
                                    <svg class="w-4 h-4 text-slate-400" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>

                                <div x-show="countryOpen" x-cloak
                                    class="absolute z-50 w-full mt-2 bg-white border border-slate-100 rounded-2xl shadow-2xl max-h-60 overflow-hidden flex flex-col">
                                    <div class="p-3 border-b border-slate-50">
                                        <input type="text" x-model="countrySearch" placeholder="Search country..."
                                            class="w-full px-3 py-2 bg-slate-50 border border-slate-100 rounded-lg text-xs focus:outline-none focus:ring-2 focus:ring-blue-500/20">
                                    </div>
                                    <ul class="overflow-y-auto py-2">
                                        <template
                                            x-for="country in countries.filter(c => c.name.toLowerCase().includes(countrySearch.toLowerCase()))"
                                            :key="country.id">
                                            <li @click="formData.country_id = country.id; countryOpen = false; countrySearch = ''"
                                                class="px-4 py-2.5 hover:bg-blue-50 hover:text-blue-600 text-xs font-bold cursor-pointer transition-colors"
                                                x-text="country.name"></li>
                                        </template>
                                    </ul>
                                </div>
                                <div class="text-xs text-red-500 mt-1 font-bold"
                                    x-text="errors.country_id && errors.country_id[0]" x-show="errors.country_id"></div>
                            </div>
                            <div class="relative" @click.away="stateOpen = false">
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">State</label>
                                <input type="hidden" name="state_id" x-model="formData.state_id">
                                <button type="button" @click="if(formData.country_id) stateOpen = !stateOpen"
                                    :disabled="!formData.country_id"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all cursor-pointer flex justify-between items-center h-[46px] disabled:opacity-50 disabled:bg-slate-100 disabled:cursor-not-allowed">
                                    <span x-text="stateName"
                                        :class="formData.state_id ? 'text-slate-900 font-bold' : 'text-slate-400'"></span>
                                    <svg class="w-4 h-4 text-slate-400" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>

                                <div x-show="stateOpen" x-cloak
                                    class="absolute z-50 w-full mt-2 bg-white border border-slate-100 rounded-2xl shadow-2xl max-h-60 overflow-hidden flex flex-col">
                                    <div class="p-3 border-b border-slate-50">
                                        <input type="text" x-model="stateSearch" placeholder="Search state..."
                                            class="w-full px-3 py-2 bg-slate-50 border border-slate-100 rounded-lg text-xs focus:outline-none focus:ring-2 focus:ring-blue-500/20">
                                    </div>
                                    <ul class="overflow-y-auto py-2">
                                        <template
                                            x-for="state in states.filter(s => s.name.toLowerCase().includes(stateSearch.toLowerCase()))"
                                            :key="state.id">
                                            <li @click="formData.state_id = state.id; stateOpen = false; stateSearch = ''"
                                                class="px-4 py-2.5 hover:bg-blue-50 hover:text-blue-600 text-xs font-bold cursor-pointer transition-colors"
                                                x-text="state.name"></li>
                                        </template>
                                    </ul>
                                </div>
                                <div class="text-xs text-red-500 mt-1 font-bold"
                                    x-text="errors.state_id && errors.state_id[0]" x-show="errors.state_id"></div>
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">City</label>
                                <input type="text" name="city" x-model="formData.city" placeholder="Enter city"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                                <div class="text-xs text-red-500 mt-1 font-bold" x-text="errors.city && errors.city[0]"
                                    x-show="errors.city"></div>
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Zipcode</label>
                                <input type="text" name="zip_code" x-model="formData.zip_code"
                                    placeholder="Enter postal code"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                                <div class="text-xs text-red-500 mt-1 font-bold"
                                    x-text="errors.zip_code && errors.zip_code[0]" x-show="errors.zip_code"></div>
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Latitude<span
                                        class="text-red-500 ml-1">*</span></label>
                                <input type="text" name="latitude" x-model="formData.latitude" required
                                    placeholder="e.g., 40.7128"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                                <div class="text-xs text-red-500 mt-1 font-bold"
                                    x-text="errors.latitude && errors.latitude[0]" x-show="errors.latitude"></div>
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Longitude<span
                                        class="text-red-500 ml-1">*</span></label>
                                <input type="text" name="longitude" x-model="formData.longitude" required
                                    placeholder="e.g., -74.0060"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                                <div class="text-xs text-red-500 mt-1 font-bold"
                                    x-text="errors.longitude && errors.longitude[0]" x-show="errors.longitude"></div>
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Tags</label>
                                <input type="text" name="tags" x-model="formData.tags"
                                    placeholder="Enter tags (comma separated)"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Website</label>
                                <input type="url" name="website" x-model="formData.website"
                                    placeholder="https://www.example.com"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            </div>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div x-show="activeTab === 'contact'"
                        class="bg-white border border-slate-100 rounded-[2rem] shadow-2xl overflow-hidden p-10 space-y-8 min-h-[600px] transition-all">
                        <div class="flex items-center gap-2 mb-4">
                            <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                            <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest">Contact Information</h2>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 text-sm">
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">First
                                    Name</label>
                                <input type="text" name="contact_first_name" x-model="formData.contact_first_name"
                                    placeholder="Contact First Name"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            </div>
                            <div>
                                <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Last
                                    Name</label>
                                <input type="text" name="contact_last_name" x-model="formData.contact_last_name"
                                    placeholder="Contact Last Name"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Email
                                    Address</label>
                                <input type="email" name="contact_email" x-model="formData.contact_email"
                                    placeholder="example@domain.com"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            </div>
                            <div>
                                <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Main
                                    Phone</label>
                                <input type="text" name="contact_phone_main" x-model="formData.contact_phone_main"
                                    placeholder="Primary phone number"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            </div>
                            <div>
                                <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Alt
                                    Phone</label>
                                <input type="text" name="contact_phone_other" x-model="formData.contact_phone_other"
                                    placeholder="Secondary phone number"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block font-mono">FAX</label>
                                <input type="text" name="fax" x-model="formData.fax" placeholder="Fax Number"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Account
                                    Rep</label>
                                <input type="text" name="account_representative" x-model="formData.account_representative"
                                    placeholder="Account Representative"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            </div>
                            <div>
                                <label
                                    class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Sales
                                    Rep</label>
                                <input type="text" name="sales_representative" x-model="formData.sales_representative"
                                    placeholder="Sales Representative"
                                    class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all">
                            </div>
                        </div>
                    </div>

                    <!-- Form Controls -->
                    <div
                        class="flex items-center justify-between bg-slate-900 rounded-[1.5rem] p-4 sticky bottom-8 shadow-2xl backdrop-blur-md border border-white/10">
                        <div class="flex items-center gap-3">
                            <button type="button" @click="activeTab = 'company'" x-show="activeTab === 'address'"
                                class="px-6 py-2.5 rounded-xl border border-white/20 text-white font-bold text-[10px] uppercase tracking-widest hover:bg-white/10 transition-all">Previous</button>
                            <button type="button" @click="activeTab = 'address'" x-show="activeTab === 'contact'"
                                class="px-6 py-2.5 rounded-xl border border-white/20 text-white font-bold text-[10px] uppercase tracking-widest hover:bg-white/10 transition-all">Previous</button>
                        </div>
                        <div class="flex items-center gap-3">
                            <a href="{{ route('sites.index') }}"
                                class="px-6 py-2.5 rounded-xl text-slate-400 font-bold text-[10px] uppercase tracking-widest hover:text-white transition-all">Cancel</a>

                            <button type="button" @click="if(await validateStep('company')) activeTab = 'address'"
                                x-show="activeTab === 'company'"
                                class="px-8 py-2.5 bg-blue-600 text-white rounded-xl font-bold text-[10px] uppercase tracking-widest hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/20">Next
                                Step</button>
                            <button type="button" @click="if(await validateStep('address')) activeTab = 'contact'"
                                x-show="activeTab === 'address'"
                                class="px-8 py-2.5 bg-blue-600 text-white rounded-xl font-bold text-[10px] uppercase tracking-widest hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/20">Next
                                Step</button>

                            <button type="submit" x-show="activeTab === 'contact'"
                                class="px-10 py-2.5 bg-emerald-600 text-white rounded-xl font-bold text-[10px] uppercase tracking-widest hover:bg-emerald-700 transition-all shadow-lg shadow-emerald-500/20">Create
                                Site</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection