<!DOCTYPE html>
<html>

<head>
    <title>Comprehensive Job Log - #{{ $schedule->duty_number }}</title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            color: #1e293b;
            line-height: 1.5;
            padding: 40px;
        }

        .header {
            border-bottom: 4px solid #dc2626;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .header h1 {
            margin: 0;
            color: #0f172a;
            text-transform: uppercase;
            font-size: 24px;
        }

        .header p {
            margin: 5px 0 0;
            color: #64748b;
            font-weight: bold;
            font-size: 12px;
            text-transform: uppercase;
        }

        .section {
            margin-bottom: 30px;
        }

        .section-title {
            font-size: 14px;
            font-weight: 800;
            color: #dc2626;
            text-transform: uppercase;
            margin-bottom: 15px;
            background: #fee2e2;
            padding: 5px 10px;
            border-radius: 4px;
        }

        .grid {
            width: 100%;
            border-collapse: collapse;
        }

        .grid td {
            padding: 10px;
            border: 1px solid #f1f5f9;
            font-size: 12px;
        }

        .label {
            font-weight: bold;
            color: #64748b;
            text-transform: uppercase;
            font-size: 10px;
            width: 30%;
        }

        .incident-card {
            margin-bottom: 15px;
            padding: 15px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
        }

        .image-strip {
            display: block;
            margin-top: 10px;
        }

        .image-item {
            display: inline-block;
            width: 30%;
            margin-right: 3%;
            margin-bottom: 10px;
        }

        .image-item img {
            width: 100%;
            border-radius: 4px;
            border: 1px solid #e2e8f0;
        }

        .footer {
            margin-top: 50px;
            border-top: 1px solid #e2e8f0;
            padding-top: 20px;
            font-size: 10px;
            color: #94a3b8;
            text-align: center;
        }

        .employee-block {
            margin-bottom: 40px;
            border-bottom: 2px dashed #e2e8f0;
            padding-bottom: 20px;
        }

        .employee-name {
            font-size: 16px;
            font-weight: bold;
            color: #1e293b;
            margin-bottom: 15px;
            padding-left: 10px;
            border-left: 4px solid #3b82f6;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Comprehensive Job Log</h1>
        <p>Deployment #{{ $schedule->duty_number }} | Site: {{ $schedule->site->name }}</p>
    </div>

    @foreach($schedule->employees as $employee)
        @php
            $pivot = $employee->pivot;
            // Adjust for multiple checkin logic if needed, but existing is pivot based.
        @endphp
        <div class="employee-block">
            <div class="employee-name">
                Operative: {{ $employee->first_name }} {{ $employee->last_name }} (#{{ $employee->employee_id }})
            </div>

            <div class="section">
                <div class="section-title">Temporal & Geospatial Logs</div>
                <table class="grid">
                <tr>
                    <td class="label">Scheduled Start</td>
                    <td>{{ $schedule->from_datetime->format('Y-m-d H:i') }}</td>
                </tr>
                <tr>
                    <td class="label">Scheduled End</td>
                    <td>{{ $schedule->to_datetime->format('Y-m-d H:i') }}</td>
                </tr>
                <tr>
                    <td class="label">Actual Infiltration</td>
                    <td>
                        {{ $pivot->actual_start_at ? \Carbon\Carbon::parse($pivot->actual_start_at)->format('Y-m-d H:i') : 'N/A' }}
                        <span style="color: #64748b; font-size: 10px; margin-left: 5px;">
                            @if($pivot->start_lat)
                                at [{{ $pivot->start_lat }}, {{ $pivot->start_lng }}]
                            @elseif($pivot->is_addon)
                                (Manual Entry)
                            @endif
                        </span>
                    </td>
                </tr>
                <tr>
                    <td class="label">Actual Extraction</td>
                    <td>
                        {{ $pivot->actual_end_at ? \Carbon\Carbon::parse($pivot->actual_end_at)->format('Y-m-d H:i') : 'N/A' }}
                        <span style="color: #64748b; font-size: 10px; margin-left: 5px;">
                            @if($pivot->end_lat)
                                at [{{ $pivot->end_lat }}, {{ $pivot->end_lng }}]
                            @elseif($pivot->is_addon)
                                (Manual Entry)
                            @endif
                        </span>
                    </td>
                </tr>
            </table>
            </div>

            <div class="section">
                <div class="section-title">Field Intelligence & Tactical Incidents</div>
                @php
                    $incidents = $schedule->incidents->where('employee_id', $employee->id);
                @endphp
                @forelse($incidents as $incident)
                    <div class="incident-card">
                        <div style="font-weight: 800; color: #0f172a; margin-bottom: 5px;">{{ $incident->subject }}</div>
                        <div style="font-size: 12px; color: #475569;">{{ $incident->description }}</div>

                        @if(!empty($incident->images) && is_array($incident->images))
                            <div class="image-strip" style="margin-top: 10px;">
                                @foreach($incident->images as $img)
                                    @php $isWebP = \Illuminate\Support\Str::endsWith(strtolower($img), '.webp'); @endphp
                                    <div class="image-item" style="display: inline-block; width: 100px; margin-right: 5px; vertical-align: top;">
                                        @if($isPdf && $isWebP)
                                            <div style="width: 100%; height: 100px; background: #f1f5f9; border: 1px solid #cbd5e1; border-radius: 4px; display: flex; align-items: center; justify-content: center; text-align: center; font-size: 8px; color: #64748b; padding: 5px;">
                                                [WebP Not Supported]
                                            </div>
                                        @else
                                            <img src="{{ $isPdf ? public_path('storage/' . $img) : asset('storage/' . $img) }}"
                                                style="width: 100%; border-radius: 4px; border: 1px solid #cbd5e1;">
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        <div style="font-size: 10px; color: #94a3b8; margin-top: 8px;">Filed at:
                            {{ $incident->created_at->format('Y-m-d H:i') }}</div>
                    </div>
                @empty
                    <p style="font-size: 12px; color: #64748b;">No tactical incidents reported by this operative.</p>
                @endforelse
            </div>

            <div class="section">
                <div class="section-title">Consolidated Evidence Gallery</div>
                @php 
                                $inImages = json_decode($pivot->checkin_images, true) ?? [];
                    if ($pivot->start_evidence_path) {
                        array_unshift($inImages, $pivot->start_evidence_path);
                    }

                    $outImages = json_decode($pivot->checkout_images, true) ?? [];
                    if ($pivot->end_evidence_path) {
                        array_unshift($outImages, $pivot->end_evidence_path);
                    }
                @endphp

                @if(count($inImages) > 0)
                    <div style="font-size: 10px; font-weight: bold; color: #64748b; margin-bottom: 5px;">CHECK-IN IMAGES</div>
                    <div class="image-strip">
                        @foreach($inImages as $img)
                             @php $isWebP = \Illuminate\Support\Str::endsWith(strtolower($img), '.webp'); @endphp
                            <div class="image-item">
                                @if($isPdf && $isWebP)
                                    <div style="width: 100%; height: 100px; background: #f1f5f9; border: 1px solid #cbd5e1; border-radius: 4px; display: flex; align-items: center; justify-content: center; text-align: center; font-size: 8px; color: #64748b; padding: 5px;">[WebP Not Supported]</div>
                                @else
                                    <img src="{{ $isPdf ? public_path('storage/' . $img) : asset('storage/' . $img) }}">
                                @endif
                            </div>
                        @endforeach
                    </div>
                @endif

                @if(count($outImages) > 0)
                    <div style="font-size: 10px; font-weight: bold; color: #64748b; margin-top: 15px; margin-bottom: 5px;">CHECKOUT IMAGES</div>
                    <div class="image-strip">
                        @foreach($outImages as $img)
                            @php $isWebP = \Illuminate\Support\Str::endsWith(strtolower($img), '.webp'); @endphp
                            <div class="image-item">
                                @if($isPdf && $isWebP)
                                    <div style="width: 100%; height: 100px; background: #f1f5f9; border: 1px solid #cbd5e1; border-radius: 4px; display: flex; align-items: center; justify-content: center; text-align: center; font-size: 8px; color: #64748b; padding: 5px;">[WebP Not Supported]</div>
                                @else
                                    <img src="{{ $isPdf ? public_path('storage/' . $img) : asset('storage/' . $img) }}">
                                @endif
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    @endforeach

    <div class="footer">
        Generated by Crimson Vanguard Intelligence System | Full Job Cycle Manifest
    </div>
</body>

</html>
