<!DOCTYPE html>
<html>

<head>
    <title>Uniform Stock Levels</title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            font-size: 12px;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .header h1 {
            margin: 0;
            font-size: 24px;
            color: #1e293b;
        }

        .header p {
            margin: 5px 0 0;
            color: #64748b;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th {
            background-color: #f8fafc;
            color: #475569;
            font-weight: bold;
            text-align: left;
            padding: 12px 8px;
            border-bottom: 2px solid #e2e8f0;
            text-transform: uppercase;
            font-size: 10px;
        }

        td {
            padding: 10px 8px;
            border-bottom: 1px solid #f1f5f9;
        }

        .font-bold {
            font-weight: bold;
        }

        .text-right {
            text-align: right;
        }

        .text-red {
            color: #ef4444;
        }

        .badge {
            padding: 2px 6px;
            border-radius: 4px;
            font-size: 9px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .badge-red {
            background-color: #fee2e2;
            color: #b91c1c;
        }

        .footer {
            margin-top: 30px;
            text-align: right;
            font-size: 10px;
            color: #94a3b8;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Uniform Stock Levels</h1>
        <p>Generated on {{ now()->format('M d, Y H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Uniform Name</th>
                <th>Type</th>
                <th>Variant</th>
                <th class="text-right">Stock Quantity</th>
            </tr>
        </thead>
        <tbody>
            @foreach($inventory as $item)
                <tr>
                    <td class="font-bold">{{ $item->uniform->name }}</td>
                    <td style="color: #64748b;">{{ $item->uniform->code ?? '-' }}</td>
                    <td>
                        {{ $item->size ?? '' }}
                        @if($item->size && $item->color) / @endif
                        {{ $item->color ?? '' }}
                        @if(!$item->size && !$item->color) - @endif
                    </td>
                    <td class="text-right font-bold {{ $item->stock_quantity <= 5 ? 'text-red' : '' }}">
                        {{ $item->stock_quantity }}
                        @if($item->stock_quantity <= 5)
                            <span class="badge badge-red">Low Stock</span>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        Shift Matrix - Professional Security Management System
    </div>
</body>

</html>