@extends('layouts.user')

@section('title', 'Payout Summary')

@section('content')
    <div class="space-y-6">
        <!-- Filters -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="{{ route('reports.operational.payouts') }}" class="space-y-6">
                <div class="flex flex-col gap-6">
                    <div class="flex flex-col md:flex-row gap-6">
                        <!-- Date Range -->
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start
                                Date</label>
                            <input type="date" name="start_date" value="{{ request('start_date') }}"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                        </div>
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End
                                Date</label>
                            <input type="date" name="end_date" value="{{ request('end_date') }}"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                        </div>

                        <!-- Site Filter (Searchable) -->
                        <div class="w-full md:w-56" x-data="searchableSelect({
                                                            options: {{ $sites->map(fn($s) => ['value' => $s->id, 'label' => $s->name])->values()->toJson() }},
                                                            value: '{{ request('site_id') }}',
                                                            placeholder: 'All Sites'
                                                        })" @click.outside="open = false">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Site</label>
                            <div class="relative">
                                <div @click="open = !open"
                                    class="w-full bg-white border border-gray-300 rounded-lg px-3 py-2 text-sm shadow-sm cursor-pointer flex justify-between items-center h-[38px] hover:border-blue-400 transition-colors">
                                    <span x-text="selectedLabel" class="truncate text-gray-700"></span>
                                    <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </div>
                                <input type="hidden" name="site_id" :value="value">

                                <div x-show="open" x-transition.origin.top.left x-cloak
                                    class="absolute z-50 w-full bg-white border border-gray-300 rounded-lg mt-1 shadow-xl max-h-60 overflow-hidden flex flex-col">
                                    <div class="p-2 border-b border-gray-100 bg-gray-50/50">
                                        <input type="text" x-model="search" placeholder="Search site..."
                                            class="w-full text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5 px-2">
                                    </div>
                                    <ul class="overflow-y-auto flex-1 p-1">
                                        <li @click="select({value: '', label: 'All Sites'})"
                                            class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer transition-colors"
                                            :class="{'bg-blue-50 text-blue-700 font-medium': value === ''}">
                                            All Sites
                                        </li>
                                        <template x-for="option in filteredOptions" :key="option.value">
                                            <li @click="select(option)"
                                                class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer truncate transition-colors"
                                                :class="{'bg-blue-50 text-blue-700 font-medium': value == option.value}"
                                                x-text="option.label">
                                            </li>
                                        </template>
                                        <li x-show="filteredOptions.length === 0"
                                            class="px-3 py-4 text-xs text-gray-400 text-center italic">
                                            No sites found
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- Employee Filter (Searchable) -->
                        <div class="w-full md:w-56" x-data="searchableSelect({
                                                            options: {{ $employees->map(fn($e) => ['value' => $e->id, 'label' => $e->first_name . ' ' . $e->last_name])->values()->toJson() }},
                                                            value: '{{ request('employee_id') }}',
                                                            placeholder: 'All Employees'
                                                        })" @click.outside="open = false">
                            <label
                                class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Employee</label>
                            <div class="relative">
                                <div @click="open = !open"
                                    class="w-full bg-white border border-gray-300 rounded-lg px-3 py-2 text-sm shadow-sm cursor-pointer flex justify-between items-center h-[38px] hover:border-blue-400 transition-colors">
                                    <span x-text="selectedLabel" class="truncate text-gray-700"></span>
                                    <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </div>
                                <input type="hidden" name="employee_id" :value="value">

                                <div x-show="open" x-transition.origin.top.left x-cloak
                                    class="absolute z-50 w-full bg-white border border-gray-300 rounded-lg mt-1 shadow-xl max-h-60 overflow-hidden flex flex-col">
                                    <div class="p-2 border-b border-gray-100 bg-gray-50/50">
                                        <input type="text" x-model="search" placeholder="Search employee..."
                                            class="w-full text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5 px-2">
                                    </div>
                                    <ul class="overflow-y-auto flex-1 p-1">
                                        <li @click="select({value: '', label: 'All Employees'})"
                                            class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer transition-colors"
                                            :class="{'bg-blue-50 text-blue-700 font-medium': value === ''}">
                                            All Employees
                                        </li>
                                        <template x-for="option in filteredOptions" :key="option.value">
                                            <li @click="select(option)"
                                                class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer truncate transition-colors"
                                                :class="{'bg-blue-50 text-blue-700 font-medium': value == option.value}"
                                                x-text="option.label">
                                            </li>
                                        </template>
                                        <li x-show="filteredOptions.length === 0"
                                            class="px-3 py-4 text-xs text-gray-400 text-center italic">
                                            No employees found
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- Calculation Mode -->
                        <div class="flex flex-col gap-2">
                            <label class="block text-xs font-bold text-gray-600 uppercase tracking-wide">Calculation
                                Mode</label>
                            <div class="flex items-center gap-4 bg-gray-50 border border-gray-300 rounded-lg px-3 h-[38px]">
                                <label class="flex items-center gap-2 cursor-pointer">
                                    <input type="radio" name="calculation_mode" value="scheduled" {{ request('calculation_mode') == 'scheduled' ? 'checked' : '' }}
                                        class="text-blue-600 focus:ring-blue-500">
                                    <span class="text-xs font-medium text-gray-700">Scheduled (Client)</span>
                                </label>
                                <label class="flex items-center gap-2 cursor-pointer">
                                    <input type="radio" name="calculation_mode" value="actual" {{ request('calculation_mode', 'actual') == 'actual' ? 'checked' : '' }}
                                        class="text-blue-600 focus:ring-blue-500">
                                    <span class="text-xs font-medium text-gray-700">Actual (Office)</span>
                                </label>
                            </div>
                        </div>

                        <div class="flex items-end gap-2">
                            <button type="submit"
                                class="h-[38px] px-6 bg-slate-900 text-white text-sm font-medium rounded-lg hover:bg-slate-800 transition-colors whitespace-nowrap shadow-sm">
                                Apply Filters
                            </button>
                            <a href="{{ route('reports.operational.payouts.export.pdf', request()->query()) }}"
                                target="_blank"
                                class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                                <svg class="w-4 h-4 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z">
                                    </path>
                                </svg>
                                Export PDF
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Payouts Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Date</th>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Duty #</th>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Employee</th>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Site</th>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Site ID</th>

                            @if(request('calculation_mode', 'actual') == 'scheduled')
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Sch. In Time
                                </th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Sch. Out Time
                                </th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Sch. Total
                                    Hrs</th>
                            @else
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Act. In Time
                                </th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Act. Out Time
                                </th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Act. Worked
                                    Hrs</th>
                            @endif

                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Wage
                                Components</th>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right">
                                Total Payout</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($payouts as $row)
                            <tr class="hover:bg-gray-50/80 transition-colors">
                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-600">
                                    {{ \Carbon\Carbon::parse($row->schedule_date)->format('M d, Y') }}
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs font-medium text-gray-500">
                                    #{{ $row->duty_number }}
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm font-bold text-gray-900">
                                    {{ $row->first_name }} {{ $row->last_name }}
                                    @if(isset($row->stat_multiplier) && $row->stat_multiplier > 1)
                                        <span
                                            class="ml-2 inline-flex items-center px-2 py-0.5 rounded text-[9px] font-bold uppercase tracking-wider bg-purple-100 text-purple-700 border border-purple-200"
                                            title="{{ $row->stat_holiday_name ?? 'Stat Holiday' }} ({{ $row->stat_multiplier }}x)">
                                            STAT
                                        </span>
                                    @endif
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-600">
                                    {{ $row->site_name }}
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs font-mono text-gray-500">
                                    {{ $row->site_custom_id }}
                                </td>

                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-600">
                                    {{ $row->view_start ? \Carbon\Carbon::parse($row->view_start)->format('h:i A') : '--' }}
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-600">
                                    {{ $row->view_end ? \Carbon\Carbon::parse($row->view_end)->format('h:i A') : '--' }}
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs font-bold text-gray-800">
                                    {{ number_format($row->view_hours ?? 0, 2) }} hrs
                                </td>
                                <td class="px-4 py-3">
                                    @php
                                        $wageTypes = json_decode($row->wage_types, true) ?: [];
                                        $gasRate = $row->gas_rate > 0 ? $row->gas_rate : 0;
                                    @endphp

                                    @if(!empty($wageTypes) || $gasRate > 0)
                                        <div class="space-y-1.5">
                                            @foreach($wageTypes as $wageType)
                                                @php
                                                    $componentHours = $wageType['allocated_hours'] ?? 0;
                                                    $componentRate = $wageType['rate'] ?? 0;
                                                    $componentPay = $componentHours * $componentRate;
                                                @endphp
                                                <div
                                                    class="flex items-center justify-between gap-4 text-xs bg-blue-50/50 px-2 py-1 rounded border border-blue-100">
                                                    <span
                                                        class="font-bold text-blue-700 uppercase text-[10px]">{{ $wageType['name'] ?? 'Wage' }}</span>
                                                    <div class="flex items-center gap-2 text-[10px]">
                                                        <span class="text-gray-600">{{ number_format($componentHours, 2) }} hrs</span>
                                                        <span class="text-gray-400">×</span>
                                                        <span class="text-gray-600">${{ number_format($componentRate, 2) }}</span>
                                                        <span class="text-gray-400">=</span>
                                                        <span
                                                            class="font-bold text-blue-700">${{ number_format($componentPay, 2) }}</span>
                                                    </div>
                                                </div>
                                            @endforeach

                                            @if($gasRate > 0)
                                                <div
                                                    class="flex items-center justify-between gap-4 text-xs bg-amber-50/50 px-2 py-1 rounded border border-amber-100">
                                                    <span class="font-bold text-amber-700 uppercase text-[10px]">GAS/CASH</span>
                                                    <div class="flex items-center gap-2 text-[10px]">
                                                        <span class="font-bold text-amber-700">${{ number_format($gasRate, 2) }}</span>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    @else
                                        <span class="text-xs text-gray-400 italic">No wage data</span>
                                    @endif
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-right">
                                    <div class="text-sm font-black text-gray-900">${{ number_format($row->total_payout, 2) }}
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="12" class="px-6 py-12 text-center text-gray-400">
                                    No completed shifts found for payout summary.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($payouts->hasPages())
                <div class="px-6 py-4 border-t border-gray-100">
                    {{ $payouts->withQueryString()->links() }}
                </div>
            @endif>
        </div>
    </div>
@endsection