@extends('layouts.user')

@section('title', 'Late Check-in Report')

@section('content')
    <div class="space-y-6">
        <!-- Dashboard Header -->
        <div class="flex flex-col gap-1 mb-4">
            @if($company)
                <h2 class="text-xl font-bold text-gray-900 tracking-tight uppercase">{{ $company->name }}</h2>
                <p class="text-sm text-gray-500 font-medium italic">
                    {{ $company->address_1 }}{{ $company->address_2 ? ', ' . $company->address_2 : '' }}
                </p>
            @endif
            <h1 class="text-3xl font-black text-slate-800 tracking-tighter uppercase mt-2">Late Check-in Report</h1>
        </div>

        <!-- Filters -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="{{ route('reports.operational.late_checkin') }}" class="space-y-6">
                <!-- Quick Date Filters -->
                <div class="flex gap-2 mb-4">
                    <a href="{{ route('reports.operational.late_checkin', ['start_date' => now()->format('Y-m-d'), 'end_date' => now()->format('Y-m-d')]) }}"
                        class="px-3 py-1 text-xs font-semibold rounded-full border {{ request('start_date') == now()->format('Y-m-d') && request('end_date') == now()->format('Y-m-d') ? 'bg-blue-100 text-blue-700 border-blue-200' : 'bg-gray-50 text-gray-600 border-gray-200 hover:bg-gray-100' }}">
                        Today
                    </a>
                    <a href="{{ route('reports.operational.late_checkin', ['start_date' => now()->startOfWeek()->format('Y-m-d'), 'end_date' => now()->endOfWeek()->format('Y-m-d')]) }}"
                        class="px-3 py-1 text-xs font-semibold rounded-full border {{ request('start_date') == now()->startOfWeek()->format('Y-m-d') ? 'bg-blue-100 text-blue-700 border-blue-200' : 'bg-gray-50 text-gray-600 border-gray-200 hover:bg-gray-100' }}">
                        This Week
                    </a>
                    <a href="{{ route('reports.operational.late_checkin', ['start_date' => now()->startOfMonth()->format('Y-m-d'), 'end_date' => now()->endOfMonth()->format('Y-m-d')]) }}"
                        class="px-3 py-1 text-xs font-semibold rounded-full border {{ request('start_date') == now()->startOfMonth()->format('Y-m-d') ? 'bg-blue-100 text-blue-700 border-blue-200' : 'bg-gray-50 text-gray-600 border-gray-200 hover:bg-gray-100' }}">
                        This Month
                    </a>
                </div>

                <div class="flex flex-col md:flex-row gap-6 items-end">

                    {{-- Export Buttons --}}
                    <div class="flex-none flex items-center gap-2">
                        <a href="{{ route('reports.operational.late_checkin.export.pdf', request()->query()) }}"
                            target="_blank"
                            class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                            <svg class="w-4 h-4 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z">
                                </path>
                            </svg>
                            PDF
                        </a>
                        <a href="{{ route('reports.operational.late_checkin.export.excel', request()->query()) }}"
                            target="_blank"
                            class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                            <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                </path>
                            </svg>
                            Excel
                        </a>
                    </div>

                    <div class="flex-grow"></div> <!-- Spacer -->

                    <div class="w-full md:w-40">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start Date</label>
                        <input type="date" name="start_date"
                            value="{{ request('start_date', now()->startOfMonth()->format('Y-m-d')) }}"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                    </div>

                    <div class="w-full md:w-40">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End Date</label>
                        <input type="date" name="end_date" value="{{ request('end_date', now()->format('Y-m-d')) }}"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                    </div>

                    <button type="submit"
                        class="h-[38px] px-6 bg-slate-100 text-slate-600 text-sm font-bold rounded-lg hover:bg-slate-200 transition-colors whitespace-nowrap shadow-sm border border-slate-200">
                        Search
                    </button>
                </div>
            </form>
        </div>

        <!-- Data Content -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Duty ID</th>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Employee Name
                            </th>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Site</th>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Date</th>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Scheduled
                                Start</th>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Actual Start
                            </th>
                            <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Delay</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($lateCheckins as $row)
                            <tr class="hover:bg-gray-50/50">
                                <td class="px-4 py-3 text-xs text-gray-600 font-medium">{{ $row->duty_number }}</td>
                                <td class="px-4 py-3 text-xs text-gray-600 font-bold uppercase">{{ $row->first_name }}
                                    {{ $row->last_name }}
                                </td>
                                <td class="px-4 py-3 text-xs text-gray-600">{{ $row->site_name }}</td>
                                <td class="px-4 py-3 text-xs text-gray-600">
                                    {{ \Carbon\Carbon::parse($row->schedule_date)->format('Y-m-d') }}
                                </td>
                                <td class="px-4 py-3 text-xs text-gray-600 font-medium">
                                    {{ \Carbon\Carbon::parse($row->scheduled_start)->format('H:i') }}
                                </td>
                                <td class="px-4 py-3 text-xs text-red-600 font-bold">
                                    {{ \Carbon\Carbon::parse($row->actual_start_at)->format('H:i') }}
                                </td>
                                <td class="px-4 py-3 text-xs text-red-600 font-bold">
                                    @php
                                        $scheduled = \Carbon\Carbon::parse($row->scheduled_start);
                                        $actual = \Carbon\Carbon::parse($row->actual_start_at);
                                        $diff = $scheduled->diff($actual)->format('%H:%I:%S');
                                    @endphp
                                    {{ $diff }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="px-4 py-8 text-center text-gray-500">
                                    No late check-ins found for the selected period.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="px-4 py-3 border-t border-gray-200">
                {{ $lateCheckins->links() }}
            </div>
        </div>
    </div>
@endsection