<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Duty Positions List</title>
    <style>
        body {
            font-family: sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        h1 {
            text-align: center;
        }

        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            font-size: 12px;
            color: #777;
        }
    </style>
</head>

<body>
    <h1>Duty Positions List</h1>
    <p>Generated on: {{ now()->format('M d, Y H:i A') }}</p>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Position Name</th>
                <th>Status</th>
                <th>Created At</th>
            </tr>
        </thead>
        <tbody>
            @foreach($positions as $index => $position)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $position->name }}</td>
                    <td>{{ $position->active ? 'Active' : 'Inactive' }}</td>
                    <td>{{ $position->created_at->format('M d, Y') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        &copy; {{ date('Y') }} Shift Matrix. All rights reserved.
    </div>
</body>

</html>