@extends('layouts.meeting')

@section('title', 'Waiting Room')

@section('content')
    <div class="h-screen flex items-center justify-center p-6 sm:p-0" x-data="waitingRoom">
        <div class="max-w-md w-full glass p-8 rounded-3xl text-center space-y-8 relative overflow-hidden">
            <!-- Decoration -->
            <div class="absolute -top-24 -right-24 w-48 h-48 bg-blue-600/10 rounded-full blur-3xl"></div>
            <div class="absolute -bottom-24 -left-24 w-48 h-48 bg-blue-600/5 rounded-full blur-3xl"></div>

            <div class="relative">
                <div
                    class="w-20 h-20 bg-blue-600/20 rounded-2xl flex items-center justify-center mx-auto mb-6 relative group">
                    <div
                        class="absolute inset-0 bg-blue-600 rounded-2xl animate-ping opacity-20 group-hover:opacity-40 transition-opacity">
                    </div>
                    <svg class="w-10 h-10 text-blue-500 relative" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>

                <h1 class="text-3xl font-black text-white tracking-tight">Almost There!</h1>
                <p class="text-gray-400 mt-2 text-sm leading-relaxed">
                    The meeting organizer, <strong class="text-blue-400">{{ $meeting->creator->name }}</strong>, has been
                    notified.
                    They'll let you in shortly.
                </p>
            </div>

            <div class="space-y-6">
                <div class="bg-slate-800/50 p-4 rounded-2xl border border-white/5 flex items-center gap-4 text-left">
                    <div class="w-10 h-10 rounded-full bg-slate-700 flex items-center justify-center font-bold text-xs">
                        {{ Auth::user()->name[0] }}
                    </div>
                    <div>
                        <p class="text-xs font-bold text-gray-500 uppercase tracking-widest">Signed in as</p>
                        <p class="text-sm font-semibold text-white">{{ Auth::user()->name }}</p>
                    </div>
                </div>

                <div class="flex flex-col items-center gap-4">
                    <div
                        class="flex items-center gap-2 text-[10px] font-bold text-blue-500 uppercase tracking-[0.2em] animate-pulse">
                        <div class="w-1.5 h-1.5 bg-blue-500 rounded-full"></div>
                        Waiting for host approval
                        <div class="w-1.5 h-1.5 bg-blue-500 rounded-full"></div>
                    </div>

                    <button @click="reNotifyHost()" :disabled="retrying"
                        class="px-6 py-2 rounded-xl bg-white/5 border border-white/10 text-xs font-bold text-gray-400 hover:text-white hover:bg-white/10 transition-all flex items-center gap-2 disabled:opacity-50">
                        <svg class="w-3.5 h-3.5" :class="retrying ? 'animate-spin' : ''" fill="none" stroke="currentColor"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15">
                            </path>
                        </svg>
                        <span x-text="retrying ? 'Notifying...' : 'Re-notify Host'"></span>
                    </button>
                    <p x-show="pinged" class="text-[9px] text-green-500 font-bold uppercase tracking-wider">Host notified
                        again!</p>
                </div>
            </div>

            <div class="pt-4 border-t border-white/5">
                <a href="{{ route('meetings.index') }}"
                    class="text-gray-500 hover:text-white text-xs font-bold uppercase tracking-widest transition-colors">
                    Cancel & Go Back
                </a>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('waitingRoom', () => ({
                retrying: false,
                pinged: false,
                init() {
                    this.listenForApproval();
                },
                listenForApproval() {
                    window.Echo.private('user.{{ Auth::id() }}')
                        .listen('.join.approved', (data) => {
                            if (data.meeting.uuid === '{{ $meeting->uuid }}') {
                                window.location.href = '{{ route("meetings.room", $meeting->uuid) }}';
                            }
                        });
                },
                async reNotifyHost() {
                    this.retrying = true;
                    this.pinged = false;
                    try {
                        await fetch('{{ route("meetings.request-join", $meeting->uuid) }}', {
                            method: 'POST',
                            headers: {
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            }
                        });
                        this.pinged = true;
                        setTimeout(() => this.pinged = false, 3000);
                    } catch (e) {
                        console.error(e);
                    } finally {
                        this.retrying = false;
                    }
                }
            }));
        });
    </script>
@endsection