@extends('layouts.user')

@section('title', 'Start New Meeting')

@section('page_title', 'Meeting Setup')

@section('content')
    <div class="max-w-2xl mx-auto py-12">
        <div class="bg-white rounded-3xl shadow-2xl border border-gray-100 overflow-hidden">
            <div class="bg-slate-900 p-12 text-white relative overflow-hidden">
                <div class="absolute -top-12 -right-12 w-48 h-48 bg-blue-600/20 rounded-full blur-3xl"></div>
                <div class="relative z-10 text-center">
                    <div
                        class="w-16 h-16 bg-blue-600 rounded-2xl flex items-center justify-center mx-auto mb-6 shadow-2xl rotate-3">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z">
                            </path>
                        </svg>
                    </div>
                    <h2 class="text-3xl font-black tracking-tight">Create Session</h2>
                    <p class="text-blue-100/60 mt-2 text-sm uppercase tracking-widest font-bold">Instant Real-time
                        Connection</p>
                </div>
            </div>

            <div class="p-12">
                <form action="{{ route('meetings.store') }}" method="POST" class="space-y-8">
                    @csrf
                    <div>
                        <label class="block text-xs font-black text-gray-500 uppercase tracking-widest mb-3">Discussion
                            Subject</label>
                        <input type="text" name="title" required placeholder="e.g. Operations Sync - Central Guard Unit"
                            class="w-full bg-gray-50 border-gray-100 border-2 rounded-2xl px-6 py-4 text-lg font-bold text-gray-900 placeholder:text-gray-300 focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/5 transition-all outline-none">
                        @error('title')
                            <p class="text-red-500 text-xs mt-2 font-bold">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="bg-blue-50/50 p-6 rounded-2xl border border-blue-100 flex items-start gap-4">
                        <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center text-blue-600 shrink-0">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <div>
                            <h4 class="text-sm font-bold text-blue-900">Host Privileges</h4>
                            <p class="text-xs text-blue-700/70 mt-1 leading-relaxed">
                                As the creator, you will have exclusive control to <strong>Approve/Decline</strong> join
                                requests and <strong>End the Meeting</strong> for all participants.
                            </p>
                        </div>
                    </div>

                    <button type="submit"
                        class="w-full py-5 bg-blue-600 text-white font-black text-lg rounded-2xl shadow-xl shadow-blue-500/30 hover:bg-blue-700 transform active:scale-[0.98] transition-all uppercase tracking-widest">
                        Initialize Meeting Room
                    </button>
                </form>
            </div>
        </div>
    </div>
@endsection