<div x-data="{ 
    open: false, 
    messages: [{text: 'Hi! I am your AI assistant.\nAsk me about starting jobs, images, or salary.', sender: 'bot'}], 
    userInput: '',
    loading: false,
    listening: false,

    startListening() {
        if (!('webkitSpeechRecognition' in window) && !('SpeechRecognition' in window)) {
            alert('Voice input is not supported in this browser.');
            return;
        }
        
        const recognition = new (window.SpeechRecognition || window.webkitSpeechRecognition)();
        recognition.lang = 'en-US';
        recognition.interimResults = false;
        recognition.maxAlternatives = 1;

        this.listening = true;
        
        recognition.start();

        recognition.onresult = (event) => {
            const transcript = event.results[0][0].transcript;
            this.userInput = transcript;
            this.listening = false;
        };

        recognition.onerror = (event) => {
            console.error('Speech recognition error', event.error);
            this.listening = false;
        };
        
        recognition.onend = () => {
             this.listening = false;
        };
    },
    
    speak(text) {
        if (!('speechSynthesis' in window)) return;
        window.speechSynthesis.cancel();
        const utterance = new SpeechSynthesisUtterance(text);
        window.speechSynthesis.speak(utterance);
    },

    sendMessage() {
        if (!this.userInput.trim()) return;
        
        const text = this.userInput;
        this.messages.push({text: text, sender: 'user'});
        this.userInput = '';
        this.loading = true;
        
        this.$nextTick(() => {
            const chatContainer = this.$refs.chatContainer;
            chatContainer.scrollTop = chatContainer.scrollHeight;
        });
        
        fetch('{{ route('employee.chatbot') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ message: text })
        })
        .then(res => res.json())
        .then(data => {
            this.messages.push({text: data.response, sender: 'bot'});
            this.loading = false;
            
            // Auto-scroll
            this.$nextTick(() => {
                const chatContainer = this.$refs.chatContainer;
                chatContainer.scrollTop = chatContainer.scrollHeight;
            });
        })
        .catch(() => {
            this.messages.push({text: 'Error connecting to bot.', sender: 'bot'});
            this.loading = false;
        });
    }
}" class="fixed bottom-6 right-6 z-50 flex flex-col items-end print:hidden">

    <!-- Chat Window -->
    <div x-show="open" x-transition x-cloak
        class="bg-white rounded-lg shadow-xl border border-slate-200 w-80 h-[28rem] flex flex-col overflow-hidden mb-4">
        <!-- Header -->
        <div class="bg-slate-900 text-white p-3 flex justify-between items-center">
            <div class="flex items-center gap-2">
                <div class="w-2 h-2 bg-green-400 rounded-full animate-pulse"></div>
                <span class="font-semibold text-sm">Voice Assistant</span>
            </div>
            <button @click="open = false" class="text-slate-300 hover:text-white">&times;</button>
        </div>

        <!-- Messages -->
        <div x-ref="chatContainer" class="flex-1 overflow-y-auto p-3 space-y-3 bg-gray-50">
            <template x-for="msg in messages">
                <div :class="msg.sender === 'user' ? 'flex justify-end' : 'flex justify-start'">
                    <div class="flex items-end gap-1" :class="msg.sender === 'user' ? 'flex-row-reverse' : 'flex-row'">
                        <div
                            :class="msg.sender === 'user' 
                            ? 'bg-blue-600 text-white rounded-l-lg rounded-tr-lg py-2 px-3 text-sm max-w-[85%]' 
                            : 'bg-white border border-gray-200 text-slate-800 rounded-r-lg rounded-tl-lg py-2 px-3 text-sm max-w-[85%] shadow-sm'">
                            <p x-text="msg.text" class="whitespace-pre-line leading-relaxed"></p>
                        </div>

                        <!-- Speaker Button for Bot -->
                        <template x-if="msg.sender === 'bot'">
                            <button @click="speak(msg.text)" class="text-slate-400 hover:text-blue-500 p-1"
                                title="Read Aloud">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15.536 8.464a5 5 0 010 7.072m2.828-9.9a9 9 0 010 12.728M5.586 15H4a1 1 0 01-1-1v-4a1 1 0 011-1h1.586l4.707-4.707C10.923 3.663 12 4.109 12 5v14c0 .891-1.077 1.337-1.707.707L5.586 15z">
                                    </path>
                                </svg>
                            </button>
                        </template>
                    </div>
                </div>
            </template>
            <div x-show="loading" class="flex justify-start">
                <div class="bg-gray-200 text-slate-500 rounded-lg py-1 px-3 text-xs animate-pulse">Thinking...</div>
            </div>
        </div>

        <!-- Input -->
        <div class="p-3 bg-white border-t border-slate-100 flex gap-2 items-center">
            <!-- Voice Input Button -->
            <button @click="startListening()"
                :class="listening ? 'text-red-500 animate-pulse' : 'text-slate-400 hover:text-blue-600'"
                class="p-1.5 rounded-full hover:bg-slate-100 transition" title="Voice Input">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M19 11a7 7 0 01-7 7m0 0a7 7 0 01-7-7m7 7v4m0 0H8m4 0h4m-4-8a3 3 0 01-3-3V5a3 3 0 116 0v6a3 3 0 01-3 3z">
                    </path>
                </svg>
            </button>

            <input @keydown.enter="sendMessage()" x-model="userInput" type="text" placeholder="Type or speak..."
                class="flex-1 text-sm border border-slate-300 rounded-md px-2 py-1.5 focus:outline-none focus:border-blue-500">

            <button @click="sendMessage()"
                class="bg-blue-600 text-white rounded-md px-3 py-1.5 hover:bg-blue-700 transition flex items-center justify-center">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                </svg>
            </button>
        </div>
    </div>

    <!-- Toggle Button -->
    <button @click="open = !open"
        class="bg-blue-600 hover:bg-blue-700 text-white rounded-full p-3 shadow-lg transition-transform transform hover:scale-105 flex items-center justify-center w-14 h-14">
        <svg x-show="!open" class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z">
            </path>
        </svg>
        <svg x-show="open" class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
        </svg>
    </button>
</div>