@extends('layouts.user')

@section('title', 'Map Import Columns')

@section('content')
<div class="min-h-screen bg-slate-50 pb-20">
    <!-- Header -->
    <div class="bg-white border-b border-gray-200 sticky top-0 z-30">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex flex-col md:flex-row md:items-center justify-between py-4 gap-4">
                <div class="flex items-center gap-4">
                    <div class="bg-blue-100 p-2 rounded-lg">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7"></path>
                        </svg>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 tracking-tight">Map Columns</h1>
                        <p class="text-sm text-gray-500">Match your CSV columns to database fields</p>
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <a href="{{ route('employees.import.settings') }}" 
                        class="inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors">
                        Cancel Import
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <form action="{{ route('employees.import.process') }}" method="POST" id="mappingForm">
            @csrf
            <input type="hidden" name="temp_file_path" value="{{ $tempPath }}">

            <!-- Data Preview Section -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 mb-8 overflow-hidden">
                <div class="bg-gray-50 border-b border-gray-200 px-6 py-4">
                    <h3 class="text-base font-semibold text-gray-900">File Preview</h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                @foreach($csvHeaders as $header)
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">
                                    {{ $header }}
                                </th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($previewData as $index => $row)
                                @if($index > 0) <!-- Skip header row in data -->
                                <tr class="hover:bg-gray-50 transition-colors">
                                    {{-- Handle row length mismatch --}}
                                    @foreach($csvHeaders as $key => $header)
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                                        {{ isset($row[$key]) ? Str::limit($row[$key], 30) : '' }}
                                    </td>
                                    @endforeach
                                </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Mapping Grid -->
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Main Mapping Area -->
                <div class="lg:col-span-2 space-y-6">
                    @php
                        $groupedColumns = collect($employeeColumns)->groupBy('category');
                    @endphp

                    @foreach($groupedColumns as $category => $columns)
                    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                        <div class="bg-gray-50 border-b border-gray-200 px-6 py-4 flex items-center justify-between">
                            <h3 class="font-bold text-gray-900">{{ $category }}</h3>
                            <span class="text-xs font-medium text-gray-500 bg-white px-2 py-1 rounded border border-gray-200">
                                {{ count($columns) }} Fields
                            </span>
                        </div>
                        <div class="p-6 space-y-4">
                            @foreach($columns as $column)
                            <div class="flex flex-col sm:flex-row sm:items-center gap-4 p-4 rounded-lg border {{ $column['required'] ? 'border-blue-100 bg-blue-50/30' : 'border-gray-100 bg-gray-50/30' }} hover:border-blue-300 transition-colors">
                                <div class="w-full sm:w-1/3">
                                    <label class="block text-sm font-medium text-gray-900">
                                        {{ $column['label'] }}
                                        @if($column['required'])
                                            <span class="text-red-500">*</span>
                                        @endif
                                    </label>
                                    @if(isset($column['note']))
                                        <p class="text-xs text-blue-600 mt-1">{{ $column['note'] }}</p>
                                    @endif
                                </div>
                                <div class="w-full sm:w-2/3">
                                    <select name="mapping[{{ $column['name'] }}]" 
                                            class="mapping-select block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                            data-column-name="{{ $column['name'] }}"
                                            {{ $column['required'] ? 'required' : '' }}>
                                        <option value="">-- Ignore Column --</option>
                                        @foreach($csvHeaders as $index => $header)
                                            <option value="{{ $index }}" 
                                                {{ (strtolower(trim($header)) == strtolower(trim($column['label'])) || 
                                                    strtolower(trim($header)) == strtolower(trim($column['name']))) ? 'selected' : '' }}>
                                                {{ $header }} (Column {{ $index + 1 }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endforeach
                </div>

                <!-- Sidebar Summary -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-xl shadow-sm border border-gray-200 sticky top-24">
                        <div class="p-6">
                            <h3 class="text-lg font-bold text-gray-900 mb-4">Import Summary</h3>
                            
                            <div class="space-y-4 mb-6">
                                <div class="flex justify-between text-sm">
                                    <span class="text-gray-500">Total Rows</span>
                                    <span class="font-medium text-gray-900">{{ count($previewData) > 0 ? count($previewData) - 1 : 0 }}</span>
                                </div>
                                <div class="flex justify-between text-sm">
                                    <span class="text-gray-500">Columns Found</span>
                                    <span class="font-medium text-gray-900">{{ count($csvHeaders) }}</span>
                                </div>
                            </div>

                            <button type="submit" 
                                    class="w-full flex justify-center py-3 px-4 border border-transparent rounded-xl shadow-sm text-sm font-bold text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-all transform hover:scale-[1.02]">
                                Run Import Process
                            </button>
                            
                            <p class="mt-4 text-xs text-gray-500 text-center">
                                Only mapped columns will be imported. Rows with validation errors will be skipped and reported.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto-map functionality handled by blade template selection logic
        // Verify required fields
        const form = document.getElementById('mappingForm');
        form.addEventListener('submit', function(e) {
            const requiredSelects = form.querySelectorAll('select[required]');
            let valid = true;
            requiredSelects.forEach(select => {
                if (!select.value) {
                    valid = false;
                    select.classList.add('border-red-500', 'ring-1', 'ring-red-500');
                } else {
                    select.classList.remove('border-red-500', 'ring-1', 'ring-red-500');
                }
            });

            if (!valid) {
                e.preventDefault();
                alert('Please map all required fields marked with *');
            }
        });

        // Clear error styling on change
        const selects = form.querySelectorAll('select');
        selects.forEach(select => {
            select.addEventListener('change', function() {
                if (this.value) {
                    this.classList.remove('border-red-500', 'ring-1', 'ring-red-500');
                }
            });
        });
    });
</script>
@endsection