@extends(request()->routeIs('admin.*') ? 'layouts.admin' : 'layouts.user')

@section('title', 'Employee Analytics')
@section('page_title', 'Analytics: ' . $employee->first_name . ' ' . $employee->last_name)

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">Performance Analytics</h1>
                <p class="text-sm text-gray-500 mt-1">Detailed performance metrics for {{ $employee->first_name }}
                    {{ $employee->last_name }}</p>
            </div>
            <div>
                <span class="text-sm font-medium text-gray-500">Period: Last 30 Days</span>
            </div>
        </div>

        <!-- 1. Stats Grid (Shifts & Attendance) -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <!-- Guard Shifts -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm hover:shadow-md transition-shadow">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-sm font-medium text-gray-500">Guard Shifts</h3>
                    <span class="p-2 bg-blue-50 text-blue-600 rounded-lg">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2">
                            </path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline">
                    <span class="text-2xl font-bold text-gray-800">{{ $guardStats['total'] }}</span>
                </div>
                <div class="mt-2 text-xs text-slate-400">Assigned</div>
            </div>

            <!-- Patroller Shifts -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm hover:shadow-md transition-shadow">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-sm font-medium text-gray-500">Patroller Shifts</h3>
                    <span class="p-2 bg-purple-50 text-purple-600 rounded-lg">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline">
                    <span class="text-2xl font-bold text-gray-800">{{ $patrollerStats['total'] }}</span>
                </div>
                <div class="mt-2 text-xs text-slate-400">Assigned</div>
            </div>

            <!-- Guard Attendance -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm hover:shadow-md transition-shadow">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-sm font-medium text-gray-500">Attendance (Guard)</h3>
                    <span class="p-2 bg-green-50 text-green-600 rounded-lg">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline">
                    <span class="text-2xl font-bold text-gray-800">{{ $guardAttendanceRate }}%</span>
                </div>
                <div class="mt-2 text-xs text-slate-400">On-time Rate</div>
            </div>

            <!-- Patroller Attendance -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm hover:shadow-md transition-shadow">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-sm font-medium text-gray-500">Attendance (Patroller)</h3>
                    <span class="p-2 bg-teal-50 text-teal-600 rounded-lg">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline">
                    <span class="text-2xl font-bold text-gray-800">{{ $patrollerAttendanceRate }}%</span>
                </div>
                <div class="mt-2 text-xs text-slate-400">On-time Rate</div>
            </div>
        </div>

        <!-- 2. Stats Grid (Duration & Lates) -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <!-- Guard Duration -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <h3 class="text-sm font-medium text-gray-500 mb-2">Avg Shift Dur. (Guard)</h3>
                <span class="text-2xl font-bold text-gray-800">{{ $guardAvgDuration }}h</span>
                <p class="text-xs text-gray-400 mt-1">Per scheduled shift</p>
            </div>

            <!-- Patroller Duration -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <h3 class="text-sm font-medium text-gray-500 mb-2">Avg Shift Dur. (Patroller)</h3>
                <span class="text-2xl font-bold text-gray-800">{{ $patrollerAvgDuration }}h</span>
                <p class="text-xs text-gray-400 mt-1">Per scheduled shift</p>
            </div>

            <!-- Late Guard -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm border-l-4 border-l-red-500">
                <h3 class="text-sm font-medium text-gray-500 mb-2">Late Check-ins (Guard)</h3>
                <span class="text-2xl font-bold text-red-600">{{ $guardStats['late'] }}</span>
                <p class="text-xs text-gray-400 mt-1">Incidents</p>
            </div>

            <!-- Late Patroller -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm border-l-4 border-l-red-500">
                <h3 class="text-sm font-medium text-gray-500 mb-2">Late Check-ins (Patroller)</h3>
                <span class="text-2xl font-bold text-red-600">{{ $patrollerStats['late'] }}</span>
                <p class="text-xs text-gray-400 mt-1">Incidents</p>
            </div>
        </div>

        <!-- 3. Charts Row 1 -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Assigned Jobs -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Assigned Jobs Distribution</h3>
                <div class="relative h-64">
                    <canvas id="assignedChart"></canvas>
                </div>
            </div>

            <!-- Job Status Overview -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Job Status Overview</h3>
                <div class="relative h-64">
                    <canvas id="jobStatusChart"></canvas>
                </div>
            </div>
        </div>

        <!-- 4. Charts Row 2 (Tickets) -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 pb-6">
            <!-- Site Wise -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Ticket Issues (By Site)</h3>
                <div class="relative h-64">
                    <canvas id="siteTicketsChart"></canvas>
                </div>
            </div>

            <!-- Monthly -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Ticket Issues (Monthly Trend)</h3>
                <div class="relative h-64">
                    <canvas id="monthlyTicketsChart"></canvas>
                </div>
            </div>
        </div>

    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // 1. Assigned Jobs (Pie)
            new Chart(document.getElementById('assignedChart').getContext('2d'), {
                type: 'doughnut',
                data: {
                    labels: @json($assignedComparison['labels']),
                    datasets: [{
                        data: @json($assignedComparison['data']),
                        backgroundColor: ['#3b82f6', '#8b5cf6'],
                        borderWidth: 0
                    }]
                },
                options: { cutout: '60%', responsive: true, maintainAspectRatio: false }
            });

            // 2. Job Status Overview (Double Bar)
            new Chart(document.getElementById('jobStatusChart').getContext('2d'), {
                type: 'bar',
                data: {
                    labels: ['Completed', 'Missed', 'Late'],
                    datasets: [
                        {
                            label: 'Guard',
                            data: [{{ $guardStats['completed'] }}, {{ $guardStats['missed'] }}, {{ $guardStats['late'] }}],
                            backgroundColor: '#3b82f6',
                            borderRadius: 4
                        },
                        {
                            label: 'Patroller',
                            data: [{{ $patrollerStats['completed'] }}, {{ $patrollerStats['missed'] }}, {{ $patrollerStats['late'] }}],
                            backgroundColor: '#8b5cf6',
                            borderRadius: 4
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: { y: { beginAtZero: true } }
                }
            });

            // 3. Site Tickets (Bar - Horizontal)
            new Chart(document.getElementById('siteTicketsChart').getContext('2d'), {
                type: 'bar',
                data: {
                    labels: @json($siteTicketsLabels),
                    datasets: [{
                        label: 'Tickets',
                        data: @json($siteTicketsData),
                        backgroundColor: '#ef4444',
                        borderRadius: 4
                    }]
                },
                options: {
                    indexAxis: 'y',
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: { x: { beginAtZero: true } },
                    plugins: { legend: { display: false } }
                }
            });

            // 4. Monthly Tickets (Line)
            new Chart(document.getElementById('monthlyTicketsChart').getContext('2d'), {
                type: 'line',
                data: {
                    labels: @json($monthlyTicketsLabels),
                    datasets: [{
                        label: 'Tickets',
                        data: @json($monthlyTicketsData),
                        borderColor: '#ef4444',
                        backgroundColor: 'rgba(239, 68, 68, 0.1)',
                        fill: true,
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: { y: { beginAtZero: true, ticks: { stepSize: 1 } } }
                }
            });

        });
    </script>
@endsection