@extends('layouts.employee')

@section('title', 'My Uniforms')

@section('content')
    <div class="max-w-7xl mx-auto">
        <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4">
            <div>
                <h1 class="text-3xl font-black text-slate-900 tracking-tight">My Uniforms</h1>
                <p class="text-slate-500 font-bold mt-1">View all uniforms assigned to you.</p>
            </div>
        </div>

        <!-- My Assigned Gear Section -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-xl overflow-hidden">
            <div class="px-8 py-6 border-b border-gray-50 flex items-center gap-3">
                <div class="w-10 h-10 bg-blue-600 rounded-xl flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                </div>
                <div>
                    <h2 class="text-xl font-bold text-slate-800">My Assigned Gear</h2>
                    <p class="text-xs text-slate-500 font-medium">Equipment issued to you</p>
                </div>
            </div>

            @if($myUniforms->isNotEmpty())
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr
                                class="bg-slate-50 border-b border-gray-100 text-xs uppercase tracking-widest text-slate-500 font-bold">
                                <th class="px-8 py-5">Uniform Item</th>
                                <th class="px-8 py-5">Variant Details</th>
                                <th class="px-8 py-5 text-center">Quantity</th>
                                <th class="px-8 py-5">Issued Date</th>
                                <th class="px-8 py-5">Notes</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50">
                            @foreach($myUniforms as $issued)
                                <tr class="hover:bg-slate-50 transition-colors group">
                                    <td class="px-8 py-5">
                                        <div class="flex items-center gap-3">
                                            <div
                                                class="w-12 h-12 bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl flex items-center justify-center border border-blue-200">
                                                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4">
                                                    </path>
                                                </svg>
                                            </div>
                                            <div>
                                                <div class="font-bold text-slate-900">{{ $issued->variant->uniform->name }}
                                                </div>
                                                @if($issued->variant->uniform->description)
                                                    <div class="text-xs text-slate-400 mt-0.5 font-medium">
                                                        {{ Str::limit($issued->variant->uniform->description, 40) }}</div>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-8 py-5">
                                        <div class="flex items-center gap-2">
                                            @if($issued->variant->size)
                                                <span
                                                    class="px-3 py-1 bg-blue-50 text-blue-700 text-xs font-bold rounded-lg uppercase">
                                                    Size: {{ $issued->variant->size }}
                                                </span>
                                            @endif
                                            @if($issued->variant->color)
                                                <span
                                                    class="px-3 py-1 bg-purple-50 text-purple-700 text-xs font-bold rounded-lg uppercase">
                                                    {{ $issued->variant->color }}
                                                </span>
                                            @endif
                                            @if(!$issued->variant->size && !$issued->variant->color)
                                                <span class="text-slate-400 italic text-sm">Standard</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="px-8 py-5 text-center">
                                        <span
                                            class="inline-flex items-center justify-center w-10 h-10 bg-slate-900 text-white text-sm font-bold rounded-xl">
                                            {{ $issued->quantity }}
                                        </span>
                                    </td>
                                    <td class="px-8 py-5">
                                        <div class="flex flex-col">
                                            <span
                                                class="text-sm font-bold text-slate-900">{{ $issued->issued_at->format('M d, Y') }}</span>
                                            <span
                                                class="text-xs text-slate-400 font-medium">{{ $issued->issued_at->diffForHumans() }}</span>
                                        </div>
                                    </td>
                                    <td class="px-8 py-5">
                                        @if($issued->notes)
                                            <div class="text-sm text-slate-600 max-w-xs" title="{{ $issued->notes }}">
                                                {{ Str::limit($issued->notes, 50) }}
                                            </div>
                                        @else
                                            <span class="text-slate-300 text-sm italic">-</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="px-8 py-24 text-center">
                    <div class="w-20 h-20 bg-slate-50 rounded-2xl flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-2">No Uniforms Assigned</h3>
                    <p class="text-slate-500 font-medium">You don't have any uniforms assigned to you yet.</p>
                    <p class="text-slate-400 text-sm mt-2">Contact your supervisor for uniform assignment.</p>
                </div>
            @endif
        </div>
    </div>
@endsection