@extends('layouts.employee')

@section('title', 'My Requests')

@section('content')
    <div class="px-4 py-6 max-w-lg mx-auto">
        <div class="flex items-center justify-between mb-6">
            <h1 class="text-2xl font-bold text-gray-900">My Requests</h1>
            <a href="{{ route('employee.requests.create') }}"
                class="bg-blue-600 text-white w-10 h-10 flex items-center justify-center rounded-xl shadow-lg shadow-blue-500/30 transition-transform active:scale-90">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
            </a>
        </div>

        @if(session('success'))
            <div class="mb-6 p-4 bg-emerald-100 text-emerald-800 rounded-xl text-sm font-bold shadow-sm">
                {{ session('success') }}
            </div>
        @endif

        <div class="space-y-4">
            @forelse($requests as $req)
                <a href="{{ route('employee.requests.show', $req) }}"
                    class="block bg-white p-5 rounded-2xl shadow-sm border border-gray-100 active:scale-[0.98] transition-all">
                    <div class="flex justify-between items-start mb-2">
                        <span
                            class="px-2.5 py-1 bg-slate-100 text-slate-600 text-[10px] font-bold rounded-lg uppercase tracking-wide">
                            @if($req->type == 'short_leave') Short Leave
                            @elseif($req->type == 'medical') Medical
                            @else {{ ucfirst($req->type) }}
                            @endif
                        </span>
                        <span class="text-xs text-gray-400 font-bold">{{ $req->created_at->format('M d, H:i') }}</span>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-1 text-base">{{ $req->subject ?: 'Request #' . $req->id }}</h3>
                    <p class="text-sm text-gray-500 line-clamp-2 mb-3">{{ $req->message }}</p>
                    <div class="flex justify-between items-center pt-3 border-t border-gray-50">
                        <span class="px-2 py-1 rounded-md text-xs font-bold uppercase tracking-wider
                                @if($req->status == 'pending') bg-amber-50 text-amber-600
                                @elseif($req->status == 'replied') bg-blue-50 text-blue-600
                                @elseif($req->status == 'approved') bg-emerald-50 text-emerald-600
                                @elseif($req->status == 'rejected') bg-rose-50 text-rose-600
                                @else bg-gray-50 text-gray-600
                                @endif
                            ">
                            {{ ucfirst($req->status) }}
                        </span>
                        <div class="flex items-center gap-1 text-xs text-blue-600 font-bold">
                            View Details
                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </div>
                    </div>
                </a>
            @empty
                <div class="text-center py-16">
                    <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4 text-gray-400">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4">
                            </path>
                        </svg>
                    </div>
                    <p class="text-gray-500 font-medium">No requests yet.</p>
                    <p class="text-sm text-gray-400 mt-1">Submit a leave request or complaint to get started.</p>
                </div>
            @endforelse
        </div>

        <div class="mt-6">
            {{ $requests->links() }}
        </div>
    </div>
@endsection