@extends('layouts.employee')

@section('title', 'Patrol Duty Schedule')

@section('content')
    <div class="space-y-6">
        <!-- Header & Stats -->
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
            <div>
                <h2 class="text-2xl font-bold text-gray-900 tracking-tight">Patrol Roaster</h2>
                <p class="text-sm text-gray-500 mt-1">Manage your patrol routes and operational status.</p>
            </div>
        </div>

        <!-- Filters/Tabs -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200">
            <div class="flex border-b border-gray-100">
                @php
                    $tabs = [
                        'all' => 'All Operations',
                        'active' => 'Active',
                        'today' => 'Today',
                        'upcoming' => 'Upcoming',
                        'completed' => 'Completed',
                        'missed' => 'Missed',
                        'cancelled' => 'Cancelled',
                        'pending' => 'Pending'
                    ];
                @endphp
                @foreach($tabs as $key => $label)
                    <a href="{{ route('employee.patroller-jobs.index', ['type' => $key]) }}"
                        class="flex-1 px-1 py-4 text-[10px] text-center font-bold uppercase tracking-wider transition-all border-b-2 {{ $type === $key ? 'border-slate-900 text-slate-900 bg-gray-50' : 'border-transparent text-gray-400 hover:text-gray-600 hover:bg-gray-50' }}">
                        {{ $label }}
                        <span
                            class="ml-1 px-1.5 py-0.5 rounded-full text-[9px] {{ $type === $key ? 'bg-slate-200 text-slate-800' : 'bg-gray-100 text-gray-500' }}">
                            {{ $counts[$key] ?? 0 }}
                        </span>
                    </a>
                @endforeach
            </div>
        </div>

        <!-- Schedule List Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Duty #</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Route</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Schedule
                                Timings</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Actual
                                Timings</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-right">
                                Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($jobs as $job)
                            {{-- ... existing PHP block for calculations ... --}}
                            @php
                                $statusClass = $job->status_classes;
                                $statusLabel = ucfirst($job->calculated_status);
                                $isCompleted = in_array($job->job_status, ['completed', 'auto_ended']);
                            @endphp
                            <tr class="hover:bg-gray-50/80 transition-colors group" x-data="{ requestCancellation: false }">
                                <td class="px-6 py-4 align-top">
                                    <span
                                        class="text-xs font-bold text-gray-900 bg-gray-100 px-2 py-1 rounded">#{{ $job->duty_number }}</span>
                                </td>
                                <td class="px-6 py-4 align-top">
                                    <div class="flex items-start gap-3">
                                        <div
                                            class="w-8 h-8 rounded-lg bg-white border border-gray-200 text-gray-500 flex items-center justify-center font-bold text-xs shadow-sm">
                                            R
                                        </div>
                                        <div>
                                            <div class="text-sm font-bold text-gray-900">
                                                {{ $job->route->name ?? 'Unknown Route' }}
                                            </div>
                                            <div class="text-[10px] text-gray-500 font-medium mt-0.5">
                                                {{ $job->route->sites->count() ?? 0 }} Sites
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 align-top">
                                    <div class="flex flex-col gap-3">
                                        <div class="flex flex-col">
                                            <span class="text-[10px] uppercase font-bold text-gray-400 tracking-wider mb-0.5">Start Time</span>
                                            <span class="text-sm font-bold text-gray-900 leading-none">{{ $job->from_time->format('M d, Y') }}</span>
                                            <span class="text-xs font-bold text-gray-500 mt-1">{{ $job->from_time->format('h:i A') }}</span>
                                        </div>
                                        <div class="flex flex-col">
                                            <span class="text-[10px] uppercase font-bold text-gray-400 tracking-wider mb-0.5">End Time</span>
                                            <span class="text-sm font-bold text-gray-900 leading-none">{{ $job->to_time->format('M d, Y') }}</span>
                                            <span class="text-xs font-bold text-gray-500 mt-1">{{ $job->to_time->format('h:i A') }}</span>
                                        </div>
                                        <div class="text-[10px] font-bold text-blue-600 bg-blue-50 px-2 py-1 rounded w-fit">
                                            {{ number_format($job->from_time->diffInMinutes($job->to_time) / 60, 2) }} Hrs Duration
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 align-top">
                                    @if(($job->job_status === 'completed' || $job->job_status === 'auto_ended') && $job->job_started_at)
                                        <div class="flex flex-col">
                                            <span
                                                class="text-sm font-bold text-gray-900">{{ $job->job_started_at->format('M d, Y') }}</span>
                                            <span class="text-[10px] text-gray-600 font-bold">
                                                {{ $job->job_started_at->format('H:i') }} -
                                                {{ $job->job_ended_at ? $job->job_ended_at->format('H:i') : '?' }}
                                            </span>
                                            @if($job->job_ended_at)
                                                <span class="text-[9px] text-gray-400 font-medium">
                                                    {{ number_format($job->job_started_at->diffInMinutes($job->job_ended_at) / 60, 2) }}h
                                                    Actual
                                                </span>
                                            @endif
                                        </div>
                                    @else
                                        <span class="text-[10px] text-gray-400">-</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 align-top">
                                    <span
                                        class="inline-flex items-center px-2.5 py-0.5 rounded-full text-[10px] font-bold uppercase tracking-wide {{ $statusClass }}">
                                        {{ $statusLabel }}
                                    </span>
                                    @php
                                        $pivot = $job->employees->where('id', auth()->guard('employee')->id())->first()->pivot;
                                    @endphp
                                    @if($pivot->cancellation_status === 'pending')
                                        <div
                                            class="mt-2 inline-block px-2 py-0.5 bg-amber-50 text-amber-600 text-[9px] font-bold uppercase tracking-wider border border-amber-100 rounded">
                                            Cancellation Pending</div>
                                    @elseif($pivot->cancellation_status === 'rejected')
                                        <div
                                            class="mt-2 inline-block px-2 py-0.5 bg-red-50 text-red-600 text-[9px] font-bold uppercase tracking-wider border border-red-100 rounded">
                                            Cancellation Declined</div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 align-top text-right">
                                    <div class="flex justify-end gap-2">
                                        @if(!$isCompleted)
                                            @if(in_array($job->calculated_status, ['upcoming', 'today']) && (!$pivot->cancellation_requested_at || $pivot->cancellation_status === 'rejected'))
                                                <button type="button" @click="requestCancellation = true"
                                                    class="px-3 py-1.5 border border-red-200 text-red-600 hover:bg-red-50 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all whitespace-nowrap">
                                                    Cancel
                                                </button>
                                            @endif
                                            <a href="{{ route('employee.patroller-jobs.show', $job->id) }}"
                                                class="px-4 py-2 bg-slate-900 text-white hover:bg-black rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all shadow-sm whitespace-nowrap inline-flex items-center justify-center min-w-[120px]">
                                                {{ $job->job_status === 'in_progress' ? 'Continue Patrol' : 'Open Console' }}
                                            </a>
                                            @if($job->job_status === 'in_progress')
                                                <button type="button" @click="$dispatch('open-job-notes')"
                                                    class="px-3 py-2 bg-emerald-600 text-white hover:bg-emerald-700 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all shadow-sm flex items-center gap-1.5">
                                                    <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                                        </path>
                                                    </svg>
                                                    Notes
                                                </button>
                                            @endif
                                        @else
                                            <div class="flex gap-2 justify-end">
                                                <a href="{{ route('employee.patroller-jobs.report', $job->id) }}" target="_blank"
                                                    class="px-3 py-2 bg-gray-50 border border-gray-200 text-gray-600 hover:bg-gray-100 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-all">
                                                    Report
                                                </a>
                                                <button disabled
                                                    class="px-3 py-2 bg-slate-100 text-slate-400 rounded-lg text-[10px] font-bold uppercase tracking-wider cursor-not-allowed">
                                                    Completed
                                                </button>
                                            </div>
                                        @endif
                                    </div>

                                    <!-- Request Cancellation Modal -->
                                    <div x-show="requestCancellation" class="fixed inset-0 z-50 overflow-y-auto"
                                        style="display: none;" x-cloak>
                                        <div class="flex items-center justify-center min-h-screen px-4">
                                            <div class="fixed inset-0 bg-slate-900/40 backdrop-blur-sm transition-opacity"
                                                @click="requestCancellation = false"></div>
                                            <div class="relative bg-white rounded-2xl max-w-lg w-full p-8 shadow-xl text-left">
                                                <h3 class="text-lg font-bold text-gray-900 mb-2">Request
                                                    Cancellation</h3>
                                                <p class="text-xs text-gray-500 font-medium mb-6">Subject to
                                                    administrative
                                                    approval.</p>

                                                <form action="{{ route('employee.patroller-jobs.cancel', $job->id) }}"
                                                    method="POST">
                                                    @csrf
                                                    <div class="mb-6">
                                                        <label
                                                            class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2 text-left">Reason</label>
                                                        <textarea name="reason" rows="3" required
                                                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-sm font-medium focus:outline-none focus:border-slate-500 transition-colors"
                                                            placeholder="Briefly explain why..."></textarea>
                                                    </div>
                                                    <div class="flex justify-start gap-3">
                                                        <button type="button" @click="requestCancellation = false"
                                                            class="px-4 py-2 text-xs font-bold text-gray-500 hover:text-gray-700 uppercase tracking-wider">Dismiss</button>
                                                        <button type="submit"
                                                            class="px-6 py-2 bg-slate-900 text-white rounded-lg text-xs font-bold uppercase tracking-wider hover:bg-black transition-all">Request</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-12 text-center text-gray-400">
                                    <svg class="w-16 h-16 mx-auto mb-4 text-gray-200" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                            d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2">
                                        </path>
                                    </svg>
                                    <p class="text-xs font-bold uppercase tracking-wider">No patrol assignments found</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($jobs->hasPages())
                <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
                    {{ $jobs->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection