@extends('layouts.user')

@section('title', 'Developer Settings')

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Developer Settings</h1>
                <p class="text-sm text-gray-500 mt-1">Execute system commands and maintenance tasks</p>
            </div>
        </div>

        <!-- Success/Error Messages -->
        @if(session('success'))
            <div class="bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-lg">
                <div class="flex items-center gap-2">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                            clip-rule="evenodd" />
                    </svg>
                    <span class="font-medium">{{ session('success') }}</span>
                </div>
                @if(session('output'))
                    <div class="mt-3 p-3 bg-white rounded border border-green-200">
                        <pre class="text-xs text-gray-700 whitespace-pre-wrap font-mono">{{ session('output') }}</pre>
                    </div>
                @endif
            </div>
        @endif

        @if(session('error'))
            <div class="bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded-lg">
                <div class="flex items-center gap-2">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                            clip-rule="evenodd" />
                    </svg>
                    <span class="font-medium">{{ session('error') }}</span>
                </div>
            </div>
        @endif

        <!-- Commands Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">

            <!-- Auto-Complete Overdue Jobs -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow">
                <div class="flex items-start gap-4">
                    <div class="flex-shrink-0 w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <div class="flex-1">
                        <h3 class="font-bold text-gray-900 mb-1">Auto-Complete Overdue Jobs</h3>
                        <p class="text-xs text-gray-500 mb-4">Automatically complete jobs that have exceeded their scheduled
                            end time</p>
                        <form action="{{ route('developer.run-command') }}" method="POST">
                            @csrf
                            <input type="hidden" name="command" value="jobs:auto-complete-overdue">
                            <button type="submit"
                                class="w-full px-4 py-2 bg-purple-600 text-white text-sm font-bold rounded-lg hover:bg-purple-700 transition-colors">
                                Run Command
                            </button>
                        </form>
                        <code
                            class="block mt-3 text-[10px] text-gray-400 bg-gray-50 px-2 py-1 rounded">php artisan jobs:auto-complete-overdue</code>
                    </div>
                </div>
            </div>

            <!-- Update Schedule Statuses -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow">
                <div class="flex items-start gap-4">
                    <div class="flex-shrink-0 w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                    </div>
                    <div class="flex-1">
                        <h3 class="font-bold text-gray-900 mb-1">Update Schedule Statuses</h3>
                        <p class="text-xs text-gray-500 mb-4">Update schedule statuses based on current date/time</p>
                        <form action="{{ route('developer.run-command') }}" method="POST">
                            @csrf
                            <input type="hidden" name="command" value="app:update-schedule-statuses">
                            <button type="submit"
                                class="w-full px-4 py-2 bg-blue-600 text-white text-sm font-bold rounded-lg hover:bg-blue-700 transition-colors">
                                Run Command
                            </button>
                        </form>
                        <code
                            class="block mt-3 text-[10px] text-gray-400 bg-gray-50 px-2 py-1 rounded">php artisan app:update-schedule-statuses</code>
                    </div>
                </div>
            </div>

            <!-- Clear Cache -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow">
                <div class="flex items-start gap-4">
                    <div class="flex-shrink-0 w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                        </svg>
                    </div>
                    <div class="flex-1">
                        <h3 class="font-bold text-gray-900 mb-1">Clear Application Cache</h3>
                        <p class="text-xs text-gray-500 mb-4">Clear all cached data to refresh the application</p>
                        <form action="{{ route('developer.run-command') }}" method="POST">
                            @csrf
                            <input type="hidden" name="command" value="cache:clear">
                            <button type="submit"
                                class="w-full px-4 py-2 bg-orange-600 text-white text-sm font-bold rounded-lg hover:bg-orange-700 transition-colors">
                                Run Command
                            </button>
                        </form>
                        <code
                            class="block mt-3 text-[10px] text-gray-400 bg-gray-50 px-2 py-1 rounded">php artisan cache:clear</code>
                    </div>
                </div>
            </div>

            <!-- Clear Config -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow">
                <div class="flex items-start gap-4">
                    <div class="flex-shrink-0 w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                    </div>
                    <div class="flex-1">
                        <h3 class="font-bold text-gray-900 mb-1">Clear Config Cache</h3>
                        <p class="text-xs text-gray-500 mb-4">Clear configuration cache to reload settings</p>
                        <form action="{{ route('developer.run-command') }}" method="POST">
                            @csrf
                            <input type="hidden" name="command" value="config:clear">
                            <button type="submit"
                                class="w-full px-4 py-2 bg-green-600 text-white text-sm font-bold rounded-lg hover:bg-green-700 transition-colors">
                                Run Command
                            </button>
                        </form>
                        <code
                            class="block mt-3 text-[10px] text-gray-400 bg-gray-50 px-2 py-1 rounded">php artisan config:clear</code>
                    </div>
                </div>
            </div>

            <!-- Clear Routes -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow">
                <div class="flex items-start gap-4">
                    <div class="flex-shrink-0 w-12 h-12 bg-indigo-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7" />
                        </svg>
                    </div>
                    <div class="flex-1">
                        <h3 class="font-bold text-gray-900 mb-1">Clear Route Cache</h3>
                        <p class="text-xs text-gray-500 mb-4">Clear route cache to reload routing definitions</p>
                        <form action="{{ route('developer.run-command') }}" method="POST">
                            @csrf
                            <input type="hidden" name="command" value="route:clear">
                            <button type="submit"
                                class="w-full px-4 py-2 bg-indigo-600 text-white text-sm font-bold rounded-lg hover:bg-indigo-700 transition-colors">
                                Run Command
                            </button>
                        </form>
                        <code
                            class="block mt-3 text-[10px] text-gray-400 bg-gray-50 px-2 py-1 rounded">php artisan route:clear</code>
                    </div>
                </div>
            </div>

            <!-- Clear Views -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow">
                <div class="flex items-start gap-4">
                    <div class="flex-shrink-0 w-12 h-12 bg-pink-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-pink-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                        </svg>
                    </div>
                    <div class="flex-1">
                        <h3 class="font-bold text-gray-900 mb-1">Clear View Cache</h3>
                        <p class="text-xs text-gray-500 mb-4">Clear compiled view files to refresh templates</p>
                        <form action="{{ route('developer.run-command') }}" method="POST">
                            @csrf
                            <input type="hidden" name="command" value="view:clear">
                            <button type="submit"
                                class="w-full px-4 py-2 bg-pink-600 text-white text-sm font-bold rounded-lg hover:bg-pink-700 transition-colors">
                                Run Command
                            </button>
                        </form>
                        <code
                            class="block mt-3 text-[10px] text-gray-400 bg-gray-50 px-2 py-1 rounded">php artisan view:clear</code>
                    </div>
                </div>
            </div>

        </div>

        <!-- Warning Notice -->
        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
            <div class="flex gap-3">
                <svg class="w-5 h-5 text-yellow-600 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd"
                        d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z"
                        clip-rule="evenodd" />
                </svg>
                <div>
                    <h4 class="font-bold text-yellow-900 text-sm">Developer Access Only</h4>
                    <p class="text-xs text-yellow-700 mt-1">These commands should only be executed by authorized developers.
                        Use with caution as they can affect system performance and data.</p>
                </div>
            </div>
        </div>
    </div>
@endsection