<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Active Guards Report</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 11px;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #1e293b;
            padding-bottom: 10px;
        }

        .header h1 {
            margin: 0;
            font-size: 20px;
            color: #1e293b;
        }

        .header p {
            margin: 5px 0 0 0;
            font-size: 10px;
            color: #64748b;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th {
            background-color: #f1f5f9;
            color: #1e293b;
            font-weight: bold;
            padding: 8px;
            text-align: left;
            border: 1px solid #cbd5e1;
            font-size: 10px;
        }

        td {
            padding: 7px 8px;
            border: 1px solid #e2e8f0;
            font-size: 10px;
        }

        tr:nth-child(even) {
            background-color: #f8fafc;
        }

        .badge {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
        }

        .badge-static {
            background-color: #dbeafe;
            color: #1e40af;
        }

        .badge-patrol {
            background-color: #e9d5ff;
            color: #6b21a8;
        }

        .overdue {
            color: #dc2626;
            font-weight: bold;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 9px;
            color: #94a3b8;
            border-top: 1px solid #e2e8f0;
            padding-top: 10px;
        }

        .no-data {
            text-align: center;
            padding: 40px;
            color: #94a3b8;
            font-style: italic;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Active Guards Report</h1>
        <p>{{ $company->name }} | Generated: {{ $now->format('F d, Y - H:i') }}</p>
    </div>

    @if($activeGuards->isEmpty())
        <div class="no-data">
            No active guards at this time.
        </div>
    @else
        <table>
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Guard Name</th>
                    <th>Site/Route</th>
                    <th>Shift Time</th>
                    <th>Hours</th>
                    <th>Check-in</th>
                    <th>Last Called</th>
                    <th>Next Call</th>
                    <th>Phone</th>
                </tr>
            </thead>
            <tbody>
                @foreach($activeGuards as $guard)
                    <tr>
                        <td>
                            <span class="badge {{ $guard->type === 'static' ? 'badge-static' : 'badge-patrol' }}">
                                {{ ucfirst($guard->type) }}
                            </span>
                        </td>
                        <td><strong>{{ $guard->employee->first_name }} {{ $guard->employee->last_name }}</strong></td>
                        <td>{{ $guard->site_name }}</td>
                        <td>{{ $guard->schedule_time }}</td>
                        <td>{{ $guard->total_hours }} hrs</td>
                        <td>{{ $guard->checkin_time }}</td>
                        <td>{{ $guard->last_call }}</td>
                        <td class="{{ $guard->next_call_is_overdue ? 'overdue' : '' }}">
                            {{ $guard->next_call }}
                        </td>
                        <td>{{ $guard->phone }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif

    <div class="footer">
        <p>This report contains {{ $activeGuards->count() }} active guard(s)</p>
        <p>Customer Care System | {{ config('app.name') }}</p>
    </div>
</body>

</html>