<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Select Company - {{ config('app.name', 'Laravel') }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="bg-gray-100 font-sans antialiased text-gray-900">

    <div class="min-h-screen flex items-center justify-center bg-gray-100 py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full space-y-8 bg-white p-10 rounded-xl shadow-2xl relative">
            <div class="absolute -top-12 left-1/2 transform -translate-x-1/2 p-4 bg-blue-600 rounded-full shadow-lg">
                <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                    </path>
                </svg>
            </div>

            <div>
                <h2 class="mt-6 text-center text-3xl font-extrabold text-gray-900">
                    Select Company
                </h2>
                <p class="mt-2 text-center text-sm text-gray-600">
                    Please choose a company to continue
                </p>
            </div>

            <form class="mt-8 space-y-6" action="{{ route('select.company.store') }}" method="POST">
                @csrf
                <div class="rounded-md shadow-sm -space-y-px">
                    <div class="space-y-4">
                        @foreach($companies as $company)
                            <div
                                class="relative flex items-start p-4 border border-gray-200 rounded-lg hover:border-blue-500 hover:bg-blue-50 cursor-pointer transition-all">
                                <div class="flex items-center h-5">
                                    <input id="company_{{ $company->id }}" name="company_id" type="radio"
                                        value="{{ $company->id }}" required
                                        class="focus:ring-blue-500 h-4 w-4 text-blue-600 border-gray-300">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="company_{{ $company->id }}"
                                        class="font-medium text-gray-700 cursor-pointer w-full block">
                                        {{ $company->name }}
                                    </label>
                                    @if($company->tagline)
                                        <p class="text-gray-500 text-xs">{{ $company->tagline }}</p>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                @if ($errors->any())
                    <div class="text-red-500 text-sm text-center">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div>
                    <button type="submit"
                        class="group relative w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 shadow-md">
                        <span class="absolute left-0 inset-y-0 flex items-center pl-3">
                            <svg class="h-5 w-5 text-blue-500 group-hover:text-blue-400"
                                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"
                                aria-hidden="true">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                        Continue to Dashboard
                    </button>
                </div>

                <div class="text-center">
                    <form method="POST" action="{{ route('logout') }}" class="inline">
                        @csrf
                        <button type="submit" class="text-sm text-gray-500 hover:text-gray-900 underline">
                            Logout
                        </button>
                    </form>
                </div>
            </form>
        </div>
    </div>
</body>

</html>