@extends('layouts.admin')

@section('title', 'Uniform Inventory')
@section('page_title', 'Complete Inventory')

@section('content')
    <div class="max-w-7xl mx-auto">
        <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4">
            <div>
                <h1 class="text-3xl font-black text-slate-900 tracking-tight">Complete Inventory</h1>
                <p class="text-slate-500 font-bold mt-1">Detailed view of all uniform variants and stock levels.</p>
            </div>
            <div class="flex gap-4">
                <a href="{{ route('admin.uniforms.index') }}"
                    class="px-6 py-3 bg-white border border-gray-200 text-slate-600 font-bold rounded-xl hover:bg-gray-50 transition-all shadow-sm flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 6h16M4 10h16M4 14h16M4 18h16" />
                    </svg>
                    View by Type
                </a>
                @can('create uniform')
                    <a href="{{ route('admin.uniforms.create') }}"
                        class="px-6 py-3 bg-blue-600 text-white font-bold rounded-xl shadow-lg shadow-blue-500/30 hover:bg-blue-700 transition-all flex items-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                        </svg>
                        Add Inventory
                    </a>
                @endcan
            </div>
        </div>

        <div class="bg-white rounded-3xl border border-gray-100 shadow-xl overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr
                            class="bg-slate-50 border-b border-gray-100 text-xs uppercase tracking-widest text-slate-500 font-black">
                            <th class="px-8 py-6">Uniform</th>
                            <th class="px-8 py-6">Code</th>
                            <th class="px-8 py-6">Variant (Size / Color)</th>
                            <th class="px-8 py-6 text-right">Stock Level</th>
                            <th class="px-8 py-6 text-right">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-50">
                        @forelse($inventory as $item)
                            <tr class="hover:bg-blue-50/50 transition-colors group">
                                <td class="px-8 py-5">
                                    <div class="font-bold text-slate-900">{{ $item->uniform->name }}</div>
                                </td>
                                <td class="px-8 py-5">
                                    @if($item->uniform->code)
                                        <span
                                            class="bg-slate-100 text-slate-600 px-2 py-1 rounded text-xs font-bold font-mono border border-slate-200">{{ $item->uniform->code }}</span>
                                    @else
                                        <span class="text-slate-300 text-xs font-bold italic">-</span>
                                    @endif
                                </td>
                                <td class="px-8 py-5">
                                    <div class="text-sm font-bold text-slate-700 flex items-center gap-2">
                                        @if($item->color)
                                            <span class="w-3 h-3 rounded-full border border-gray-200"
                                                style="background-color: {{ strtolower($item->color) }}"></span>
                                            {{ $item->color }}
                                        @endif
                                        @if($item->size && $item->color)
                                            <span class="text-slate-300">/</span>
                                        @endif
                                        @if($item->size)
                                            <span
                                                class="bg-gray-100 text-gray-700 px-2 py-0.5 rounded text-xs">{{ $item->size }}</span>
                                        @endif

                                        @if(!$item->size && !$item->color)
                                            <span class="text-slate-400 italic font-normal">Base Item</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-8 py-5 text-right">
                                    <span
                                        class="font-bold {{ $item->stock_quantity == 0 ? 'text-red-600' : 'text-slate-900' }}">
                                        {{ $item->stock_quantity }}
                                    </span>
                                </td>
                                <td class="px-8 py-5 text-right">
                                    @if($item->active)
                                        <span
                                            class="text-xs font-bold text-green-600 bg-green-50 px-2 py-1 rounded-lg">Active</span>
                                    @else
                                        <span
                                            class="text-xs font-bold text-gray-400 bg-gray-50 px-2 py-1 rounded-lg">Inactive</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-8 py-16 text-center">
                                    <div
                                        class="w-16 h-16 bg-slate-50 rounded-2xl flex items-center justify-center mx-auto mb-4">
                                        <svg class="w-8 h-8 text-slate-300" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                                        </svg>
                                    </div>
                                    <h3 class="text-lg font-bold text-slate-900">Inventory Empty</h3>
                                    <p class="text-slate-500 mt-1">No items found in inventory.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection