@extends('layouts.admin')

@section('title', 'Add Time Zone')
@section('page_title', 'Time Zones')

@section('content')
<div class="mb-6 flex items-center gap-4">
    <a href="{{ route('admin.time-zones.index') }}" class="p-2 text-gray-400 hover:text-gray-900 hover:bg-gray-100 rounded-xl transition-all">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
    </a>
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Add Time Zone</h1>
        <p class="text-gray-500 text-sm">Create a new time zone master record.</p>
    </div>
</div>

<div class="max-w-2xl">
    <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-8">
        <form action="{{ route('admin.time-zones.store') }}" method="POST" class="space-y-6">
            @csrf
            <div>
                <label for="name" class="block text-sm font-semibold text-gray-700 mb-2">Time Zone Name</label>
                <input type="text" id="name" name="name" value="{{ old('name') }}" required 
                    class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900 @error('name') border-red-500 @enderror"
                    placeholder="e.g. Asia/Kolkata (GMT +5:30)">
                @error('name')
                    <p class="mt-1 text-xs text-red-500 font-medium">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="flex items-center gap-3 cursor-pointer group">
                    <input type="hidden" name="active" value="0">
                    <input type="checkbox" name="active" value="1" {{ old('active', true) ? 'checked' : '' }}
                        class="w-5 h-5 rounded-lg border-gray-300 text-blue-600 focus:ring-blue-500/20 transition-all cursor-pointer">
                    <span class="text-sm font-semibold text-gray-700 group-hover:text-gray-900 transition-colors">Is Active</span>
                </label>
            </div>

            <div class="pt-4 flex items-center gap-4">
                <button type="submit" 
                    class="bg-blue-600 text-white font-bold px-8 py-3.5 rounded-xl hover:bg-blue-700 transform transition-all active:scale-[0.98] shadow-lg shadow-blue-200">
                    Save Time Zone
                </button>
                <a href="{{ route('admin.time-zones.index') }}" 
                    class="text-gray-500 font-bold px-8 py-3.5 rounded-xl hover:text-gray-900 transition-all">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
