@extends('layouts.admin')

@section('title', 'Add State / Province')
@section('page_title', 'Add State / Province')

@section('content')
<div class="mb-6">
    <a href="{{ route('admin.states.index') }}" class="inline-flex items-center gap-2 text-gray-500 hover:text-blue-600 transition-colors group">
        <svg class="w-5 h-5 transition-transform group-hover:-translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg>
        Back to States
    </a>
</div>

<div class="max-w-2xl">
    <form action="{{ route('admin.states.store') }}" method="POST" class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden">
        @csrf
        <div class="p-8 border-b border-gray-50">
            <h2 class="text-xl font-bold text-gray-900">State Details</h2>
            <p class="text-gray-500 text-sm">Create a new state or province associated with a country.</p>
        </div>

        <div class="p-8 space-y-6">
            <div class="relative">
                <label for="country_search" class="block text-sm font-bold text-gray-700 mb-2">Select Country</label>
                <div class="group relative">
                    <input type="text" id="country_search" 
                        class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none"
                        placeholder="Type to search country..." autocomplete="off">
                    <div class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-400">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                    </div>
                </div>
                <input type="hidden" name="country_id" id="country_id" value="{{ old('country_id') }}">
                @error('country_id') <p class="mt-2 text-sm text-red-600">{{ $message }}</p> @enderror
            </div>

            <div>
                <label for="name" class="block text-sm font-bold text-gray-700 mb-2">State / Province Name</label>
                <input type="text" name="name" id="name" value="{{ old('name') }}" required
                    class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none"
                    placeholder="e.g. California">
                @error('name') <p class="mt-2 text-sm text-red-600">{{ $message }}</p> @enderror
            </div>

            <div>
                <label for="code" class="block text-sm font-bold text-gray-700 mb-2">State Code (Optional)</label>
                <input type="text" name="code" id="code" value="{{ old('code') }}"
                    class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none"
                    placeholder="e.g. CA">
                @error('code') <p class="mt-2 text-sm text-red-600">{{ $message }}</p> @enderror
            </div>

            <div class="flex items-center gap-3 p-4 bg-gray-50 rounded-xl">
                <input type="checkbox" name="active" id="active" value="1" {{ old('active', true) ? 'checked' : '' }}
                    class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                <label for="active" class="text-sm font-bold text-gray-700">State is Active</label>
            </div>
        </div>

        <div class="p-8 bg-gray-50/50 border-t border-gray-50 flex justify-end gap-4">
            <a href="{{ route('admin.states.index') }}" class="px-6 py-3 text-gray-600 font-bold hover:text-gray-900 transition-colors">Cancel</a>
            <button type="submit" class="bg-blue-600 text-white px-8 py-3 rounded-xl font-bold hover:bg-blue-700 transition-all shadow-lg shadow-blue-100">
                Create State
            </button>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tarekraafat/autocomplete.js@10.2.7/dist/css/autoComplete.02.min.css">
<script src="https://cdn.jsdelivr.net/npm/@tarekraafat/autocomplete.js@10.2.7/dist/autoComplete.min.js"></script>
<style>
    .autoComplete_wrapper { width: 100%; }
    .autoComplete_wrapper > input { 
        width: 100%;
        background-color: #F9FAFB;
        border: 1px solid #E5E7EB;
        border-radius: 0.75rem;
        padding: 0.75rem 1rem;
    }
    .autoComplete_wrapper > input:focus {
        border-color: #3B82F6;
        box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.1);
    }
    .autoComplete_wrapper > ul {
        border-radius: 1rem;
        border: 1px solid #F3F4F6;
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
        margin-top: 5px;
        padding: 5px;
    }
    .autoComplete_wrapper > ul > li {
        border-radius: 0.5rem;
        padding: 10px 15px;
        font-weight: 500;
        font-size: 0.875rem;
    }
    .autoComplete_wrapper > ul > li:hover { background-color: #EFF6FF; color: #1D4ED8; }
    .autoComplete_wrapper > ul > li mark { color: #2563EB; font-weight: 700; background: transparent; padding: 0; }
</style>

<script>
    const countries = @json($countries->map(fn($c) => ['id' => $c->id, 'name' => $c->name]));
    
    const autoCompleteJS = new autoComplete({
        selector: "#country_search",
        placeHolder: "Search for a country...",
        data: {
            src: countries,
            keys: ["name"]
        },
        resultsList: {
            element: (list, data) => {
                if (!data.results.length) {
                    const message = document.createElement("div");
                    message.setAttribute("class", "no_result px-4 py-2 text-gray-500 italic text-sm");
                    message.innerHTML = `<span>Found No Results for "${data.query}"</span>`;
                    list.prepend(message);
                }
            },
            noResults: true,
        },
        resultItem: {
            highlight: true
        },
        events: {
            input: {
                selection: (event) => {
                    const selection = event.detail.selection.value;
                    autoCompleteJS.input.value = selection.name;
                    document.getElementById('country_id').value = selection.id;
                }
            }
        }
    });

    // If pre-selected (old input)
    const oldId = document.getElementById('country_id').value;
    if (oldId) {
        const country = countries.find(c => c.id == oldId);
        if (country) autoCompleteJS.input.value = country.name;
    }
</script>
@endpush
