@extends('layouts.admin')

@section('title', 'Change Password')
@section('page_title', 'Security Settings')

@section('content')
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Change Password</h1>
        <p class="text-gray-500 text-sm mt-1">Update your administrator password regularly to keep your account secure.</p>
    </div>

    @if(session('success'))
        <div class="mb-6 p-4 bg-green-50 border border-green-100 text-green-700 rounded-lg flex items-center gap-3">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
            {{ session('success') }}
        </div>
    @endif

    <div class="max-w-xl">
        <form action="{{ route('admin.settings.password.update') }}" method="POST">
            @csrf

            <div class="bg-white rounded-lg border border-gray-100 shadow-sm overflow-hidden">
                <div class="p-6 space-y-6">
                    <!-- Current Password -->
                    <div>
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Current Password</label>
                        <div class="relative group">
                            <input type="password" name="current_password" id="current_password" required
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                            <button type="button" onclick="togglePassword('current_password')"
                                class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                </svg>
                            </button>
                        </div>
                        @error('current_password')
                            <p class="mt-2 text-xs text-red-500 font-medium">{{ $message }}</p>
                        @enderror
                    </div>

                    <hr class="border-gray-100">

                    <!-- New Password -->
                    <div>
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">New Password</label>
                        <div class="relative group">
                            <input type="password" name="password" id="password_input" required
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                            <button type="button" onclick="togglePassword('password_input')"
                                class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                </svg>
                            </button>
                        </div>
                        <div class="mt-3">
                            <div class="flex items-center justify-between mb-2">
                                <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Strength</span>
                                <span id="strength-text" class="text-xs font-bold text-gray-400">Wait...</span>
                            </div>
                            <div class="h-1.5 w-full bg-gray-100 rounded-full overflow-hidden">
                                <div id="strength-bar" class="h-full w-0 transition-all duration-500"></div>
                            </div>
                            <div class="mt-4 space-y-2">
                                <div id="rule-min-length" class="flex items-center gap-2 text-xs font-medium text-gray-400">
                                    <div
                                        class="w-4 h-4 rounded-full border border-gray-200 flex items-center justify-center transition-all bg-white">
                                        <svg class="w-2.5 h-2.5 text-white" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                                d="M5 13l4 4L19 7"></path>
                                        </svg>
                                    </div>
                                    At least 8 characters
                                </div>
                                <div id="rule-mixed-case" class="flex items-center gap-2 text-xs font-medium text-gray-400">
                                    <div
                                        class="w-4 h-4 rounded-full border border-gray-200 flex items-center justify-center transition-all bg-white">
                                        <svg class="w-2.5 h-2.5 text-white" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                                d="M5 13l4 4L19 7"></path>
                                        </svg>
                                    </div>
                                    Uppercase & lowercase
                                </div>
                                <div id="rule-number" class="flex items-center gap-2 text-xs font-medium text-gray-400">
                                    <div
                                        class="w-4 h-4 rounded-full border border-gray-200 flex items-center justify-center transition-all bg-white">
                                        <svg class="w-2.5 h-2.5 text-white" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                                d="M5 13l4 4L19 7"></path>
                                        </svg>
                                    </div>
                                    At least one number
                                </div>
                                <div id="rule-symbol" class="flex items-center gap-2 text-xs font-medium text-gray-400">
                                    <div
                                        class="w-4 h-4 rounded-full border border-gray-200 flex items-center justify-center transition-all bg-white">
                                        <svg class="w-2.5 h-2.5 text-white" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                                d="M5 13l4 4L19 7"></path>
                                        </svg>
                                    </div>
                                    At least one special character
                                </div>
                            </div>
                        </div>
                        @error('password')
                            <p class="mt-2 text-xs text-red-500 font-medium">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Confirm Password -->
                    <div>
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Confirm New Password</label>
                        <div class="relative group">
                            <input type="password" name="password_confirmation" id="password_confirmation" required
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                            <button type="button" onclick="togglePassword('password_confirmation')"
                                class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 flex items-center justify-end gap-3">
                    <a href="{{ route('admin.dashboard') }}"
                        class="px-4 py-2 rounded-md border border-gray-300 text-gray-700 font-bold hover:bg-white text-sm transition-all shadow-sm">Cancel</a>
                    <button type="submit"
                        class="px-6 py-2 bg-blue-600 text-white rounded-md font-bold hover:bg-blue-700 transition-all shadow-sm text-sm">Update
                        Password</button>
                </div>
            </div>
        </form>
    </div>

    @push('scripts')
        <script>
            const passwordInput = document.getElementById('password_input');
            const strengthBar = document.getElementById('strength-bar');
            const strengthText = document.getElementById('strength-text');

            // Rules
            const rules = {
                minLength: document.getElementById('rule-min-length'),
                mixedCase: document.getElementById('rule-mixed-case'),
                number: document.getElementById('rule-number'),
                symbol: document.getElementById('rule-symbol')
            };

            passwordInput.addEventListener('input', function () {
                const val = this.value;
                let score = 0;

                const checks = {
                    minLength: val.length >= 8,
                    mixedCase: /[a-z]/.test(val) && /[A-Z]/.test(val),
                    number: /\d/.test(val),
                    symbol: /[^A-Za-z0-9]/.test(val)
                };

                // Update Rule Icons
                Object.keys(checks).forEach(key => {
                    const circle = rules[key].querySelector('div');
                    if (checks[key]) {
                        circle.classList.remove('border-gray-200', 'bg-white');
                        circle.classList.add('border-emerald-500', 'bg-emerald-500');
                        rules[key].classList.remove('text-gray-400');
                        rules[key].classList.add('text-gray-900');
                        score++;
                    } else {
                        circle.classList.add('border-gray-200', 'bg-white');
                        circle.classList.remove('border-emerald-500', 'bg-emerald-500');
                        rules[key].classList.add('text-gray-400');
                        rules[key].classList.remove('text-gray-900');
                    }
                });

                // Update Strength Bar & Text
                const percent = (score / 4) * 100;
                strengthBar.style.width = percent + '%';

                if (score === 0) {
                    strengthBar.className = 'h-full w-0 transition-all duration-500';
                    strengthText.innerText = 'Weak';
                    strengthText.className = 'text-xs font-bold text-gray-400';
                } else if (score <= 2) {
                    strengthBar.className = 'h-full w-0 transition-all duration-500 bg-red-500';
                    strengthText.innerText = 'Weak';
                    strengthText.className = 'text-xs font-bold text-red-500';
                } else if (score === 3) {
                    strengthBar.className = 'h-full w-0 transition-all duration-500 bg-amber-500';
                    strengthText.innerText = 'Moderate';
                    strengthText.className = 'text-xs font-bold text-amber-500';
                } else {
                    strengthBar.className = 'h-full w-0 transition-all duration-500 bg-emerald-500';
                    strengthText.innerText = 'Strong';
                    strengthText.className = 'text-xs font-bold text-emerald-500';
                }
            });
        </script>
        <script>
            function togglePassword(inputId) {
                const input = document.getElementById(inputId);
                if (input.type === "password") {
                    input.type = "text";
                } else {
                    input.type = "password";
                }
            }
        </script>
    @endpush
@endsection