@extends('layouts.admin')

@section('title', 'Integration Settings')

@section('content')
    <div class="mb-6 flex flex-col md:flex-row md:items-end justify-between gap-4">
        <div>
            <h1 class="text-2xl font-bold text-gray-800">Integration Settings</h1>
            <p class="text-xs text-gray-500 mt-1">Configure Google Firebase, Mailgun and General SMTP settings.</p>
        </div>
        <div class="flex gap-2">
            <button type="button" onclick="if(confirm('Fill SMTP fields with dummy data for testing?')) { 
                                document.getElementById('mail_from_address').value = 'no-reply@dummy-test.com';
                                document.getElementById('mail_from_name').value = 'Guard New Support';
                                document.getElementById('mail_host').value = 'smtp.dummy.io';
                                document.getElementById('mail_port').value = '587';
                                document.getElementById('mail_username').value = 'dummy_user_123';
                                document.getElementById('mail_password').value = '********';
                                document.getElementById('mail_encryption').value = 'tls';
                            }"
                class="px-4 py-2 bg-gray-100 text-gray-700 text-xs font-bold rounded-md hover:bg-gray-200 transition-all flex items-center gap-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z">
                    </path>
                </svg>
                Load Dummy SMTP Data
            </button>
        </div>
    </div>

    @if(session('success'))
        <div class="mb-6 p-4 bg-green-50 border border-green-100 text-green-700 rounded-lg flex items-center gap-3">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
            {{ session('success') }}
        </div>
    @endif

    <div x-data="{ tab: '{{ session('active_tab', 'firebase') }}' }"
        class="bg-white rounded-lg border border-gray-100 shadow-sm overflow-hidden" x-cloak>
        <!-- Tabs Navigation -->
        <div class="flex p-2 bg-gray-50/50 border-b border-gray-100 gap-1">
            <button @click="tab = 'firebase'"
                :class="tab === 'firebase' ? 'bg-white text-blue-600 shadow-sm ring-1 ring-gray-100' : 'text-gray-500 hover:text-gray-800 hover:bg-gray-100/50'"
                class="flex-1 flex items-center justify-center gap-2 px-6 py-3 text-sm font-bold rounded-md transition-all">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9">
                    </path>
                </svg>
                Google Firebase
            </button>
            <button @click="tab = 'mailgun'"
                :class="tab === 'mailgun' ? 'bg-white text-blue-600 shadow-sm ring-1 ring-gray-100' : 'text-gray-500 hover:text-gray-800 hover:bg-gray-100/50'"
                class="flex-1 flex items-center justify-center gap-2 px-6 py-3 text-sm font-bold rounded-md transition-all">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                    </path>
                </svg>
                Mailgun API
            </button>
            <button @click="tab = 'smtp'"
                :class="tab === 'smtp' ? 'bg-white text-blue-600 shadow-sm ring-1 ring-gray-100' : 'text-gray-500 hover:text-gray-800 hover:bg-gray-100/50'"
                class="flex-1 flex items-center justify-center gap-2 px-6 py-3 text-sm font-bold rounded-md transition-all">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                </svg>
                General SMTP
            </button>
            <button @click="tab = 'recaptcha'"
                :class="tab === 'recaptcha' ? 'bg-white text-blue-600 shadow-sm ring-1 ring-gray-100' : 'text-gray-500 hover:text-gray-800 hover:bg-gray-100/50'"
                class="flex-1 flex items-center justify-center gap-2 px-6 py-3 text-sm font-bold rounded-md transition-all">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                </svg>
                Google reCAPTCHA
            </button>
            <button @click="tab = '2fa'"
                :class="tab === '2fa' ? 'bg-white text-blue-600 shadow-sm ring-1 ring-gray-100' : 'text-gray-500 hover:text-gray-800 hover:bg-gray-100/50'"
                class="flex-1 flex items-center justify-center gap-2 px-6 py-3 text-sm font-bold rounded-md transition-all">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                </svg>
                Google Authenticator
            </button>
        </div>

        <div class="p-6">
            <!-- Firebase Tab -->
            <div x-show="tab === 'firebase'" class="space-y-6 animate-in fade-in duration-300">
                <form action="{{ route('admin.settings.integrations.update') }}" method="POST">
                    @csrf
                    <input type="hidden" name="tab" value="firebase">
                    <h3 class="text-sm font-bold text-gray-800 border-l-4 border-blue-600 pl-3 mb-6">FCM Credentials</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="md:col-span-2">
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Service Account JSON (FCM V1)</label>
                            <textarea name="firebase_service_account_json" rows="8"
                                class="w-full px-3 py-2 text-xs border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all font-mono"
                                placeholder="{ 'type': 'service_account', 'project_id': '...' }">{{ $settings['firebase_service_account_json'] ?? '' }}</textarea>
                                <p class="text-[10px] text-gray-400 mt-1">Paste the full content of your Firebase Service Account JSON file here. This is required for HTTP v1 API.</p>
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">API Key</label>
                            <input type="text" name="firebase_api_key" value="{{ $settings['firebase_api_key'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all font-mono">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Auth Domain</label>
                            <input type="text" name="firebase_auth_domain"
                                value="{{ $settings['firebase_auth_domain'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Project ID</label>
                            <input type="text" name="firebase_project_id"
                                value="{{ $settings['firebase_project_id'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Storage Bucket</label>
                            <input type="text" name="firebase_storage_bucket"
                                value="{{ $settings['firebase_storage_bucket'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Sender ID</label>
                            <input type="text" name="firebase_messaging_sender_id"
                                value="{{ $settings['firebase_messaging_sender_id'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">App ID</label>
                            <input type="text" name="firebase_app_id" value="{{ $settings['firebase_app_id'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all font-mono">
                        </div>
                    </div>
                    <div class="mt-8 flex justify-end">
                        <button type="submit"
                            class="px-6 py-2 bg-blue-600 text-white font-bold rounded-md hover:bg-blue-700 shadow-sm transition-all text-sm">Save
                            Firebase Settings</button>
                    </div>
                </form>
            </div>

            <!-- Mailgun Tab -->
            <div x-show="tab === 'mailgun'" class="space-y-6 animate-in fade-in duration-300">
                <form action="{{ route('admin.settings.integrations.update') }}" method="POST">
                    @csrf
                    <input type="hidden" name="tab" value="mailgun">
                    <h3 class="text-sm font-bold text-gray-800 border-l-4 border-emerald-500 pl-3 mb-6">Mailgun API Gateway
                    </h3>
                    <div class="grid grid-cols-1 gap-6 max-w-2xl">
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Mailgun Domain</label>
                            <input type="text" name="mailgun_domain" value="{{ $settings['mailgun_domain'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-emerald-500/20 focus:border-emerald-500 transition-all"
                                placeholder="mg.domain.com">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Mailgun Secret
                                Key</label>
                            <input type="password" name="mailgun_secret" value="{{ $settings['mailgun_secret'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-emerald-500/20 focus:border-emerald-500 transition-all font-mono">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">API Endpoint</label>
                            <select name="mailgun_endpoint"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-emerald-500/20 focus:border-emerald-500 transition-all">
                                <option value="api.mailgun.net" {{ ($settings['mailgun_endpoint'] ?? '') == 'api.mailgun.net' ? 'selected' : '' }}>United States (api.mailgun.net)</option>
                                <option value="api.eu.mailgun.net" {{ ($settings['mailgun_endpoint'] ?? '') == 'api.eu.mailgun.net' ? 'selected' : '' }}>European Union (api.eu.mailgun.net)
                                </option>
                            </select>
                        </div>
                    </div>
                    <div class="mt-8 flex justify-end">
                        <button type="submit"
                            class="px-6 py-2 bg-emerald-600 text-white font-bold rounded-md hover:bg-emerald-700 shadow-sm transition-all text-sm">Save
                            Mailgun Settings</button>
                    </div>
                </form>
            </div>

            <!-- SMTP Tab -->
            <div x-show="tab === 'smtp'" class="space-y-6 animate-in fade-in duration-300">
                <form action="{{ route('admin.settings.integrations.update') }}" method="POST">
                    @csrf
                    <input type="hidden" name="tab" value="smtp">
                    <h3 class="text-sm font-bold text-gray-800 border-l-4 border-orange-500 pl-3 mb-6">Default Email Sender
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">From Email
                                Address</label>
                            <input type="email" name="mail_from_address" id="mail_from_address"
                                value="{{ $settings['mail_from_address'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">From Display
                                Name</label>
                            <input type="text" name="mail_from_name" id="mail_from_name"
                                value="{{ $settings['mail_from_name'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all">
                        </div>
                    </div>

                    <h3 class="text-sm font-bold text-gray-800 border-l-4 border-orange-500 pl-3 mb-6">SMTP Server Config
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div class="md:col-span-2">
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">SMTP Host</label>
                            <input type="text" name="mail_host" id="mail_host" value="{{ $settings['mail_host'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Port</label>
                            <input type="text" name="mail_port" id="mail_port" value="{{ $settings['mail_port'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Username</label>
                            <input type="text" name="mail_username" id="mail_username"
                                value="{{ $settings['mail_username'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Password</label>
                            <input type="password" name="mail_password" id="mail_password"
                                value="{{ $settings['mail_password'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all font-mono">
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Encryption</label>
                            <select name="mail_encryption" id="mail_encryption"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all">
                                <option value="tls" {{ ($settings['mail_encryption'] ?? '') == 'tls' ? 'selected' : '' }}>
                                    TLS</option>
                                <option value="ssl" {{ ($settings['mail_encryption'] ?? '') == 'ssl' ? 'selected' : '' }}>
                                    SSL</option>
                                <option value="none" {{ ($settings['mail_encryption'] ?? '') == 'none' ? 'selected' : '' }}>
                                    None</option>
                            </select>
                        </div>
                    </div>
                    <div class="mt-8 flex justify-end">
                        <button type="submit"
                            class="px-6 py-2 bg-orange-600 text-white font-bold rounded-md hover:bg-orange-700 shadow-sm transition-all text-sm">Save
                            SMTP Settings</button>
                    </div>
                </form>
            </div>

            <!-- Google reCAPTCHA Tab -->
            <div x-show="tab === 'recaptcha'" class="space-y-6 animate-in fade-in duration-300">
                <form action="{{ route('admin.settings.integrations.update') }}" method="POST">
                    @csrf
                    <input type="hidden" name="tab" value="recaptcha">
                    <h3 class="text-sm font-bold text-gray-800 border-l-4 border-blue-600 pl-3 mb-6">Google reCAPTCHA v2/v3
                    </h3>
                    <div class="grid grid-cols-1 gap-6 max-w-2xl">
                        <div class="flex items-center gap-2 mb-4">
                            <input type="checkbox" name="recaptcha_enabled" id="recaptcha_enabled" value="1"
                                {{ ($settings['recaptcha_enabled'] ?? '0') == '1' ? 'checked' : '' }}
                                class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                            <label for="recaptcha_enabled" class="text-sm font-semibold text-gray-700">Enable Google reCAPTCHA</label>
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Site Key (v2 Checkbox)</label>
                            <input type="text" name="recaptcha_site_key" value="{{ $settings['recaptcha_site_key'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all font-mono">
                            <p class="text-xs text-gray-400 mt-1">Please ensure you generate <strong>reCAPTCHA v2 ("I'm not a robot" Checkbox)</strong> keys from the Google Admin Console. v3 keys will invalid type error.</p>
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Secret Key (v2 Checkbox)</label>
                            <input type="password" name="recaptcha_secret_key"
                                value="{{ $settings['recaptcha_secret_key'] ?? '' }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all font-mono">
                        </div>
                    </div>
                    <div class="mt-8 flex justify-end">
                        <button type="submit"
                            class="px-6 py-2 bg-blue-600 text-white font-bold rounded-md hover:bg-blue-700 shadow-sm transition-all text-sm">Save
                            reCAPTCHA Settings</button>
                    </div>
                </form>
            </div>

            <!-- Google Authenticator Tab -->
            <div x-show="tab === '2fa'" class="space-y-6 animate-in fade-in duration-300">
                <form action="{{ route('admin.settings.integrations.update') }}" method="POST">
                    @csrf
                    <input type="hidden" name="tab" value="2fa">
                    <h3 class="text-sm font-bold text-gray-800 border-l-4 border-blue-600 pl-3 mb-6">Google Authenticator (2FA) for Users</h3>
                    <div class="grid grid-cols-1 gap-6 max-w-2xl">
                        <div class="p-6 bg-blue-50/50 rounded-xl border border-blue-100 mb-4">
                            <div class="flex items-center gap-3 mb-2">
                                <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <h4 class="font-bold text-blue-900 text-sm">Mandatory 2FA for Staff</h4>
                            </div>
                            <p class="text-xs text-blue-700 leading-relaxed mb-4">
                                When enabled, all users with the <strong>role of "User" (Staff/Company Users)</strong> will be required to set up and use Google Authenticator to access their accounts.
                            </p>
                            <div class="flex items-center gap-2">
                                <input type="checkbox" name="google_authenticator_enabled" id="google_authenticator_enabled" value="1"
                                    {{ ($settings['google_authenticator_enabled'] ?? '0') == '1' ? 'checked' : '' }}
                                    class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                <label for="google_authenticator_enabled" class="text-sm font-bold text-gray-900">Enable Google Authenticator for Users</label>
                            </div>
                        </div>
                        
                        <div class="text-xs text-gray-500 bg-gray-50 p-4 rounded-lg border border-gray-100">
                            <h5 class="font-bold text-gray-700 mb-2 uppercase tracking-wider">How it works:</h5>
                            <ul class="list-disc pl-5 space-y-1">
                                <li>Staff will be prompted to link their account with an Authenticator app on their next login.</li>
                                <li>The secret key will be encrypted and stored securely.</li>
                                <li>Admins retain the role of "Admin" and are not affected by this specific toggle.</li>
                            </ul>
                        </div>
                    </div>
                    <div class="mt-8 flex justify-end">
                        <button type="submit"
                            class="px-6 py-2 bg-blue-600 text-white font-bold rounded-md hover:bg-blue-700 shadow-sm transition-all text-sm">Save
                            2FA Settings</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('scripts')
        <style>
            [x-cloak] {
                display: none !important;
            }
        </style>
    @endpush
@endsection