@extends('layouts.admin')

@section('title', 'Appearance Settings')
@section('page_title', 'Appearance Settings')

@section('content')
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Appearance Settings</h1>
        <p class="text-gray-500 text-sm mt-1">Upload default images for various entities in the system.</p>
    </div>

    @if(session('success'))
        <div class="mb-6 p-4 bg-green-50 border border-green-100 text-green-700 rounded-lg flex items-center gap-3">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
            {{ session('success') }}
        </div>
    @endif

    <div class="max-w-4xl">
        <form action="{{ route('admin.settings.appearance.update') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="bg-white rounded-lg border border-gray-100 shadow-sm overflow-hidden">
                <div class="p-6 space-y-8">

                    <!-- Users -->
                    <div class="space-y-6">
                        <h3 class="text-sm font-bold text-gray-800 flex items-center gap-2">
                            <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            Admin/User Default Images
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Male
                                    Placeholder</label>
                                @if(isset($settings['default_user_male_image']))
                                    <div class="mb-3 w-32 h-32 rounded-full overflow-hidden border border-gray-200">
                                        <img src="{{ asset('storage/' . $settings['default_user_male_image']) }}"
                                            class="w-full h-full object-cover">
                                    </div>
                                @endif
                                <input type="file" name="default_user_male_image"
                                    class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-xs file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 transition-colors" />
                            </div>
                            <div>
                                <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Female
                                    Placeholder</label>
                                @if(isset($settings['default_user_female_image']))
                                    <div class="mb-3 w-32 h-32 rounded-full overflow-hidden border border-gray-200">
                                        <img src="{{ asset('storage/' . $settings['default_user_female_image']) }}"
                                            class="w-full h-full object-cover">
                                    </div>
                                @endif
                                <input type="file" name="default_user_female_image"
                                    class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-xs file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100 transition-colors" />
                            </div>
                        </div>
                    </div>

                    <div class="w-full h-px bg-gray-100"></div>

                    <!-- Employees -->
                    <div class="space-y-6">
                        <h3 class="text-sm font-bold text-gray-800 flex items-center gap-2">
                            <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z">
                                </path>
                            </svg>
                            Employee Default Images
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Male
                                    Placeholder</label>
                                @if(isset($settings['default_employee_male_image']))
                                    <div class="mb-3 w-32 h-32 rounded-full overflow-hidden border border-gray-200">
                                        <img src="{{ asset('storage/' . $settings['default_employee_male_image']) }}"
                                            class="w-full h-full object-cover">
                                    </div>
                                @endif
                                <input type="file" name="default_employee_male_image"
                                    class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-xs file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 transition-colors" />
                            </div>
                            <div>
                                <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Female
                                    Placeholder</label>
                                @if(isset($settings['default_employee_female_image']))
                                    <div class="mb-3 w-32 h-32 rounded-full overflow-hidden border border-gray-200">
                                        <img src="{{ asset('storage/' . $settings['default_employee_female_image']) }}"
                                            class="w-full h-full object-cover">
                                    </div>
                                @endif
                                <input type="file" name="default_employee_female_image"
                                    class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-xs file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100 transition-colors" />
                            </div>
                        </div>
                    </div>

                    <div class="w-full h-px bg-gray-100"></div>

                    <!-- Sites & License -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h3 class="text-sm font-bold text-gray-800 flex items-center gap-2 mb-4">
                                <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                                    </path>
                                </svg>
                                Site Default
                            </h3>
                            <div>
                                <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Site Placeholder
                                    Image</label>
                                @if(isset($settings['default_site_image']))
                                    <div class="mb-3 w-full h-40 rounded-lg overflow-hidden border border-gray-200">
                                        <img src="{{ asset('storage/' . $settings['default_site_image']) }}"
                                            class="w-full h-full object-cover">
                                    </div>
                                @endif
                                <input type="file" name="default_site_image"
                                    class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-xs file:font-semibold file:bg-gray-100 file:text-gray-700 hover:file:bg-gray-200 transition-colors" />
                            </div>
                        </div>

                        <div>
                            <h3 class="text-sm font-bold text-gray-800 flex items-center gap-2 mb-4">
                                <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0c0 .883-.393 1.627-1 2.135m3.75 0c-.607-.508-1-1.252-1-2.135">
                                    </path>
                                </svg>
                                License Default
                            </h3>
                            <div>
                                <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">License/ID
                                    Placeholder</label>
                                @if(isset($settings['default_license_image']))
                                    <div class="mb-3 w-full h-40 rounded-lg overflow-hidden border border-gray-200">
                                        <img src="{{ asset('storage/' . $settings['default_license_image']) }}"
                                            class="w-full h-full object-cover">
                                    </div>
                                @endif
                                <input type="file" name="default_license_image"
                                    class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-xs file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100 transition-colors" />
                            </div>
                        </div>
                    </div>
                </div>

                <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 flex items-center justify-end gap-3">
                    <a href="{{ route('admin.dashboard') }}"
                        class="px-4 py-2 rounded-md border border-gray-300 text-gray-700 font-bold hover:bg-white text-sm transition-all shadow-sm">Cancel</a>
                    <button type="submit"
                        class="px-6 py-2 bg-blue-600 text-white rounded-md font-bold hover:bg-blue-700 transition-all shadow-sm text-sm">Save
                        Configuration</button>
                </div>
            </div>
        </form>
    </div>
@endsection