<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Ticket Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
        }

        th {
            bg-color: #f2f2f2;
            font-weight: bold;
        }

        .header {
            margin-bottom: 20px;
        }

        .header h2 {
            margin: 0;
        }

        .header p {
            margin: 2px 0;
            color: #666;
        }

        .badge {
            padding: 2px 5px;
            border-radius: 3px;
            color: white;
            font-weight: bold;
        }

        .badge-good {
            bg-color: #10b981;
            color: white;
        }

        /* Emerald */
        .badge-bad {
            bg-color: #ef4444;
            color: white;
        }

        /* Red */
    </style>
</head>

<body>
    <div class="header">
        <h2>Ticket Report</h2>
        <p>Generated on {{ now()->format('M d, Y H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Ticket #</th>
                <th>Type</th>
                <th>Site / Route</th>
                <th>Patroller</th>
                <th>Description</th>
            </tr>
        </thead>
        <tbody>
            @foreach($tickets as $ticket)
                <tr>
                    <td>{{ $ticket->created_at->format('Y-m-d H:i') }}</td>
                    <td>{{ $ticket->ticket_number }}</td>
                    <td>
                        <span class="badge {{ $ticket->status === 'good' ? 'badge-good' : 'badge-bad' }}">
                            {{ ucfirst($ticket->status) }}
                        </span>
                    </td>
                    <td>
                        {{ $ticket->site->name ?? '-' }} <br>
                        <small>{{ $ticket->patrollerSchedule->route->name ?? '-' }}</small>
                    </td>
                    <td>
                        {{ $ticket->employee->first_name ?? '' }} {{ $ticket->employee->last_name ?? '' }}
                    </td>
                    <td>{{ $ticket->description }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>