<!DOCTYPE html>
<html>

<head>
    <title>Patroller Payout Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            margin-bottom: 20px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 5px;
            text-align: left;
        }

        th {
            background: #f2f2f2;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .employee-section {
            margin-bottom: 30px;
        }

        .grand-total {
            font-weight: bold;
            text-align: right;
            margin-top: 10px;
        }
    </style>
</head>

<body>
    <div class="header">
        <h2>Patroller Payout Report</h2>
        <p>Period: {{ $startDate }} to {{ $endDate }}</p>
    </div>

    @foreach($payoutData as $employeeId => $data)
        <div class="employee-section">
            <h3 style="margin-bottom: 5px;">{{ $data['employee_name'] }} ({{ $data['employee_email'] }})</h3>
            <table>
                <thead>
                    <tr>
                        <th>Route</th>
                        <th>Duty #</th>
                        <th>Start Time</th>
                        <th>End Time</th>
                        <th>Hours</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($data['routes'] as $route)
                        <tr>
                            <td>{{ $route['route_name'] }}</td>
                            <td>#{{ $route['duty_number'] }}</td>
                            <td>{{ $route['start_time'] }}</td>
                            <td>{{ $route['end_time'] }}</td>
                            <td>{{ $route['hours'] }}</td>
                            <td style="text-align: right;">${{ number_format($route['total'], 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr style="font-weight: bold; background: #fafafa;">
                        <td colspan="4" style="text-align: right;">Total:</td>
                        <td>{{ number_format($data['total_hours'], 2) }}</td>
                        <td style="text-align: right;">${{ number_format($data['grand_total'], 2) }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endforeach

</body>

</html>