<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Site Payout Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            margin: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #1e293b;
            padding-bottom: 10px;
        }

        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #1e293b;
        }

        .header p {
            margin: 5px 0;
            color: #64748b;
            font-size: 11px;
        }

        .site-group {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }

        .site-header {
            background-color: #f3f4f6;
            padding: 8px 10px;
            font-weight: bold;
            font-size: 12px;
            color: #1f2937;
            border-bottom: 2px solid #e5e7eb;
            margin-bottom: 5px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        th {
            background-color: #1e293b;
            color: white;
            padding: 8px 6px;
            text-align: left;
            font-size: 8px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        th.text-right {
            text-align: right;
        }

        td {
            padding: 6px;
            border-bottom: 1px solid #e5e7eb;
            font-size: 9px;
        }

        td.text-right {
            text-align: right;
        }

        td.font-bold {
            font-weight: bold;
        }

        .subtotal-row {
            background-color: #f3f4f6;
            font-weight: bold;
        }

        .subtotal-row td {
            padding: 8px 6px;
            border-top: 2px solid #d1d5db;
        }

        .badge {
            display: inline-block;
            padding: 2px 6px;
            font-size: 7px;
            font-weight: bold;
            text-transform: uppercase;
            background-color: #e9d5ff;
            color: #7c3aed;
            border-radius: 3px;
            border: 1px solid #c084fc;
        }
    </style>
</head>

<body>
    <div style="margin-bottom: 20px;">
        @if($company)
            <div style="margin-bottom: 15px; border-bottom: 2px solid #1e293b; padding-bottom: 10px;">
                <h2 style="margin: 0; font-size: 20px; color: #1e293b; text-transform: uppercase;">{{ $company->name }}</h2>
                <p style="margin: 2px 0; font-size: 11px; color: #4b5563;">
                    {{ $company->address_1 }}{{ $company->address_2 ? ', ' . $company->address_2 : '' }}
                </p>
            </div>
        @endif
        <h3 style="margin: 0; color: #334155;">Site Payout Report</h3>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Report Type: <strong>{{ ucfirst($reportType) }}
                Hours</strong></p>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Period:
            {{ \Carbon\Carbon::parse($startDate)->format('M d, Y') }} -
            {{ \Carbon\Carbon::parse($endDate)->format('M d, Y') }}
        </p>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Generated By: {{ auth()->user()->name }}</p>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Date Generated: {{ now()->format('M d, Y H:i') }}</p>
    </div>

    @foreach($groupedPayouts as $siteName => $group)
        <div class="site-group">
            <div class="site-header">{{ $siteName }}</div>

            <table>
                <thead>
                    <tr>
                        <th>Employee</th>
                        <th>Duty Number</th>
                        <th>From Date</th>
                        <th>From Time</th>
                        <th>To Date</th>
                        <th>To Time</th>
                        <th>Total Hrs</th>
                        <th class="text-right">Site Rate</th>
                        <th class="text-right">Total Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($group['items'] as $row)
                        <tr>
                            <td class="font-bold">
                                {{ $row->first_name }} {{ $row->last_name }}
                                @if(isset($row->stat_multiplier) && $row->stat_multiplier > 1)
                                    <span class="badge">STAT</span>
                                @endif
                            </td>
                            <td>{{ $row->duty_number }}</td>
                            <td>{{ \Carbon\Carbon::parse($row->view_start)->format('Y-m-d') }}</td>
                            <td>{{ \Carbon\Carbon::parse($row->view_start)->format('h:i A') }}</td>
                            <td>{{ \Carbon\Carbon::parse($row->view_end)->format('Y-m-d') }}</td>
                            <td>{{ \Carbon\Carbon::parse($row->view_end)->format('h:i A') }}</td>
                            <td class="font-bold">{{ number_format($row->hours, 2) }} hrs</td>
                            <td class="text-right">${{ number_format($row->site_rate, 2) }}</td>
                            <td class="text-right font-bold">${{ number_format($row->total_amount, 2) }}</td>
                        </tr>
                    @endforeach

                    <!-- Subtotal Row -->
                    <tr class="subtotal-row">
                        <td colspan="6" class="text-right">Total</td>
                        <td class="font-bold">{{ number_format($group['total_hours'], 2) }} hrs</td>
                        <td></td>
                        <td class="text-right font-bold">${{ number_format($group['total_amount'], 2) }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    @endforeach
</body>

</html>