@extends('layouts.admin')

@section('title', 'Operational Reports')

@section('content')
    <div class="space-y-6">
        <!-- Company Header -->
        @if($company)
            <div class="flex flex-col gap-1 mb-4">
                <h2 class="text-xl font-bold text-gray-900 tracking-tight uppercase">{{ $company->name }}</h2>
                <p class="text-sm text-gray-500 font-medium italic">
                    {{ $company->address_1 }}{{ $company->address_2 ? ', ' . $company->address_2 : '' }}
                </p>
            </div>
        @endif
        <!-- Filters and Actions -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="{{ route('reports.operational.index') }}" class="space-y-6">
                <input type="hidden" name="type" value="{{ $reportType }}">

                <div class="flex flex-col gap-6">
                    <!-- Row 1: Filters -->
                    <div class="flex flex-col md:flex-row gap-6">
                        <!-- Date Range (Reduced Width) -->
                        <div class="w-full md:w-28">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start
                                Date</label>
                            <input type="date" name="start_date" value="{{ request('start_date') }}"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                        </div>
                        <div class="w-full md:w-28">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End
                                Date</label>
                            <input type="date" name="end_date" value="{{ request('end_date') }}"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                        </div>

                        <!-- Site Filter -->
                        <div class="w-full md:w-48">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Site</label>
                            <select name="site_id"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                                <option value="">All Sites</option>
                                @foreach($sites as $site)
                                    <option value="{{ $site->id }}" {{ request('site_id') == $site->id ? 'selected' : '' }}>
                                        {{ $site->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Employee Filter -->
                        <div class="w-full md:w-48">
                            <label
                                class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Employee</label>
                            <select name="employee_id"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                                <option value="">All Employees</option>
                                @foreach($employees as $emp)
                                    <option value="{{ $emp->id }}" {{ request('employee_id') == $emp->id ? 'selected' : '' }}>
                                        {{ $emp->first_name }} {{ $emp->last_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <!-- Row 2: Search and Actions -->
                    <div class="flex flex-col md:flex-row gap-6 items-end">
                        <!-- Search -->
                        <div class="w-full md:w-60">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Search or Duty
                                #</label>
                            <div class="relative">
                                <input type="text" name="search" value="{{ request('search') }}"
                                    placeholder="Search Duty #..."
                                    class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 pl-9 py-2 shadow-sm">
                                <svg class="w-4 h-4 text-gray-400 absolute left-3 top-2.5" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                </svg>
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="flex items-center gap-2 w-full md:w-auto">
                            <button type="submit"
                                class="h-[38px] px-6 bg-slate-900 text-white text-sm font-medium rounded-lg hover:bg-slate-800 transition-colors whitespace-nowrap shadow-sm">
                                Apply
                            </button>

                            <div class="h-8 w-px bg-gray-200 mx-2 hidden md:block"></div>

                            <div class="flex gap-2 ml-auto md:ml-0">
                                <a href="{{ route('reports.operational.export.excel', request()->all()) }}"
                                    title="Export Excel"
                                    class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 hover:text-green-600 transition-colors shadow-sm">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                        </path>
                                    </svg>
                                </a>
                                <a href="{{ route('reports.operational.export.pdf', request()->all()) }}" title="Export PDF"
                                    class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 hover:text-red-600 transition-colors shadow-sm">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z">
                                        </path>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Report Type Tabs -->
        <div class="flex space-x-1 bg-gray-100 p-1 rounded-xl w-fit">
            @php
                $queryParams = request()->except('type'); 
            @endphp
            <a href="{{ route('reports.operational.index', array_merge($queryParams, ['type' => 'checkin'])) }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ $reportType === 'checkin' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Check-in Report
            </a>
            <a href="{{ route('reports.operational.index', array_merge($queryParams, ['type' => 'checkout'])) }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ $reportType === 'checkout' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Checkout Report
            </a>
            <a href="{{ route('reports.operational.index', array_merge($queryParams, ['type' => 'combined'])) }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ $reportType === 'combined' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Check-IN/OUT Report
            </a>
            <a href="{{ route('reports.operational.index', array_merge($queryParams, ['type' => 'scans_history'])) }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ $reportType === 'scans_history' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Scan History
            </a>
        </div>

        <!-- Data Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        @if($reportType === 'scans_history')
                            <tr>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Scanned At
                                </th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Guard Name
                                </th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Duty #</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Site</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Checkpoint
                                </th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Tour Route
                                </th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Evidence</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Message</th>
                            </tr>
                        @else
                            <tr>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Duty #</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Employee</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Site</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Sched. Start
                                </th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Sched. End
                                </th>

                                @if($reportType === 'checkin' || $reportType === 'combined')
                                    <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Act. Start
                                    </th>
                                @endif

                                @if($reportType === 'checkout' || $reportType === 'combined')
                                    <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Act. End</th>
                                @endif

                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Actions</th>
                            </tr>
                        @endif
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($reports as $row)
                            @if($reportType === 'scans_history')
                                <tr class="hover:bg-gray-50/80 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <div class="flex flex-col">
                                            <span
                                                class="font-bold">{{ \Carbon\Carbon::parse($row->scanned_at)->format('M d, Y') }}</span>
                                            <span
                                                class="text-xs text-gray-500">{{ \Carbon\Carbon::parse($row->scanned_at)->format('H:i:s') }}</span>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-900">
                                        {{ $row->employee_name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-500">
                                        #{{ $row->duty_number }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $row->site_name }}
                                    </td>
                                    <td class="px-6 py-4 text-sm text-gray-900">
                                        <div class="flex flex-col">
                                            <span class="font-semibold">{{ $row->checkpoint_name }}</span>
                                            <span class="text-xs text-gray-500">{{ $row->checkpoint_id_code }}</span>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $row->tour_route_name ?? 'N/A' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-center">
                                        @if($row->evidence_image)
                                            <a href="{{ asset('storage/' . $row->evidence_image) }}" target="_blank"
                                                class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium bg-blue-100 text-blue-700 hover:bg-blue-200">
                                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                                    </path>
                                                </svg>
                                                View
                                            </a>
                                        @else
                                            <span class="text-xs text-gray-400">--</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 text-sm text-gray-600 max-w-xs truncate"
                                        title="{{ $row->employee_message }}">
                                        {{ $row->employee_message ?? '--' }}
                                    </td>
                                </tr>
                            @else
                                <tr class="hover:bg-gray-50/80 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ \Carbon\Carbon::parse($row->schedule_date)->format('M d, Y') }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-500">
                                        #{{ $row->duty_number }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-900">
                                        {{ $row->employee_name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $row->site_name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ \Carbon\Carbon::parse($row->from_datetime)->format('H:i') }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ \Carbon\Carbon::parse($row->to_datetime)->format('H:i') }}
                                    </td>

                                    @if($reportType === 'checkin' || $reportType === 'combined')
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            @if($row->actual_start_at)
                                                <span
                                                    class="text-xs font-bold text-emerald-700 bg-emerald-50 px-2 py-1 rounded border border-emerald-100">
                                                    {{ \Carbon\Carbon::parse($row->actual_start_at)->format('H:i') }}
                                                    @if(\Carbon\Carbon::parse($row->from_datetime)->format('Y-m-d') !== \Carbon\Carbon::parse($row->actual_start_at)->format('Y-m-d'))
                                                        <span
                                                            class="text-[9px] text-gray-500 ml-1">({{ \Carbon\Carbon::parse($row->actual_start_at)->format('d/m') }})</span>
                                                    @endif
                                                </span>
                                            @else
                                                <span class="text-xs text-gray-400 italic">--</span>
                                            @endif
                                        </td>
                                    @endif

                                    @if($reportType === 'checkout' || $reportType === 'combined')
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            @if($row->actual_end_at)
                                                <span
                                                    class="text-xs font-bold text-indigo-700 bg-indigo-50 px-2 py-1 rounded border border-indigo-100">
                                                    {{ \Carbon\Carbon::parse($row->actual_end_at)->format('H:i') }}
                                                    @if(\Carbon\Carbon::parse($row->to_datetime)->format('Y-m-d') !== \Carbon\Carbon::parse($row->actual_end_at)->format('Y-m-d'))
                                                        <span
                                                            class="text-[9px] text-gray-500 ml-1">({{ \Carbon\Carbon::parse($row->actual_end_at)->format('d/m') }})</span>
                                                    @endif
                                                </span>
                                            @else
                                                <span class="text-xs text-gray-400 italic">--</span>
                                            @endif
                                        </td>
                                    @endif

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @php
                                            $statusConfig = [
                                                'completed' => ['bg' => 'bg-emerald-100', 'text' => 'text-emerald-700', 'label' => 'Completed'],
                                                'active' => ['bg' => 'bg-blue-100', 'text' => 'text-blue-700', 'label' => 'Active'],
                                                'upcoming' => ['bg' => 'bg-amber-100', 'text' => 'text-amber-700', 'label' => 'Upcoming'],
                                                'missed' => ['bg' => 'bg-red-100', 'text' => 'text-red-700', 'label' => 'Missed'],
                                            ];
                                            $config = $statusConfig[$row->status] ?? ['bg' => 'bg-gray-100', 'text' => 'text-gray-700', 'label' => ucfirst($row->status)];
                                        @endphp
                                        <span
                                            class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $config['bg'] }} {{ $config['text'] }}">
                                            {{ $config['label'] }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center gap-2">
                                            @if($reportType === 'combined')
                                                <form
                                                    action="{{ route('reports.operational.email-shift', [$row->schedule_id, $row->employee_id]) }}"
                                                    method="POST">
                                                    @csrf
                                                    <button type="submit"
                                                        class="p-1.5 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors"
                                                        title="Email Comprehensive Report to Me">
                                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                                            </path>
                                                        </svg>
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endif
                        @empty
                            <tr>
                                <td colspan="9" class="px-6 py-12 text-center text-gray-400">
                                    <div
                                        class="w-16 h-16 bg-gray-50 rounded-2xl flex items-center justify-center mx-auto mb-4 border border-gray-200">
                                        <svg class="w-8 h-8 text-gray-300" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                    </div>
                                    <p class="text-xs font-bold uppercase tracking-wider">No records found for this report type
                                    </p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($reports->hasPages())
                <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
                    {{ $reports->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection