<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Incident Report</title>
    <style>
        body {
            font-family: sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            font-size: 12px;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        h1 {
            font-size: 18px;
            margin-bottom: 20px;
        }
    </style>
</head>

<body>
    <div style="margin-bottom: 20px;">
        @if($company)
            <div style="margin-bottom: 15px; border-bottom: 2px solid #1e293b; padding-bottom: 10px;">
                <h2 style="margin: 0; font-size: 20px; color: #1e293b; text-transform: uppercase;">{{ $company->name }}</h2>
                <p style="margin: 2px 0; font-size: 11px; color: #4b5563;">
                    {{ $company->address_1 }}{{ $company->address_2 ? ', ' . $company->address_2 : '' }}
                </p>
            </div>
        @endif
        <h3 style="margin: 0; color: #334155;">Incident Report</h3>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Generated By: {{ auth()->user()->name }}</p>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Date Generated: {{ now()->format('M d, Y H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Duty #</th>
                <th>Employee</th>
                <th>Site</th>
                <th>Subject</th>
                <th>Description</th>
            </tr>
        </thead>
        <tbody>
            @foreach($incidents as $incident)
                <tr>
                    <td>{{ \Carbon\Carbon::parse($incident->created_at)->format('Y-m-d H:i') }}</td>
                    <td>{{ $incident->duty_number }}</td>
                    <td>{{ $incident->first_name }} {{ $incident->last_name }}</td>
                    <td>{{ $incident->site_name }}</td>
                    <td>{{ $incident->subject }}</td>
                    <td>{{ $incident->description }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>