@extends('layouts.user')

@section('title', 'Banned Employees Report')

@section('content')
    <div class="space-y-6">
        <!-- Filters and Actions -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="{{ route('reports.operational.banned') }}" class="space-y-6">

                <div class="grid grid-cols-1 md:grid-cols-12 gap-4 items-end">

                    <!-- Site Filter (Searchable) -->
                    <div class="md:col-span-3" x-data="searchableSelect({
                                        options: {{ $sites->map(fn($s) => ['value' => $s->id, 'label' => $s->name])->values()->toJson() }},
                                        value: '{{ request('site_id') }}',
                                        placeholder: 'All Sites'
                                    })" @click.outside="open = false">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Site</label>
                        <div class="relative">
                            <div @click="open = !open"
                                class="w-full bg-white border border-gray-300 rounded-lg px-3 py-2 text-sm shadow-sm cursor-pointer flex justify-between items-center h-[38px] hover:border-blue-400 transition-colors">
                                <span x-text="selectedLabel" class="truncate text-gray-700"></span>
                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </div>
                            <input type="hidden" name="site_id" :value="value">

                            <div x-show="open" x-transition.origin.top.left x-cloak
                                class="absolute z-50 w-full bg-white border border-gray-300 rounded-lg mt-1 shadow-xl max-h-60 overflow-hidden flex flex-col">
                                <div class="p-2 border-b border-gray-100 bg-gray-50/50">
                                    <input type="text" x-model="search" placeholder="Search site..."
                                        class="w-full text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5 px-2">
                                </div>
                                <ul class="overflow-y-auto flex-1 p-1">
                                    <li @click="select({value: '', label: 'All Sites'})"
                                        class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer transition-colors"
                                        :class="{'bg-blue-50 text-blue-700 font-medium': value === ''}">
                                        All Sites
                                    </li>
                                    <template x-for="option in filteredOptions" :key="option.value">
                                        <li @click="select(option)"
                                            class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer truncate transition-colors"
                                            :class="{'bg-blue-50 text-blue-700 font-medium': value == option.value}"
                                            x-text="option.label">
                                        </li>
                                    </template>
                                    <li x-show="filteredOptions.length === 0"
                                        class="px-3 py-4 text-xs text-gray-400 text-center italic">
                                        No sites found
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Search -->
                    <div class="md:col-span-3">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Search
                            Employee</label>
                        <div class="relative">
                            <input type="text" name="search" value="{{ request('search') }}" placeholder="Search by Name..."
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 pl-8 py-2 shadow-sm">
                            <svg class="w-4 h-4 text-gray-400 absolute left-2.5 top-2.5" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="md:col-span-2 flex items-center justify-end gap-2">
                        <button type="submit"
                            class="h-[38px] px-4 bg-slate-900 text-white text-sm font-medium rounded-lg hover:bg-slate-800 transition-colors shadow-sm">
                            Apply Filter
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Report Type Tabs -->
        <div class="flex space-x-1 bg-gray-100 p-1 rounded-xl w-fit">
            <a href="{{ route('reports.operational.incidents') }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.incidents') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Incident Summary
            </a>
            <a href="{{ route('reports.operational.incident_counts') }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.incident_counts') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Incident Counts
            </a>
            <a href="{{ route('reports.operational.banned') }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.banned') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Banned Employees
            </a>
            <a href="{{ route('reports.operational.passwords') }}"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ request()->routeIs('reports.operational.passwords') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Credentials
            </a>
        </div>

        <!-- Grouped Banned Employees -->
        <div class="space-y-6">
            @forelse($bannedEmployees as $employeeName => $bans)
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                    <div class="p-4 bg-gray-50 border-b border-gray-100 flex justify-between items-center">
                        <h3 class="text-sm font-bold text-gray-800 flex items-center gap-2">
                            <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            {{ $employeeName }}
                        </h3>
                        <span class="text-xs font-medium text-red-600 bg-red-50 px-2 py-1 rounded-md border border-red-100">
                            Banned from {{ $bans->count() }} Site(s)
                        </span>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="w-full text-left border-collapse">
                            <thead class="bg-white border-b border-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider pl-6">Site
                                        Name</th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Reason
                                    </th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Banned At
                                    </th>
                                    <th
                                        class="px-4 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-right pr-6">
                                        Action</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-50">
                                @foreach($bans as $ban)
                                    <tr class="hover:bg-gray-50/50 transition-all">
                                        <td class="px-4 py-3 text-xs font-medium text-gray-700 pl-6">
                                            {{ $ban->name }}
                                        </td>
                                        <td class="px-4 py-3 text-xs text-gray-500 italic">
                                            "{{ $ban->pivot->reason ?? 'No reason provided' }}"
                                        </td>
                                        <td class="px-4 py-3 text-xs text-gray-400">
                                            {{ \Carbon\Carbon::parse($ban->pivot->banned_at)->format('M d, Y H:i') }}
                                        </td>
                                        <td class="px-4 py-3 text-right pr-6">
                                            <form
                                                action="{{ route('sites.unban', ['site' => $ban->id, 'employee' => $ban->pivot->employee_id]) }}"
                                                method="POST"
                                                onsubmit="return confirm('Are you sure you want to unban this employee from the site?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit"
                                                    class="text-xs font-bold text-blue-600 hover:text-blue-800 hover:underline transition-colors">
                                                    Unban
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @empty
                <div class="bg-dashed border-2 border-gray-200 rounded-xl p-12 text-center">
                    <div class="w-16 h-16 bg-gray-50 rounded-2xl flex items-center justify-center mx-auto mb-4 text-gray-300">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636">
                            </path>
                        </svg>
                    </div>
                    <h3 class="text-sm font-bold text-gray-500">No Banned Employees Found</h3>
                    <p class="text-xs text-gray-400 mt-1">There are currently no active bans matching your criteria.</p>
                </div>
            @endforelse
        </div>
    </div>
@endsection