@extends('layouts.admin')

@section('title', 'Define New Capability')
@section('page_title', 'Access Control')

@section('content')
    <div class="max-w-2xl mx-auto">
        <div class="mb-6">
            <div class="flex items-center gap-2 text-sm text-gray-500 mb-2">
                <a href="{{ route('admin.permissions.index') }}" class="hover:text-blue-600 transition-colors">Permissions
                    Ledger</a>
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
                <span class="text-gray-900 font-medium">Create</span>
            </div>
            <h1 class="text-2xl font-bold text-gray-800">Define New Capability</h1>
            <p class="text-sm text-gray-500 mt-1">Establish specific function-level permissions.</p>
        </div>

        <form action="{{ route('admin.permissions.store') }}" method="POST">
            @csrf

            <div class="bg-white rounded-lg border border-gray-100 shadow-sm overflow-hidden">
                <div class="p-6 space-y-6">
                    <div>
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Capability Identifier <span
                                class="text-red-500">*</span></label>
                        <div class="relative group">
                            <input type="text" name="name" value="{{ old('name') }}" required
                                placeholder="e.g. view_analytics"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all placeholder:text-gray-400">
                        </div>
                        @error('name')
                            <p class="mt-1 text-xs text-red-500">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 flex items-center justify-end gap-3">
                    <a href="{{ route('admin.permissions.index') }}"
                        class="px-4 py-2 rounded-md border border-gray-300 text-gray-700 font-bold hover:bg-white text-sm transition-all shadow-sm">Cancel</a>
                    <button type="submit"
                        class="px-6 py-2 bg-blue-600 text-white rounded-md font-bold hover:bg-blue-700 transition-all shadow-sm text-sm">Create
                        Permission</button>
                </div>
            </div>
        </form>
    </div>
@endsection