<!DOCTYPE html>
<html lang="en">

<head>


    <script
        src="https://www.google.com/recaptcha/enterprise.js?render=6LftSVAsAAAAAPUHF0fMj16lUhFc_I8jO9JQWxgG"></script>
    <script>
        function onClick(e) {
            e.preventDefault();
            grecaptcha.enterprise.ready(async () => {
                const token = await grecaptcha.enterprise.execute('6LftSVAsAAAAAPUHF0fMj16lUhFc_I8jO9JQWxgG', { action: 'LOGIN' });
            });
        }
    </script>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Shift Matrix</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
    @if(\App\Models\Setting::where('key', 'recaptcha_enabled')->value('value') == '1' && app()->environment('production'))
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    @endif
</head>

<body class="bg-gray-50 min-h-screen flex items-center justify-center p-6 antialiased">
    <div class="w-full max-w-md">
        <div class="bg-white rounded-2xl shadow-xl shadow-gray-200/50 p-10">
            <div class="mb-10 text-center">
                <div
                    class="w-16 h-16 bg-blue-600 rounded-2xl flex items-center justify-center text-white text-2xl font-bold mx-auto mb-6 shadow-lg shadow-blue-200">
                    G
                </div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">Welcome Back</h1>
                <p class="text-gray-500 text-sm">Sign in to manage Shift Matrix</p>
            </div>

            @if ($errors->any())
                <div class="mb-6 p-4 bg-red-50 rounded-xl border border-red-100">
                    <ul class="text-sm text-red-600 font-medium">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.login') }}" method="POST" class="space-y-6">
                @csrf
                <div>
                    <label for="email" class="block text-sm font-semibold text-gray-700 mb-2">Email Address</label>
                    <input type="email" id="email" name="email" value="{{ old('email') }}" required
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900"
                        placeholder="admin@example.com">
                </div>
                <div>
                    <label for="password" class="block text-sm font-semibold text-gray-700 mb-2">Password</label>
                    <input type="password" id="password" name="password" required
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900"
                        placeholder="••••••••">
                </div>

                @if(\App\Models\Setting::where('key', 'recaptcha_enabled')->value('value') == '1' && \App\Models\Setting::where('key', 'recaptcha_site_key')->value('value') && app()->environment('production'))
                    <div class="g-recaptcha"
                        data-sitekey="{{ \App\Models\Setting::where('key', 'recaptcha_site_key')->value('value') }}"></div>
                @endif

                <button type="submit"
                    class="w-full bg-blue-600 text-white font-bold py-4 rounded-xl hover:bg-blue-700 transform transition-all active:scale-[0.98] shadow-lg shadow-blue-200">
                    Sign In
                </button>
            </form>
        </div>
        <p class="mt-8 text-center text-gray-400 text-sm">
            &copy; {{ date('Y') }} Shift Matrix. All rights reserved.
            <br>
            Developed by <a href="https://softbuiltsolutions.com/" target="_blank"
                class="text-blue-500 hover:text-blue-400 font-medium font-sans">soft Built Solutions</a>
        </p>
    </div>
</body>

</html>