@extends('layouts.admin')

@section('title', 'Countries')
@section('page_title', 'Countries')

@section('content')
<div class="mb-6 flex flex-col md:flex-row md:items-center justify-between gap-4">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Countries</h1>
        <p class="text-gray-500 text-sm">Manage global countries and their codes.</p>
    </div>
    <div class="flex items-center gap-3">
        <a href="{{ route('admin.countries.export-pdf') }}" class="p-2.5 bg-white border border-gray-200 text-gray-700 rounded-xl hover:bg-gray-50 transition-all shadow-sm group" title="Export PDF">
            <svg class="w-5 h-5 text-red-500 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path></svg>
        </a>
        <a href="{{ route('admin.countries.create') }}" class="inline-flex items-center gap-2 bg-blue-600 text-white px-4 py-2.5 rounded-xl font-semibold hover:bg-blue-700 transition-all shadow-lg shadow-blue-200">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg>
            Add Country
        </a>
    </div>
</div>

@if(session('success'))
    <div class="mb-6 p-4 bg-emerald-50 border border-emerald-100 text-emerald-700 rounded-xl flex items-center gap-3">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
        {{ session('success') }}
    </div>
@endif

<div class="mb-6 flex flex-col md:flex-row md:items-center gap-4">
    <div class="flex-1">
        <form action="{{ route('admin.countries.index') }}" method="GET" class="flex gap-2">
            <div class="relative flex-1 group">
                <input type="text" name="search" value="{{ request('search') }}" placeholder="Search by country name or code..." 
                    class="w-full pl-11 pr-4 py-3 bg-white border border-gray-200 rounded-2xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none">
                <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-blue-500 transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                </div>
                @if(request('search'))
                    <a href="{{ route('admin.countries.index') }}" class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 hover:text-red-500 transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                    </a>
                @endif
            </div>
            <button type="submit" class="bg-white border border-gray-200 px-6 py-3 rounded-2xl font-bold text-gray-700 hover:bg-gray-50 transition-all focus:ring-4 focus:ring-gray-100">
                Search
            </button>
        </form>
    </div>
</div>

<div class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden">
    <table class="w-full text-left border-collapse">
        <thead class="bg-[#1e293b]">
            <tr>
                <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">
                    <a href="{{ route('admin.countries.index', array_merge(request()->query(), ['sort' => request('sort') === 'name_asc' ? 'name_desc' : 'name_asc'])) }}" class="flex items-center gap-1 group text-white hover:text-blue-200 transition-colors">
                        Country Name
                        <span class="flex flex-col">
                            @if(request('sort') === 'name_asc')
                                <svg class="w-3 h-3 text-blue-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M14.707 12.707a1 1 0 01-1.414 0L10 9.414l-3.293 3.293a1 1 0 01-1.414-1.414l4-4a1 1 0 011.414 0l4 4a1 1 0 010 1.414z" clip-rule="evenodd"></path></svg>
                            @elseif(request('sort') === 'name_desc')
                                <svg class="w-3 h-3 text-blue-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
                            @else
                                <svg class="w-3 h-3 opacity-0 group-hover:opacity-100 text-slate-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
                            @endif
                        </span>
                    </a>
                </th>
                <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">ISO2</th>
                <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">ISO3</th>
                <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Phone Code</th>
                <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Status</th>
                <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider text-right">Actions</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-50">
            @forelse($countries as $country)
                <tr class="hover:bg-gray-50/50 transition-colors">
                    <td class="px-6 py-4 text-sm font-bold text-gray-900">{{ $country->name }}</td>
                    <td class="px-6 py-4 text-sm font-medium text-gray-500">{{ $country->iso2 }}</td>
                    <td class="px-6 py-4 text-sm font-medium text-gray-500">{{ $country->iso3 }}</td>
                    <td class="px-6 py-4 text-sm font-medium text-gray-500">+{{ $country->phone_code }}</td>
                    <td class="px-6 py-4">
                        <button type="button" 
                            onclick="toggleStatus('{{ route('admin.countries.toggle-status', $country) }}', this)"
                            class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 {{ $country->active ? 'bg-blue-600' : 'bg-gray-200' }}" 
                            role="switch" 
                            aria-checked="{{ $country->active ? 'true' : 'false' }}">
                            <span aria-hidden="true" class="pointer-events-none inline-block h-5 w-5 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out {{ $country->active ? 'translate-x-5' : 'translate-x-0' }}"></span>
                        </button>
                    </td>
                    <td class="px-6 py-4 text-right">
                        <div class="flex items-center justify-end gap-2">
                            <a href="{{ route('admin.countries.edit', $country) }}" class="p-2 text-gray-400 hover:text-blue-600 hover:bg-blue-50 rounded-lg transition-all" title="Edit">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
                            </a>
                            <button type="button" 
                                onclick="openDeleteModal('{{ route('admin.countries.destroy', $country) }}', '{{ $country->name }}')"
                                class="p-2 text-gray-400 hover:text-red-600 hover:bg-red-50 rounded-lg transition-all"
                                title="Delete">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                            </button>
                        </div>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                        No countries found. Click "Add Country" to create one.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
    @if($countries->hasPages())
        <div class="px-6 py-4 border-t border-gray-50">
            {{ $countries->links() }}
        </div>
    @endif
</div>
@endsection
