@extends('layouts.admin')

@section('title', 'Add Country')
@section('page_title', 'Add Country')

@section('content')
<div class="mb-6">
    <a href="{{ route('admin.countries.index') }}" class="inline-flex items-center gap-2 text-gray-500 hover:text-blue-600 transition-colors group">
        <svg class="w-5 h-5 transition-transform group-hover:-translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg>
        Back to Countries
    </a>
</div>

<div class="max-w-2xl">
    <form action="{{ route('admin.countries.store') }}" method="POST" class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden">
        @csrf
        <div class="p-8 border-b border-gray-50">
            <h2 class="text-xl font-bold text-gray-900">Country Details</h2>
            <p class="text-gray-500 text-sm">Enter the basic info for the new country.</p>
        </div>

        <div class="p-8 space-y-6">
            <div>
                <label for="name" class="block text-sm font-bold text-gray-700 mb-2">Country Name</label>
                <input type="text" name="name" id="name" value="{{ old('name') }}" required
                    class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none"
                    placeholder="e.g. United Kingdom">
                @error('name') <p class="mt-2 text-sm text-red-600">{{ $message }}</p> @enderror
            </div>

            <div class="grid grid-cols-2 gap-6">
                <div>
                    <label for="iso2" class="block text-sm font-bold text-gray-700 mb-2">ISO2 Code</label>
                    <input type="text" name="iso2" id="iso2" value="{{ old('iso2') }}" maxlength="2"
                        class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none"
                        placeholder="e.g. GB">
                    @error('iso2') <p class="mt-2 text-sm text-red-600">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label for="iso3" class="block text-sm font-bold text-gray-700 mb-2">ISO3 Code</label>
                    <input type="text" name="iso3" id="iso3" value="{{ old('iso3') }}" maxlength="3"
                        class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none"
                        placeholder="e.g. GBR">
                    @error('iso3') <p class="mt-2 text-sm text-red-600">{{ $message }}</p> @enderror
                </div>
            </div>

            <div>
                <label for="phone_code" class="block text-sm font-bold text-gray-700 mb-2">Phone Code</label>
                <div class="relative">
                    <span class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 font-bold">+</span>
                    <input type="text" name="phone_code" id="phone_code" value="{{ old('phone_code') }}"
                        class="w-full pl-8 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none"
                        placeholder="e.g. 44">
                </div>
                @error('phone_code') <p class="mt-2 text-sm text-red-600">{{ $message }}</p> @enderror
            </div>

            <div class="flex items-center gap-3 p-4 bg-gray-50 rounded-xl">
                <input type="checkbox" name="active" id="active" value="1" {{ old('active', true) ? 'checked' : '' }}
                    class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                <label for="active" class="text-sm font-bold text-gray-700">Country is Active</label>
            </div>
        </div>

        <div class="p-8 bg-gray-50/50 border-t border-gray-50 flex justify-end gap-4">
            <a href="{{ route('admin.countries.index') }}" class="px-6 py-3 text-gray-600 font-bold hover:text-gray-900 transition-colors">Cancel</a>
            <button type="submit" class="bg-blue-600 text-white px-8 py-3 rounded-xl font-bold hover:bg-blue-700 transition-all shadow-lg shadow-blue-100">
                Create Country
            </button>
        </div>
    </form>
</div>
@endsection
