@extends('layouts.admin')

@section('title', 'Add Company')
@section('page_title', 'Companies')

@section('content')
    <div class="mb-6 flex items-center gap-4">
        <a href="{{ route('admin.companies.index') }}"
            class="p-2 text-gray-400 hover:text-gray-900 hover:bg-gray-100 rounded-xl transition-all">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                </path>
            </svg>
        </a>
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Add Company</h1>
            <p class="text-gray-500 text-sm">Create a new company profile.</p>
        </div>
    </div>

    <form action="{{ route('admin.companies.store') }}" method="POST" enctype="multipart/form-data" x-data="{ 
            branches: [{ name: '', branch_code: '', contact_person: '', contact_phone: '', contact_email: '', address: '' }],
            addBranch() {
                this.branches.push({ name: '', branch_code: '', contact_person: '', contact_phone: '', contact_email: '', address: '' });
            },
            removeBranch(index) {
                if (this.branches.length > 1) {
                    this.branches.splice(index, 1);
                }
            }
        }">
        @csrf
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Left Column: Basic & Additional Info -->
            <div class="lg:col-span-2 space-y-8">
                <!-- Basic Information -->
                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-8 space-y-6">
                    <div class="flex items-center gap-2 mb-4">
                        <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                        <h3 class="text-lg font-bold text-gray-900">Basic Information</h3>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="md:col-span-2 grid grid-cols-1 md:grid-cols-3 gap-6">
                            <div class="md:col-span-2">
                                <label for="name" class="block text-sm font-semibold text-gray-700 mb-2">Company Name <span
                                        class="text-red-500">*</span></label>
                                <input type="text" id="name" name="name" value="{{ old('name') }}" required
                                    class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900 @error('name') border-red-500 @enderror">
                                @error('name') <p class="mt-1 text-xs text-red-500 font-medium">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label for="company_type" class="block text-sm font-semibold text-gray-700 mb-2">Company
                                    Type</label>
                                <select id="company_type" name="company_type"
                                    class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900">
                                    <option value="">Select Type</option>
                                    <option value="Private Limited" {{ old('company_type') == 'Private Limited' ? 'selected' : '' }}>Private Limited</option>
                                    <option value="Public Limited" {{ old('company_type') == 'Public Limited' ? 'selected' : '' }}>Public Limited</option>
                                    <option value="Partnership" {{ old('company_type') == 'Partnership' ? 'selected' : '' }}>
                                        Partnership</option>
                                    <option value="Sole Proprietorship" {{ old('company_type') == 'Sole Proprietorship' ? 'selected' : '' }}>Sole Proprietorship</option>
                                    <option value="LLC" {{ old('company_type') == 'LLC' ? 'selected' : '' }}>LLC</option>
                                </select>
                            </div>
                        </div>

                        <div>
                            <label for="tagline" class="block text-sm font-semibold text-gray-700 mb-2">Tagline</label>
                            <input type="text" id="tagline" name="tagline" value="{{ old('tagline') }}"
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900 @error('tagline') border-red-500 @enderror">
                        </div>

                        <div>
                            <label for="contact_person" class="block text-sm font-semibold text-gray-700 mb-2">Contact
                                Person <span class="text-red-500">*</span></label>
                            <input type="text" id="contact_person" name="contact_person" value="{{ old('contact_person') }}"
                                required
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900 @error('contact_person') border-red-500 @enderror">
                        </div>

                        <div>
                            <label for="mobile_number" class="block text-sm font-semibold text-gray-700 mb-2">Mobile Number
                                <span class="text-red-500">*</span></label>
                            <input type="text" id="mobile_number" name="mobile_number" value="{{ old('mobile_number') }}"
                                required
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900 @error('mobile_number') border-red-500 @enderror">
                        </div>

                        <div>
                            <label for="email" class="block text-sm font-semibold text-gray-700 mb-2">Email Address <span
                                    class="text-red-500">*</span></label>
                            <input type="email" id="email" name="email" value="{{ old('email') }}" required
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900 @error('email') border-red-500 @enderror">
                        </div>
                    </div>
                </div>

                <!-- CEO / Director Info -->
                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-8 space-y-6">
                    <div class="flex items-center gap-2 mb-4">
                        <span class="w-1.5 h-6 bg-emerald-600 rounded-full"></span>
                        <h3 class="text-lg font-bold text-gray-900">Director / CEO Information</h3>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div>
                            <label for="ceo_name" class="block text-sm font-semibold text-gray-700 mb-2">Full Name</label>
                            <input type="text" id="ceo_name" name="ceo_name" value="{{ old('ceo_name') }}"
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900">
                        </div>
                        <div>
                            <label for="ceo_email" class="block text-sm font-semibold text-gray-700 mb-2">Email
                                Address</label>
                            <input type="email" id="ceo_email" name="ceo_email" value="{{ old('ceo_email') }}"
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900">
                        </div>
                        <div>
                            <label for="ceo_phone" class="block text-sm font-semibold text-gray-700 mb-2">Contact
                                Number</label>
                            <input type="text" id="ceo_phone" name="ceo_phone" value="{{ old('ceo_phone') }}"
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900">
                        </div>
                    </div>
                </div>

                <!-- Branches Section -->
                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-8 space-y-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center gap-2">
                            <span class="w-1.5 h-6 bg-purple-600 rounded-full"></span>
                            <h3 class="text-lg font-bold text-gray-900">Company Branches</h3>
                        </div>
                        <button type="button" @click="addBranch()"
                            class="text-sm font-bold text-blue-600 hover:text-blue-700 flex items-center gap-1 transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4">
                                </path>
                            </svg>
                            Add Branch
                        </button>
                    </div>

                    <div class="space-y-4">
                        <template x-for="(branch, index) in branches" :key="index">
                            <div
                                class="p-6 bg-gray-50 rounded-2xl border border-gray-100 relative group transition-all hover:shadow-md">
                                <button type="button" @click="removeBranch(index)" x-show="branches.length > 1"
                                    class="absolute top-4 right-4 p-2 text-gray-400 hover:text-red-500 transition-colors">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                </button>

                                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                                    <div>
                                        <label
                                            class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-1">Branch
                                            Name</label>
                                        <input type="text" :name="`branches[${index}][name]`" x-model="branch.name" required
                                            class="w-full px-3 py-2 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 text-sm font-bold">
                                    </div>
                                    <div>
                                        <label
                                            class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-1">Branch
                                            Code</label>
                                        <input type="text" :name="`branches[${index}][branch_code]`"
                                            x-model="branch.branch_code"
                                            class="w-full px-3 py-2 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 text-sm font-bold">
                                    </div>
                                    <div>
                                        <label
                                            class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-1">Contact
                                            Person</label>
                                        <input type="text" :name="`branches[${index}][contact_person]`"
                                            x-model="branch.contact_person"
                                            class="w-full px-3 py-2 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 text-sm font-bold">
                                    </div>
                                    <div>
                                        <label
                                            class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-1">Phone</label>
                                        <input type="text" :name="`branches[${index}][contact_phone]`"
                                            x-model="branch.contact_phone"
                                            class="w-full px-3 py-2 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 text-sm font-bold">
                                    </div>
                                    <div>
                                        <label
                                            class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-1">Email</label>
                                        <input type="email" :name="`branches[${index}][contact_email]`"
                                            x-model="branch.contact_email"
                                            class="w-full px-3 py-2 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 text-sm font-bold">
                                    </div>
                                    <div class="md:col-span-2 lg:col-span-1">
                                        <label
                                            class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-1">Full
                                            Address</label>
                                        <input type="text" :name="`branches[${index}][address]`" x-model="branch.address"
                                            class="w-full px-3 py-2 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 text-sm font-bold">
                                    </div>
                                </div>
                            </div>
                        </template>
                    </div>
                </div>

                <!-- Address & Operational Info -->
                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-8 space-y-6">
                    <div class="flex items-center gap-2 mb-4">
                        <span class="w-1.5 h-6 bg-amber-500 rounded-full"></span>
                        <h3 class="text-lg font-bold text-gray-900">Head Office & Operations</h3>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="website" class="block text-sm font-semibold text-gray-700 mb-2">Official
                                Website</label>
                            <input type="url" id="website" name="website" value="{{ old('website') }}"
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900"
                                placeholder="https://example.com">
                        </div>
                        <div>
                            <label for="operational_areas"
                                class="block text-sm font-semibold text-gray-700 mb-2">Operational Areas</label>
                            <input type="text" id="operational_areas" name="operational_areas"
                                value="{{ old('operational_areas') }}"
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900"
                                placeholder="e.g. North America, Ontario, Toronto">
                        </div>
                        <div class="md:col-span-2">
                            <label for="address_1" class="block text-sm font-semibold text-gray-700 mb-2">Head Office
                                Address (Line 1) <span class="text-red-500">*</span></label>
                            <textarea id="address_1" name="address_1" rows="2" required
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900">{{ old('address_1') }}</textarea>
                        </div>
                        <div class="md:col-span-2">
                            <label for="address_2" class="block text-sm font-semibold text-gray-700 mb-2">Head Office
                                Address (Line 2)</label>
                            <textarea id="address_2" name="address_2" rows="2"
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900">{{ old('address_2') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column: Settings & Media -->
            <div class="space-y-8">
                <!-- Legal Card -->
                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-8 space-y-6">
                    <div class="flex items-center gap-2 mb-4">
                        <span class="w-1.5 h-6 bg-slate-700 rounded-full"></span>
                        <h3 class="text-lg font-bold text-gray-900">Tax & Registration</h3>
                    </div>

                    <div class="space-y-4">
                        <div>
                            <label for="service_tax_number" class="block text-sm font-semibold text-gray-700 mb-2">Service
                                Tax Number</label>
                            <input type="text" id="service_tax_number" name="service_tax_number"
                                value="{{ old('service_tax_number') }}"
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900">
                        </div>
                        <div>
                            <label for="hst" class="block text-sm font-semibold text-gray-700 mb-2">HST</label>
                            <input type="text" id="hst" name="hst" value="{{ old('hst') }}"
                                class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900">
                        </div>
                    </div>
                </div>

                <!-- Settings Card -->
                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-8 space-y-6">
                    <div class="flex items-center gap-2 mb-4">
                        <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                        <h3 class="text-lg font-bold text-gray-900">Configuration</h3>
                    </div>

                    <div>
                        <label for="time_zone_id" class="block text-sm font-semibold text-gray-700 mb-2">Time Zone <span
                                class="text-red-500">*</span></label>
                        <select id="time_zone_id" name="time_zone_id" required
                            class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all text-gray-900">
                            <option value="">Select Time Zone</option>
                            @foreach($timeZones as $tz)
                                <option value="{{ $tz->id }}" {{ old('time_zone_id') == $tz->id ? 'selected' : '' }}>
                                    {{ $tz->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label for="logo" class="block text-sm font-semibold text-gray-700 mb-2">Company Logo <span
                                class="text-red-500">*</span></label>
                        <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-2xl hover:border-blue-400 transition-colors cursor-pointer"
                            onclick="document.getElementById('logo').click()">
                            <div class="space-y-1 text-center">
                                <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none"
                                    viewBox="0 0 48 48" aria-hidden="true">
                                    <path
                                        d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                                <div class="flex text-sm text-gray-600">
                                    <span
                                        class="relative cursor-pointer bg-white rounded-md font-medium text-blue-600 hover:text-blue-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-blue-500">
                                        Upload a file
                                    </span>
                                    <p class="pl-1">or drag and drop</p>
                                </div>
                                <p class="text-xs text-gray-500">PNG, JPG, GIF up to 2MB</p>
                            </div>
                            <input id="logo" name="logo" type="file" class="sr-only" required onchange="previewLogo(this)">
                        </div>

                        <div id="logo-preview-container" class="mt-4 hidden text-center">
                            <img id="logo-preview" src="#" alt="Logo Preview"
                                class="mx-auto h-32 w-auto object-contain rounded-xl border border-gray-100 p-2">
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex flex-col gap-3">
                    <button type="submit"
                        class="w-full bg-blue-600 text-white font-bold px-8 py-4 rounded-xl hover:bg-blue-700 transform transition-all active:scale-[0.98] shadow-lg shadow-blue-200">
                        Create Company
                    </button>
                    <a href="{{ route('admin.companies.index') }}"
                        class="w-full text-center text-gray-500 font-bold px-8 py-4 rounded-xl hover:bg-gray-100 transition-all bg-white border border-gray-100">
                        Cancel
                    </a>
                </div>
            </div>
        </div>
    </form>

    <script>
        function previewLogo(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    document.getElementById('logo-preview').src = e.target.result;
                    document.getElementById('logo-preview-container').classList.remove('hidden');
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endsection